/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: main.c,v 4.17 1998/12/26 22:28:00 erik Rel $";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include "z80.h"
#include "mem.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#include "emul.h"
#ifdef JOY
#include "joystick.h"
#endif
#include "machine.h"
#ifdef REGISTERED
#include "monitor.h"
#endif
#ifdef PRINTER
#include "printer.h"
#endif
#include "screen.h"
#include "snapshot.h"
#ifdef REGISTERED
#include "vtp.h"
#endif
#include "main.h"
static int initEmulator(int, char **);
static void quitEmulator(void);
static void catchSignals(int);
char *ProgName;
const char *Version;
time_t StartupTime;
int StdinFileType, StdoutFileType;
int
main(int argc, char **argv)
{
char *s;
if ((s = strrchr(argv[0], '/')) != NULL)
{
ProgName = ++s;
}
else
{
ProgName = argv[0];
}
#ifdef DEMO
Version = "XZX " VERSION "D";
#elif REGISTERED
Version = "XZX " VERSION "R";
#else
Version = "XZX " VERSION;
#endif
StartupTime = time(NULL);
if (EXPIRATION && ((time_t)EXPIRATION < StartupTime))
{
(void)fprintf(stderr,
"Sorry, your version has expired! Get a new one.\n");
return 1;
}
if (!initEmulator(argc, argv))
{
Emulate();
}
Quit(1);
return 0;
}
static int
initEmulator(int ac, char **av)
{
struct sigaction sigact;
int i;
sigact.sa_handler = SIG_IGN;
(void)sigemptyset(&sigact.sa_mask);
#ifdef SA_RESTART
sigact.sa_flags = SA_RESTART;
#else
sigact.sa_flags = 0;
#endif
(void)sigaction(SIGINT,   &sigact, NULL);
(void)sigaction(SIGHUP,   &sigact, NULL);
(void)sigaction(SIGTERM,  &sigact, NULL);
(void)sigaction(SIGQUIT,  &sigact, NULL);
#ifdef SIG_XCPU
(void)sigaction(SIG_XCPU, &sigact, NULL);
#endif
sigact.sa_handler = catchSignals;
(void)sigaction(SIGSEGV,  &sigact, NULL);
InitX(&ac, av);
SetBlocking(STDIN_FILENO, 1);
StdinFileType = ClassifyDescriptor(STDIN_FILENO);
SetBlocking(STDOUT_FILENO, 1);
StdoutFileType = ClassifyDescriptor(STDOUT_FILENO);
OnQuit(quitEmulator);
MemoryInit();
MachineInit();
Z80_Init();
#ifdef AUDIO
AudioInit();
#endif
#ifdef JOY
JoyInit();
#endif
#ifdef PRINTER
PrinterInit();
#endif
DialogInit(!av[1]);
#ifdef REGISTERED
VtpInit();
DebuggerInit();
#endif
if (!av[1] || ReadSnapshot(av[1]) == -1)
{
srand((unsigned int)getpid());
for (i = DFILE; i < (DFILE + PIXEL_LENGTH + ATTR_LENGTH); i++)
{
MEM(i) = (uns8)rand();
}
}
ScreenRefresh();
(void)sigaction(SIGINT,  &sigact, NULL);
(void)sigaction(SIGHUP,  &sigact, NULL);
(void)sigaction(SIGTERM, &sigact, NULL);
(void)sigaction(SIGQUIT, &sigact, NULL);
(void)sigaction(SIGSEGV, &sigact, NULL);
return 0;
}
static void
quitEmulator(void)
{
SetBlocking(STDIN_FILENO, 0);
SetBlocking(STDOUT_FILENO, 0);
}
static void
catchSignals(int signo)
{
static int core = 0;
if (signo == SIGSEGV)
{
if (++core > 1)
{
exit(3);
}
Msg(M_ERR, "signal handler caught signal SIGSEGV");
Msg(M_ERR, "send a bug report to xzx-bug@fantasy.muc.de");
}
Quit(2);
}
