#include "cs.h"                 /*                               MAIN.C */
#include "soundio.h"
#include <ctype.h>              /* For isdigit */

#ifdef SYMANTEC
#define main mw_main
#endif

#ifdef macintosh
#include <SIOUX.h>
#include "perf.h"
#include"MacTransport.h"

#define main mw_main
#define PATH_LEN        128

extern struct Transport transport;
extern Boolean displayText;

extern char sfdir_path[];
extern char sadir_path[];
extern char ssdir_path[];
extern char saved_scorename[];
extern unsigned char mytitle[];
extern Boolean util_perf;
static char *foo;                       
static char listing_file[PATH_LEN];
static int  vbuf;
static int csNGraphs;
static float temp;
#endif

#ifdef __ZPC__
unsigned int _stack = 0xFFF0U;
#endif

static  char    *sortedscore = "score.srt";
static  char    *xtractedscore = "score.xtr";
static  char    *playscore = "score.srt";     /* unless we extract */
static  FILE    *scorin, *scorout, *xfile;
#if !defined(CSOUND_MAIN)
	extern  OPARMS  O;
	char    *orchname = NULL;	/* used by rdorch */
	char	*scorename = NULL;
        FILE    *dribble;
	char    *xfilename = NULL;
#ifdef LINUX
int midi_out;
extern void openMIDIout(void);
#endif
extern  void    dieu(char *);
#else /* defined(CSOUND_MAIN) */
	extern	char *xfilename;
	extern 	char *orchname; 	 /* used by rdorch */
	extern 	char *scorename;
#endif /* !defined(CSOUND_MAIN) */

#if defined(CSOUND_MAIN)

#if defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1
	extern void csound_getopts(int, char **, char *, char *);
#else
	extern int argdecode(int, char**, char**, char*);
#endif /* defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1 */

#ifdef CWIN
void dialog_arguments(void);
#include <stdarg.h>
extern int cwin_atexit(void (*)(void));
#endif /* CWIN */

#if defined(CWIN)
int cwin_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
        char  *s;
        char  *filnamp, *envoutyp = NULL;
        int   n;
extern  int   getsizformat(int), musmon(void);
extern  char  *getstrformat(int);
	extern void print_long_title();

	print_long_title();
#ifdef __ZPC__
#ifdef WITHx87
        extern int _8087;
        if (_8087 == 0)
            die("This Csound needs an 80x87");
#endif
#endif
#if !defined(macintosh) && !defined(SYMANTEC)
        {
            char *getenv(const char*);
            if ((envoutyp = getenv("SFOUTYP")) != NULL) {
                if (strcmp(envoutyp,"AIFF") == 0)
                    O.filetyp = TYP_AIFF;
                else if (strcmp(envoutyp,"WAV") == 0)
                    O.filetyp = TYP_WAV;
                else if (strcmp(envoutyp,"IRCAM") == 0)
                    O.filetyp = TYP_IRCAM;
                else {
                    sprintf(errmsg,"%s not a recognized SFOUTYP env setting",
                            envoutyp);
                    dieu(errmsg);
                }
            }
        }
#endif
        if (!POLL_EVENTS()) exit(1);
#ifdef CWIN
        cwin_atexit(all_free);
#endif
        O.filnamspace = filnamp = mmalloc((long)1024);
        dribble = NULL;
#if !defined(HAVE_GETOPT_LONG) || HAVE_GETOPT_LONG == 0
        {
          FILE *csrc = fopen(".csoundrc", "r");
          extern int readOptions(FILE *);
          if (csrc!=NULL) {
            readOptions(csrc);
            fclose(csrc);
          }
        }        
        if (--argc == 0) {
#ifdef CWIN
            dialog_arguments();
#else
            dieu("insufficient arguments");
#endif
        }
#ifdef CWIN
        else
#endif

#endif /* !defined(HAVE_GETOPT_LONG) || HAVE_GETOPT_LONG == 0 */

#if defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1
	csound_getopts(argc, argv, envoutyp, xfilename);	/* See new-src/getlongopts.[ch] */
#else
	if (argdecode(argc, argv, &filnamp, envoutyp)==0) exit(1);
#endif /* defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1 */

        if (!POLL_EVENTS()) exit(1);
        if (O.Linein || O.Midiin || O.FMidiin)
            O.RTevents = 1;
        if (O.RTevents || O.sfread)
            O.ksensing = 1;
        if (!O.outformat)                       /* if no audioformat yet  */
            O.outformat = AE_SHORT;             /*  default to short_ints */
        O.outsampsiz = getsizformat(O.outformat);
        O.informat = O.outformat; /* informat defaults; resettable by readinheader */
        O.insampsiz = O.outsampsiz;
        if (O.filetyp == TYP_AIFF || O.filetyp == TYP_AIFC || O.filetyp == TYP_WAV) {
            if (!O.sfheader)
                dieu("can't write AIFF/WAV soundfile with no header");
            /* WAVE format supports only unsigned bytes for 1- to 8-bit
               samples and signed short integers for 9 to 16-bit samples.
                                   -- Jonathan Mohr  1995 Oct 17  */
            /* Also seems that type 3 is floats */
            if ((O.filetyp != TYP_AIFC) &&
                (O.outformat == AE_ALAW || O.outformat == AE_ULAW
                 || O.outformat == AE_FLOAT)) 
                printf("WARNING: %s encoding information cannot\n       be contained in the header...\n", getstrformat(O.outformat));
/*             { */
/*               sprintf(errmsg,"AIFF/WAV does not support %s encoding", */
/*                       getstrformat(O.outformat)); */
/*               dieu(errmsg); */
/*             } */
        }
        if (!POLL_EVENTS()) exit(1);
        if (O.rewrt_hdr && !O.sfheader)
            dieu("can't rewrite header if no header requested");
        if (O.sr_override || O.kr_override) {
            long ksmpsover;
            if (!O.sr_override || !O.kr_override)
                dieu("srate and krate overrides must occur jointly");
            ksmpsover = O.sr_override / O.kr_override;
            if (ksmpsover * O.kr_override != O.sr_override)
                dieu("command-line srate / krate not integral");
        }
        if (orchname == NULL)
            dieu("no orchestra name");
	else if (strcmp(orchname+strlen(orchname)-4, ".csd")==0
                 && (scorename==NULL || strlen(scorename)==0)) {
	  int read_unified_file(char *, char **, char **);
	  err_printf("UnifiedCSD:  %s\n", orchname);
	  if (!read_unified_file(orchname, &scorename, &O.FMidiname)) {
	    err_printf("Decode failed....stopping\n");
	    exit(1);
	  }
	}
        err_printf("orchname:  %s\n", orchname);
        if (scorename != NULL)
            err_printf("scorename: %s\n", scorename);
        if (xfilename != NULL)
            err_printf("xfilename: %s\n", xfilename);
#if defined(SYS5) || defined(WIN32)
        {
          static  char  buf[80];
          VMSG(setvbuf(stdout,buf,_IOLBF,80);)
        }
#else
#if !defined(SYMANTEC) && !defined(macintosh) && !defined(LATTICE)
        VMSG(setlinebuf(stdout);)
#endif
#endif
        if (scorename == NULL) {
          if (O.RTevents) {
            err_printf("realtime performance using dummy numeric scorefile\n");
            if (!POLL_EVENTS()) exit(1);
            goto perf;
          }
          else scorename = "score.srt";
        }
        if (!POLL_EVENTS()) exit(1);
#ifdef macintosh
        {
          char *c;
          strcpy(saved_scorename,scorename);
          strcpy((char *)mytitle,scorename);
          c = (char *)&mytitle[0] + strlen((char *)mytitle);
          while (*c != ':' && c != (char *)mytitle) c -= 1;
          if (c != (char *) mytitle) c += 1;
          strcpy((char *)mytitle,c);
          strcat((char *)mytitle," listing");
	  SIOUXSetTitle((unsigned char *)CtoPstr((char *)mytitle));
        }       
#endif  
        if ((n = strlen(scorename)) > 4            /* if score ?.srt or ?.xtr */
          && (!strcmp(scorename+n-4,".srt")
              || !strcmp(scorename+n-4,".xtr"))) {
            err_printf("using previous %s\n",scorename);
            playscore = sortedscore = scorename;            /*   use that one */
        }
        else {
            if (!(scorin = fopen(scorename, "r")))          /* else sort it   */
                dies("cannot open scorefile %s", scorename);
            if (!(scorout = fopen(sortedscore, "w")))
                dies("cannot open %s for writing", sortedscore);
            err_printf("sorting score ...\n");
            scsort(scorin, scorout);
            fclose(scorin);
            fclose(scorout);
        }
        if (!POLL_EVENTS()) exit(1);
        if (xfilename != NULL) {                        /* optionally extract */
            if (!strcmp(scorename,"score.xtr"))
                dies("cannot extract %s, name conflict",scorename);
            if (!(xfile = fopen(xfilename, "r")))
                dies("cannot open extract file %s", xfilename);
            if (!(scorin = fopen(sortedscore, "r")))
                dies("cannot reopen %s", sortedscore);
            if (!(scorout = fopen(xtractedscore, "w")))
                dies("cannot open %s for writing", xtractedscore);
            err_printf("  ... extracting ...\n");
            scxtract(scorin, scorout, xfile);
            fclose(scorin);
            fclose(scorout);
            playscore = xtractedscore;
        }           
        err_printf("\t... done\n");
        if (!POLL_EVENTS()) exit(1);

        s = playscore;
        O.playscore = filnamp;
        while ((*filnamp++ = *s++));    /* copy sorted score name */

perf:   O.filnamsize = filnamp - O.filnamspace;
        if (POLL_EVENTS()) {
          otran();              /* read orcfile, setup desblks & spaces     */
          if (POLL_EVENTS())
            return musmon();   /* load current orch and play current score */
        }
        return (0);
}
#endif /* defined(CSOUND_MAIN) */

#if !defined(CSOUND_MAIN)
#ifdef CWIN
int args_OK = 0;
extern void cwin_args(char **, char **, char **);

void dialog_arguments(void)
{
    cwin_args(&orchname, &scorename, &xfilename);
}
#endif

#ifndef CWIN
#include <stdarg.h>

#ifdef macintosh
void dribble_printf(char *fmt, ...)
{
    va_list a;
    if (displayText)
      {
	va_start(a, fmt);
	vprintf(fmt, a);
	va_end(a);
      }
    if (dribble != NULL) {
      va_start(a, fmt);
      vfprintf(dribble, fmt, a);
      va_end(a);
    }
}
#else
void dribble_printf(char *fmt, ...)
{
    va_list a;
    va_start(a, fmt);
    vprintf(fmt, a);
    va_end(a);
    if (dribble != NULL) {
      va_start(a, fmt);
      vfprintf(dribble, fmt, a);
      va_end(a);
    }
}

void err_printf(char *fmt, ...)
{
    va_list a;
    va_start(a, fmt);
    vfprintf(stderr, fmt, a);
    va_end(a);
    if (dribble != NULL) {
      va_start(a, fmt); /* gab */
      vfprintf(dribble, fmt, a);
      va_end(a);
    }
}
#endif
#endif
#endif /* !defined(CSOUND_MAIN) */
