/*
 * Translator - multilingual labels for menus and dialogs
 * Copyright (c) 1997 IICM
 *
 * created: apesen, 19961114
 *
 * changed: apesen, 19961213
 * changed: mpichler, 19970918
 *
 * $Id: Translator.java,v 1.15 1997/09/19 15:46:25 mpichler Exp $
 */


package iicm.vrml.vrwave;


public abstract class Translator
{
  // no need ever to create an instance of this class
  private Translator ()  { }

  // languages; see include/hyperg/hyperg/language.h
  static final int ENGLISH = 0;
  static final int GERMAN = 1;
  static final int STYRIAN = 2;
  static final int FRENCH = 3;
  static final int ITALIAN = 4;
  static final int SPANISH = 5;
  static final int NUM_LANGUAGES = 6;
  // no hungarian strings yet; Korean and Japanese cause troubles with escape chars (TODO)

  public static int language_ = ENGLISH;
  // menu strings
  public static final String strings [/*MenuDef.M_NUMMENUITEMS*/][/*NUM_LANGUAGES*/] =
/* this translation table was produced by getlabels. DO NOT EDIT!!! */
  {
    { "File", "Datei", "Feil", "Fichier", "File", "Fichero", null },
    { "Open...", "ffnen...", "Mch auf...", "Ouvrir...", "Apri...", "Abrir...", "F3" },
    { "Open Location...", "ffne URL...", "Gemma URL schaun", "Open Location", "Open Location", "Open Location", null },
    { "Reload", "Neu Laden", "Nei lodn...", "Reload...", "Reload...", "Reload...", "M-r" },
    { "Save as...", "Speichern unter...", "Speicher's als...", "Sauvegarder sous...", "Salva come...", "Guardar como...", "F2" },
    { "Export...", "Export...", "Expoat...", "Exporter...", "Esportare...", "Exportar...", null },
    { "VRML", "VRML", "VRML", "VRML", "VRML", "VRML", null },
    { "SDF", "SDF", "SDF", "SDF", "SDF", "SDF", null },
    { "Edit", "Bearbeiten", "Editieren", "dition", "Edito", "Editar", "e" },
    { "Print...", "Drucken...", "Druck's...", "Imprimer...", "Stampa...", "Imprimir...", null },
    { "Camera Info", "Kamera Information", "Kamera Infou", "Info de camra", "Informazioni sulla telecamera", "Informacin sobre Cmara", null },
    { "Mail to...", "Mail an...", "Schick' a mail n...", "Poster ...", "Invia posta...", "Enviar a...", null },
    { "View Parser Output...", "Parser Output anzeigen...", "Parsa Autput nzagn...", "Sortie de l'analyseur grammatical...", "Uscita parser...", "Ver Output del Parser...", null },
    { "Exit Viewer", "Beende Viewer", "her auf!", "Terminer", "Viewer di uscita", "Terminar Viewer", "^x" },
    null,  // 0x0e
    null,  // 0x0f
    { "Navigate", "Navigation", "Ummadumkumman", "Navigation", "Navigare", "Navegacin", null },
    { "Flip", "Objekt bewegen", "Schupfn", "Pivoter objet", "Oggetto colpito", "Mover Objeto", "F4" },
    { "Walk", "Gehen", "Hatschn", "Marcher", "Camminare", "Caminar", "F5" },
    { "Fly", "Fliegen", "Fliagn", "Voler", "Volare", "Volar", "F6" },
    { "Fly To", "Fliegen auf Ziel", "Flieg duathin", "Voler vers", "Volare verso", "Volar hacia", "F7" },
    { "Heads Up", "Kontrollsymbole", "Kastln (Box!)", "Console", "Controlli", "Controles", "F8" },
    { "Viewpoints", "Ansichten", "nsichten", "Points de vue", "Punti di vista", "Perspectivas", null },
    { "Previous", "Vorige", "Vurige", "Previous", "Previous", "Previo", "PgUp" },
    { "Next", "Nchste", "Nexte", "Suivant", "Seguente", "Siguiente", "PgDn" },
    { "Reset View", "Ansicht zurcksetzen", "Ansicht zrucksetzen", "Rtablir la vue", "Ristabilire vista orig.", "Reajustar Vista", "r" },
    { "Level View", "Horizontale Ansicht", "Mch's ebn", "Niveler la vue", "Vista dell'orizzonte", "Vista Horizontal", "l" },
    { "Untilt View", "Neigung zurcksetzen", "Mch's grod", "Rtablir l'inclinaison", "Riaggiustare l'inclinazione", "Reajustar Inclinacin", "u" },
    null,  // 0x1c
    null,  // 0x1d
    null,  // 0x1e
    null,  // 0x1f
    { "Options", "Optionen", "Optionen", "Options", "Opzioni", "Opciones", null },
    { "Enable Motion with Anchors", "Navigation bei Ankerhervorhebung", "Weita ummadumfoan", "Permettre mouvements avec ancres", "Permetti movimento con le ancore", "Navegacin Mediante Anclas", null },
    { "Velocity Control", "Geschwindigkeitsregelung", "Regl die G'schwindigkeit", "Rglage de la vitesse", "Controllo della velocita'", "Control de Velocidad", null },
    { "Show Framerate", "Zeit pro Bild anzeigen", "zag wia schnll da'd bist", "Afficher frquence d'image", "Mostra la relazione tempo-immagine", "Ver Relacin Tiempo/Imgen", null },
    { "Collision Detection", "Kollisions-Erkennung", "kane Bruchlndungen", "Dtection de collision", "Riconoscitore di collisione", "Collision Detection", null },
    { "Settings...", "Einstellungen...", "Einstllungan...", "Paramtres...", "Configurazione...", "Valores...", null },
    { "Spaceball...", "Spaceball...", "Spaceball...", "Spaceball...", "Spaceball...", "Spaceball...", null },
    { "Back", "Rckwrts", "Z'ruck", "Prcdent", "Indietro", "Atrs", "b" },
    { "Forward", "Vorwrts", "Firi", "Suivant", "Avanti", "Adelante", "f" },
    { "History", "Befehlsgeschichte", "G'schicht", "Historique", "Storia", "Historia", "h" },
    { "Hold", "Halte Dokument", "Hoits", "Maintenir cette fentre", "Mantenere", "Mantener", "H" },
    null,  // 0x2b
    null,  // 0x2c
    null,  // 0x2d
    null,  // 0x2e
    null,  // 0x2f
    { "Anchors", "Anker", "nka", "Ancres", "Ancore", "Anclas", null },
    { "Attributes", "Attribute", "Attribute", "Attributs", "Attributi", "Atributos", "a" },
    { "Follow", "Verfolgen", "Nchlaffn", "Suivre", "Attivare", "Activar", "RET" },
    { "Define As Source", "Definiere als Quelle", "Nimm's als Qulln", "Dfinir comme source", "Definire come origine", "Definir como Orgen", null },
    { "Define As Destination", "Definiere als Ziel", "Nimm's als Zl", "Dfinir comme destination", "Definire destinazione", "Definir como Destino", null },
    { "Use Default Destination", "Verwende Defaultziel", "Nimm's normale Zl", "Utiliser destination par dfaut", "Usare destinazione per default", "Usar Destino Estndar", null },
    { "Delete", "Lschen", "Lschn", "Effacer", "eliminare", "Eliminar", "DEL" },
    { "Select Objects", "Objekte selektieren", "Objekte auswhln", "Choisir objets", "Seleziona oggetti", "Seleccionar Objetos", null },
    { "Select Groups", "Gruppen selektieren", "Gruppn auswhln", "Choisir groupes", "Seleziona gruppi", "Seleccionar Grupos", null },
    { "Deselect Object/Group", "Selektion entfernen", "Nix auswhln", "Annuler slection d'objet/groupe", "Diselezionare oggetto/gruppo", "Deseleccionar Objeto/Grupo", null },
    null,  // 0x3a
    null,  // 0x3b
    null,  // 0x3c
    null,  // 0x3d
    null,  // 0x3e
    null,  // 0x3f
    { "Display", "Anzeige", "nzeige", "Affichage", "Schermo", "Monitor", null },
    { "Wireframe", "Kantenmodell", "olle Kanten", "Fil de fer", "Scheletro", "Modelo Alambre", "^w" },
    { "Hidden Line", "hidden line (Umrisse)", "nua die Kanten ummadum", "Lignes caches", "Linea nascosta", "Hidden Line (Permetro)", "^h" },
    { "Flat Shading", "konstant schattiert", "gleiche Foab", "Nuances constantes", "Ombreggiatura piatta", "Sombreado Constante", "^f" },
    { "Smooth Shading", "verlaufend schattiert", "vaschmiate Foab", "Nuances varies", "Ombreggiatura smooth", "Sombreado Progresivo", "^s" },
    { "Texturing", "Texturen", "Bldln auf die Flchn", "Texturation", "Applica motivo", "Texturas", "^t" },
    { "Interactive", "interaktiv", "beim ummadumfoahn", "Interaction", "Interattivo", "Interactivo", null },
    { "The same", "Dieselbe", "die gleiche", "Mme chose", "Lo stesso", "El mismo", "^u" },
    { "Wireframe", "Kantenmodell", "olle Kanten", "Fil de fer", "Scheletro", "Modelo Alambre", "^W" },
    { "Hidden Line", "hidden line (Umrisse)", "nua die Kanten ummadum", "Lignes caches", "Linea nascosta", "Hidden Line (Permetro)", "^H" },
    { "Flat Shading", "konstant schattiert", "gleiche Foab", "Nuances constantes", "Ombreggiatura piatta", "Sombreado Constante", "^F" },
    { "Smooth Shading", "verlaufend schattiert", "vaschmiate Foab", "Nuances varies", "Ombreggiatura smooth", "Sombreado Progresivo", "^S" },
    { "Texturing", "Texturen", "Bldln auf die Flchn", "Texturation", "Applica motivo", "Texturas", "^T" },
    { "Behaviour", "Aktivitt", "Tuat wos", "Behaviour", "Behaviour", "Behaviour", "^b" },
    { "Interaction", "Interaktion", "Intaaktschn", "Interaction", "Interaction", "Interaction", "^i" },
    null,  // 0x4f
    { "Render Mode", "Rendering", "Rendaring", "Render Mode", "Render Mode", "Render Mode", null },
    { "Depth Buffer", "Z-Buffer", "Z-Buffa", "Depth Buffer", "Depth Buffer", "Depth Buffer", "D" },
    { "BSP Tree", "BSP Baum", "BSP Baam", "BSP Tree", "BSP Tree", "BSP Tree", "B" },
    { "plain BSP", "plain BSP", "plain BSP", "plain BSP", "plain BSP", "plain BSP", null },
    { "backface culling BSP", "backface culling BSP", "backface culling BSP", "backface culling BSP", "backface culling BSP", "backface culling BSP", null },
    { "shadow volume BSP", "shadow volume BSP", "shadow volume BSP", "shadow volume BSP", "shadow volume BSP", "shadow volume BSP", null },
    { "Show Framerate", "Zeit pro Bild anzeigen", "zag wia schnll da'd bist", "Afficher frquence d'image", "Mostra la relazione tempo-immagine", "Ver Relacin Tiempo/Imgen", null },
    { "Show Title", "Titel anzeigen", "zag an Titl n", "Afficher titre", "Mostra titolo", "Show Title", null },
    null,  // 0x58
    null,  // 0x59
    null,  // 0x5a
    null,  // 0x5b
    null,  // 0x5c
    null,  // 0x5d
    null,  // 0x5e
    null,  // 0x5f
    { "Anti-Aliasing", "Anti-Aliasing", "gltt mchn", "Anti-Aliasing", "Anti-Aliasing", "Anti-Aliasing", null },
    { "Lines", "Linien", "Linien", "des lignes", "di linee", "Lines", "^L" },
    { "Textures: off", "Texturen: aus", "Flchn-Bldln: aus", "Texturation: dsactiv", "Motivi: spento", "Texturas: desactivar", "^N" },
    { "1", "1", "1", "1", "1", "1", null },
    { "2", "2", "2", "2", "2", "2", null },
    { "3", "3", "3", "3", "3", "3", null },
    { "4", "4", "4", "4", "4", "4", null },
    { "Textures: on", "Texturen: ein", "Flchn-Bldln: ein", "Texturation: activ", "Motivi: acceso", "Texturas: activar", "^M" },
    { "Two-sided Polygons", "Zweiseitige Polygone", "zwoaseitige Polgone", "Calcul des deux faces", "Poligoni di due lati", "Polgonos de Doble Lado", null },
    { "on", "ein", "ein", "activ", "acceso", "activar", null },
    { "auto", "auto", "auto", "auto", "auto", "auto", null },
    { "off", "aus", "aus", "dsactiv", "spento", "desactivar", null },
    null,  // 0x6c
    null,  // 0x6d
    null,  // 0x6e
    null,  // 0x6f
    { "Lighting Calculations", "Licht-Berechnungen", "Lichta ausrechnan", "Calcul de l'clairage", "Calcolo della luminosita'", "Clculos de Luz", null },
    { "on", "ein", "ein", "activ", "Acceso", "activar", null },
    { "auto", "auto", "auto", "auto", "auto", "auto", null },
    { "off", "aus", "aus", "dsactiv", "Spento", "desactivar", null },
    { "on texturing", "mit Texturen", "mit die Bldln", "sur textures", "con texture", "con texturas", null },
    { "no materials", "weie Objekte", "ois wei", "no materials", "no materials", "no materials", null },
    { "Transparency", "Transparenz", "Duachsichtigkeit", "Transparence", "Transparency", "Transparency", null },
    { "off", "aus", "aus", "off", "off", "off", null },
    { "stipple", "Raster", "Rsta", "stipple", "stipple", "stipple", null },
    { "blending", "berblenden", "bablendn", "blending", "blending", "blending", null },
    { "on texturing", "mit Texturen", "mit die Bldln", "sur textures", "con texture", "con texturas", null },
    null,  // 0x7b
    null,  // 0x7c
    null,  // 0x7d
    null,  // 0x7e
    null,  // 0x7f
    { "Headlight", "Standard-Lichtquelle", "Liacht zum Schaun", "Lumire standard", "Fonte di luce", "Fuente de Luz", null },
    { "Anchors", "Anker", "nka", "Ancres", "Ancore", "Anclas", null },
    { "Display", "Anzeigen", "Anzagn", "Afficher", "Schermo", "Monitor", "F9" },
    { "Brightness", "Helligkeit", "Hlligkeit", "Surbrillance", "Brillantezza", "Brillo", null },
    { "Colour Code", "Farbkodierung", "ondare Foab", "Code de couleur", "Codice del colore", "Cdigo de Color", null },
    { "Colour Edges", "Kanten hervorheben", "Kanten nochimolen", "Artes de couleur", "Margini del colore", "Colorear Lados", null },
    null,  // 0x86
    null,  // 0x87
    null,  // 0x88
    null,  // 0x89
    null,  // 0x8a
    null,  // 0x8b
    null,  // 0x8c
    null,  // 0x8d
    null,  // 0x8e
    null,  // 0x8f
    { "Colour", "Farben", "Foab", "Couleurs", "Colore", "Color", null },
    { "Colours...", "Farben...", "Foab...", "Couleurs...", "Colore...", "Color...", null },
    { "Background", "Hintergrund", "Hintagrund", "Fond", "Sfondo", "Fondo", null },
    { "black", "schwarz", "schwoaz", "noir", "nero", "negro", null },
    { "cyan", "trkis", "trkis", "cyan", "turchese", "turquesa", null },
    { "grey", "grau", "grau", "gris", "grigio", "gris", null },
    { "green", "grn", "grn", "vert", "verde", "verde", null },
    { "lt.grey", "hellgrau", "hllgrau", "gris ple", "grigio chiaro", "gris claro", null },
    { "magenta", "rosa", "rosa", "magenta", "magenta", "magenta", null },
    { "orange", "orange", "oronsch", "orange", "arancio", "naranja", null },
    { "purple", "lila", "lila", "mauve", "porpora", "prpura", null },
    { "red-brown", "rot-braun", "rot-braun", "brun rouge", "rosso-marrone", "marrn rojizo", null },
    { "yellow", "gelb", "glb", "jaune", "giallo", "amarillo", null },
    { "white", "wei", "wei", "blanc", "bianco", "blanco", null },
    null,  // 0x9e
    null,  // 0x9f
    { "Help", "Hilfe", "Hlfe", "Aide", "Aiuto", "Ayuda", null },
    { "Overview", "bersicht", "basicht", "Survol", "Panorama", "Panorama", "F1" },
    { "Index", "Index", "Index", "Index", "Indice", "Indice", null },
    { "VRwave Homepage", "VRwave Homepage", "VRwave Homepage", "VRwave Homepage", "VRwave Homepage", "VRwave Homepage", null },
    { "About", "Info ber...", "Info ba...", " propos...", "Info...", "Info...", null }
  };


  /**
   * get a translated label
   * @param num label number, should be one of the B_* or L_* constants below
   * @return label (will be english if no translation available)
   */

  // other strings/labels
  public static String getLabel (int num)
  {
    String[] trans = labels[num];
    if (language_ < trans.length && trans[language_] != null)
      return trans[language_];
    return trans[0];  // there should always be an english label
  }

  // button labels
  public static final int B_OK      = 0x00;
  public static final int B_APPLY   = 0x01;
  public static final int B_RESET   = 0x02;
  public static final int B_RESTORE = 0x03;
  public static final int B_CANCEL  = 0x04;
  public static final int B_CLOSE   = 0x05;
  public static final int B_CLEAR   = 0x06;
  public static final int B_HELP    = 0x07;
  public static final int B_OLD     = 0x08;
  public static final int B_NEW     = 0x09;

  // other labels (for VRwave)
  public static final int L_OPENLOCATION = 0x10;
  public static final int L_SETTINGS     = 0x11;
  public static final int L_QUADSLICES   = 0x12;

  // status line navigation mode hints (see Scene.movemode_)
  public static final int L_HINTFLIP     = 0x13;
  public static final int L_HINTWALK     = 0x14;
  public static final int L_HINTFLY      = 0x15;
  public static final int L_HINTFLYTO    = 0x16;
  public static final int L_HINTHEADSUP  = 0x17;

  // color chooser
  public static final int L_RED          = 0x20;
  public static final int L_GREEN        = 0x21;
  public static final int L_BLUE         = 0x22;
  public static final int L_HUE          = 0x23;
  public static final int L_SATURATION   = 0x24;
  public static final int L_BRIGHTNESS   = 0x25;


  // language order see above, english label will be used for missing and null values

  public static final String labels [/*L_NUMLABELS*/][/*NUM_LANGUAGES*/] =
  {
    { "OK" },
    { "Apply", "bernehmen", "Nimms ummi" },
    { "Reset", "Zurcksetzen", "Zrucksetzn" },
    { "Restore", "Wiederherstellen", "Wiedaherstlln" },
    { "Cancel", "Abbrechen", "bbrechn" },
    { "Close", "Schlieen", "Mchs zua" },
    { "Clear", "Lschen", "Leschn" },
    { "Help", "Hilfe", "Hlfe", "Aide", "Aiuto", "Ayuda" },
    { "Old", "Alt", "Oid" },
    { "New", "Neu", "Nei" },
    null,  // 0x0a
    null,  // 0x0b
    null,  // 0x0c
    null,  // 0x0d
    null,  // 0x0e
    null,  // 0x0f
    { "Open Location", "ffne URL", "Gemma URL schaun" },
    { "Settings", "Einstellungen", "Einstllungan..." },
    { "Quadrics Complexity", "Zylinder-Spalten", "Kuglsplten" },
    { "Drag mouse to translate/rotate/zoom the model", "Objekt verschieben/rotieren/zoomen durch Ziehen der Maus" },
    { "Drag mouse to walk/move/look around", "Gehen/verschieben/schauen durch Ziehen der Maus" },
    { "Fly not implemented yet", "Modus \"Fliegen\" noch nicht implementiert", "Fliagn geht no net" },
    { "Press mouse buttons to set target/fly to it/fly away from it",
      "Ziel positionieren/anfliegen/verlassen mit den Maustasten" },
    { "Drag mouse out of icons for movement (eyes, body, pan)",
      "Fr Navigation Maus aus Symbol hinausziehen", "Ziag d'Maus aussi aus di Kastln" },
    null,  // 0x18
    null,  // 0x19
    null,  // 0x1a
    null,  // 0x1b
    null,  // 0x1c
    null,  // 0x1d
    null,  // 0x1e
    null,  // 0x1f
    { "Red", "Rot", "Rout" },
    { "Green", "Grn", "Grian" },
    { "Blue", "Blau", "Blau" },
    { "Hue" },
    { "Saturation", "Sttigung" },
    { "Brightness", "Helligkeit" }
  };

  // should also be multi-lingual?!
  // DialogFileOpen
  static final String L_FOP_DName    = "File Open";
  // DialogOpenLocation
  static final String L_LOP_DName    = "Open Location";
  // FileSaveDialog
  static final String L_FSV_DName    = "File Save";
  // Settingsdialog
  static final String L_Set_AVColDis = "Collision Distance";
  static final String L_Set_AVNSF    = "Navigation Speed Factor";
  static final String L_Set_AVFTZS   = "Fly To: Zoom Speed";
  static final String L_Set_AVFTRS   = "Fly To: Rotation Speed";
  static final String L_Set_AVSVBSP  = "SV-BSP Recalculation";

  // color chooser
  // must be consistent with Scene.COL* constants
  static final String[] L_ColChooser_Targets  = {
    "Background",
    "Headlight",
    "Ambient (global light)",
//     "Heads-up Display",
//     "Anchor Faces",
//     "Anchor Edges",
  };
} // Translator
