/****************************************************************************
** $Id: qmsgbox.h,v 2.0 1996/09/24 10:15:42 agulbra Exp $
**
** Definition of QMessageBox class
**
** Created : 950503
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QMSGBOX_H

#include "qdialog.h"

class QLabel;
class QPushButton;


class QMessageBox : public QDialog
{
    Q_OBJECT
public:
    static int message( const char *caption,
			const char *text,  const char *buttonText=0,
			QWidget *parent=0, const char *name=0 );

    QMessageBox( QWidget *parent=0, const char *name=0 );

    const char *text()		const;
    void	setText( const char * );

    const char *buttonText()	const;
    void	setButtonText( const char * );

    void	adjustSize();

protected:
    void	resizeEvent( QResizeEvent * );

private:
    QLabel	*label;
    QPushButton *button;
    void	*reserved1;
    void	*reserved2;

private:	// Disabled copy constructor and operator=
    QMessageBox( const QMessageBox & ) {}
    QMessageBox &operator=( const QMessageBox & ) { return *this; }
};


#endif // QMSGBOX_H
