#!/bin/sh
# Create a send-pr distribution for a GNATS site.
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=XGNATS_ROOTX
GNATS_SITE=XGNATS_SITEX
DATADIR=XDATADIRX

FILES="COPYING README send-pr.sh install-sid.sh send-pr-el.in send-pr.texi \
       send-pr.man send-pr.info texinfo.tex categories"

if [ $# != 2 ]; then
  echo "usage: $0 directory release"
  exit 1
fi
 
# Newer config information?
[ -f ${GNATS_ROOT}/gnats-adm/config ] && . ${GNATS_ROOT}/gnats-adm/config

if [ ! -d ${DATADIR}/gnats/dist ]; then
  echo "$0: GNATS send-pr distribution directory ${DATADIR}/gnats/dist does not exist."
  exit 1
fi

if [ ! -d $1 ]; then
  echo "$0: no such destination directory"
  exit 1
fi

for f in $FILES; do
  if [ ! -f ${DATADIR}/gnats/dist/$f ]; then
    echo "$0: $f does not exist."
    exit 1
  fi
  rm -f $1/$f
  cp ${DATADIR}/gnats/dist/$f $1
done

cat > $1/Makefile << '__EOF__'
#
# Makefile for building a standalone send-pr.
#
RELEASE=YRELEASEY

prefix = /usr/local
bindir = $(prefix)/bin
datadir = $(prefix)/lib
infodir = $(prefix)/info
lispdir = $(prefix)/emacs/site-lisp
mandir = $(prefix)/man
man1dir = $(mandir)/man1

all: send-pr send-pr.el install-sid

send-pr: send-pr.sh
	sed -e 's,@DATADIR@,$(datadir),g' \
	    -e 's/@DEFAULT_RELEASE@/$(RELEASE)/g' send-pr.sh > send-pr

send-pr.el: send-pr-el.in
	sed -e 's,@DATADIR@,$(datadir),g' \
	    -e 's/@DEFAULT_RELEASE@/$(RELEASE)/g' send-pr-el.in > send-pr.el

install-sid: install-sid.sh
	sed -e 's,@BINDIR@,$(bindir),g' install-sid.sh > install-sid

install: all
	if [ -d $(prefix) ]; then true ; else mkdir $(prefix) ; fi
	if [ -d $(bindir) ]; then true ; else mkdir $(bindir) ; fi
	cp send-pr $(bindir)
	chmod 755 $(bindir)/send-pr
	cp install-sid $(bindir)
	chmod 755 $(bindir)/install-sid
	-parent=`echo $(lispdir)|sed -e 's@/[^/]*$$@@'`; \
	if [ -d $$parent ] ; then true ; else mkdir $$parent ; fi
	if [ -d $(lispdir) ] ; then true ; else mkdir $(lispdir) ; fi
	cp send-pr.el $(lispdir)/send-pr.el
	chmod 644 $(lispdir)/send-pr.el
	cp send-pr.info $(infodir)/send-pr.info
	chmod 644 $(infodir)/send-pr.info
	if [ -d $(datadir) ] ; then true ; else mkdir $(datadir) ; fi
	if [ -d $(datadir)/gnats ] ; then true ; else mkdir $(datadir)/gnats ; fi
	cp categories $(datadir)/gnats/YGNATS_SITEY
	chmod 644 $(datadir)/gnats/YGNATS_SITEY
	-parent=`echo $(man1dir)|sed -e 's@/[^/]*$$@@'`; \
	if [ -d $$parent ] ; then true ; else mkdir $$parent ; fi
	if [ -d $(man1dir) ] ; then true ; else mkdir $(man1dir) ; fi
	cp send-pr.1 $(man1dir)/send-pr.1
	chmod 644 $(man1dir)/send-pr.1

clean:
	rm -f send-pr send-pr.el

__EOF__

sed -e "s/YGNATS_SITEY/$GNATS_SITE/g" \
    -e "s/YRELEASEY/$2/" $1/Makefile > $1/Makefile.tmp
mv -f $1/Makefile.tmp $1/Makefile

exit 0
