/**
 *
 * $Id: ArrowBP.h,v 1.3 1995/12/16 23:37:27 toshok Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_ARROWB_P_H
#define XM_ARROWB_P_H

#include <Xm/ArrowB.h>
#include <Xm/PrimitiveP.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    XtCallbackList activate_callback;
    XtCallbackList arm_callback;
    XtCallbackList disarm_callback;
    unsigned char direction;

    Boolean selected;

    short top_count;
    short cent_count;
    short bot_count;
    XRectangle *top;
    XRectangle *cent;
    XRectangle *bot;

    GC arrow_GC;
    XtIntervalId timer;
    unsigned char multiClick;
    int click_count;
    Time armTimeStamp;
    GC insensitive_GC;
} XmArrowButtonPart;

/* Define the full instance record */
typedef struct _XmArrowButtonRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmArrowButtonPart arrowbutton;
} XmArrowButtonRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmArrowButtonClassPart;

/* Define the full class record */
typedef struct _XmArrowButtonClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmArrowButtonPart arrowbutton_class;
} XmArrowButtonClassRec;

/* External definition for the class record */

extern XmArrowButtonClassRec xmArrowButtonClassRec;

#define AB_ArmCallback(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.arm_callback)

#define AB_ActivateCallback(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.activate_callback)

#define AB_DisarmCallback(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.disarm_callback)

#define AB_ArrowGC(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.arrow_GC)

#define AB_InsensitiveGC(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.insensitive_GC)

#define AB_Direction(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.direction)

#define AB_Armed(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.selected)

#define AB_Timer(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.timer)

#define AB_MultiClick(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.multiClick)

#define AB_ClickCount(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.click_count)

#define AB_ArmTimeStamp(w) \
    (((XmArrowButtonWidget)(w))->arrowbutton.armTimeStamp)

#ifdef __cplusplus
};
#endif

#endif /* XM_ARROWB_P_H */
