/**
 *
 * $Id: PushBG.c,v 1.44 1996/04/30 03:05:18 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: PushBG.c,v 1.44 1996/04/30 03:05:18 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/CacheP.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/DebugUtil.h>
#include <Xm/ManagerP.h>
#include <Xm/MenuShell.h>
#include <Xm/MenuUtilP.h>
#include <Xm/PushBGP.h>
#include <Xm/RowColumnP.h>
#include <X11/Xfuncs.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_hook(Widget w, ArgList args, Cardinal *num_args);
static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);

static void Arm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Activate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Disarm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ArmAndActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Help(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MultiActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);

static void secondary_object_create(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_prehook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_prehook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_posthook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_prehook(Widget new, ArgList args, Cardinal *num_args);
static void get_values_posthook(Widget new, ArgList args, Cardinal *num_args);
static Cardinal get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data);

/*
 * resources
 */
#define Offset(field) XtOffsetOf(XmPushButtonGCacheObjRec, pushbutton_cache.field)
static XtResource cache_resources[] = {
    {
	XmNmultiClick, XmCMultiClick, XmRMultiClick,
	sizeof(unsigned char), Offset(multiClick),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNdefaultButtonShadowThickness, XmCDefaultButtonShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), Offset(default_button_shadow_thickness),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNfillOnArm, XmCFillOnArm, XmRBoolean,
	sizeof(Boolean), Offset(fill_on_arm),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNarmColor, XmCArmColor, XmRPixel,
	sizeof(Pixel), Offset(arm_color),
        XmRCallProc, (XtPointer)_XmSelectColorDefault
    },
    {
	XmNarmPixmap, XmCArmPixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(arm_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    }
};

static XmSyntheticResource cache_syn_resources[] = {
    {
	XmNdefaultButtonShadowThickness,
	sizeof(Dimension), Offset(default_button_shadow_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }
};

XmPushButtonGCacheObjClassRec xmPushButtonGCacheObjClassRec = {
    /* Object class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGCacheObjClassRec,
        /* class_name            */ "XmPushButtonGCacheObjClass",
	/* widget_size           */ sizeof(XmPushButtonGCacheObjRec),
	/* class_initialize      */ NULL,
	/* class_part_initialize */ NULL,
	/* class_inited          */ FALSE,
	/* initialize            */ NULL,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ cache_resources,
	/* num_resources         */ XtNumber(cache_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ NULL,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ cache_syn_resources,
        /* num_syn_resources  */ XtNumber(cache_syn_resources),
        /* extension          */ NULL
    },
    /* LabelGCacheObj part */
    {
	/* foo                */ 0
    },
    /* PushButtonGCacheObj part */
    {
	/* foo                */ 0
    }
};

#undef Offset
#define Offset(field) XtOffsetOf(XmPushButtonGadgetRec, pushbutton.field)

/* Resources for the pushbutton class */
static XtResource resources[] = {
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmPushButtonGadgetRec, gadget.shadow_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmPushButtonGadgetRec, gadget.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmPushButtonGadgetRec,gadget.highlight_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNshowAsDefault, XmCShowAsDefault, XmRBooleanDimension,
	sizeof(Dimension), Offset(show_as_default),
	XmRImmediate, 0
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNshowAsDefault,
	sizeof(Dimension), Offset(show_as_default),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNhighlightThickness,
	sizeof(Dimension), XtOffsetOf(XmPushButtonGadgetRec, gadget.highlight_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }
};

static XmCacheClassPart cache_part = {
    /* cache head part */
    {
        /* next         */ NULL,
        /* prev         */ NULL,
        /* ref_count    */ 0
    },
    _XmCacheCopy,
    _XmCacheDelete,
    _XmPushBCacheCompare
};

static XmBaseClassExtRec _XmPushBGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ initialize_prehook,
    /* set_values_prehook        */ set_values_prehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ set_values_posthook,
    /* secondary_object_class    */ (WidgetClass)&xmPushButtonGCacheObjClassRec,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ get_sec_res_data,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ get_values_prehook,
    /* get_values_posthook       */ get_values_posthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmGadgetClassExtRec _XmPushBGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

XmPushButtonGadgetClassRec xmPushButtonGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGadgetClassRec,
	/* class_name            */ "XmPushButtonGadget",
	/* widget_size           */ sizeof(XmPushButtonGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeNoCompress,
	/* compress_enterleave   */ FALSE,
 	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ get_values_hook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmPushBGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight, /* fix me */
	/* arm_and_activate   */ ArmAndActivate,
	/* input_dispatch     */ input_dispatch,
	/* visual_change      */ NULL, /* fix me */
	/* syn_resources      */ syn_resources,
	/* num_syn_resources  */ XtNumber(syn_resources),
	/* cache_part         */ &cache_part,
	/* extension          */ (XtPointer)&_XmPushBGadgetClassExtRec
    },
    /* XmLabelGadget part */
    {
        /* setOverrideCallback */ NULL, /* fix me */
        /* menuProcs           */ XmInheritMenuProc,
	/* extension           */ NULL
    },
    /* XmPushButtonGadget part */
    {
	/* extension          */ NULL, 
    },
};

WidgetClass xmPushButtonGadgetClass = (WidgetClass)&xmPushButtonGadgetClassRec;

/* 
 * Some #defines to make the code below more readable
 */
#define IN_MENU(w) (XmIsRowColumn(XtParent((Widget)(w))) \
                    && (RC_Type(((XmGadget)w)->object.parent) == XmMENU_POPUP \
                          || (RC_Type(((XmGadget)w)->object.parent) == XmMENU_PULLDOWN)))
#define IN_POPUP(w) (XmIsRowColumn(XtParent((Widget)(w))) \
                    && (RC_Type(((XmGadget)w)->object.parent) == XmMENU_POPUP))

/******************************* GADGET PART *********************************/
static void
secondary_object_create(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XtPointer nsec, rsec;
    XmWidgetExtData ed;
    int size;

    XdbDebug(__FILE__, new, "PushBGCacheRec %s being initialized.\n", XtName(new));

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);

    size = (*bce)->secondaryObjectClass->core_class.widget_size;
    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    XtGetSubresources(new, nsec, NULL, NULL,
                      (*bce)->secondaryObjectClass->core_class.resources,
                      (*bce)->secondaryObjectClass->core_class.num_resources,
                      args, *num_args);

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    LabG_Cache(new) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);

    PBG_Cache(new) = &(((XmPushButtonGCacheObject)nsec)->pushbutton_cache);
    PBG_Cache(request) = &(((XmPushButtonGCacheObject)rsec)->pushbutton_cache);
}

int
_XmPushBCacheCompare(XtPointer A, XtPointer B)
{
    return !memcmp(((XmPushButtonGCacheObjPart *)A),
		   ((XmPushButtonGCacheObjPart *)B),
		   sizeof(XmPushButtonGCacheObjPart));
}

/******************************* GADGET PART *********************************/
static void
class_initialize()
{
    XtResourceList combined, labels;
    int ncom;
    Cardinal nlabels;

    /* don't let the nulls fool you.  look at the header file -- the arg
     * isn't used. */
    ClassCacheHead(PBG_ClassCachePart(NULL)).prev =
	&ClassCacheHead(PBG_ClassCachePart(NULL));
    ClassCacheHead(PBG_ClassCachePart(NULL)).next =
	&ClassCacheHead(PBG_ClassCachePart(NULL));

    _XmPushBGRectClassExtRec.record_type = XmQmotif;

    /*
     * Label subclasses (ToggleBG, PushBG, CascadeBG) have a problem.  Since
     * we do all the subpart manipulation in the pre- and post- hooks, and
     * since those hooks aren't chained, we have to either make multiple
     * calls to XtGetSubresources/Xt[Get|Set]Subvalues, or merge the resource
     * lists.  Since I just wrote _XmTransformSubresources, seems like a
     * waste not to use it.
     */
    ncom = XtNumber(cache_resources) +
	   xmLabelGCacheObjClassRec.object_class.num_resources;

    _XmTransformSubResources(xmLabelGCacheObjClassRec.object_class.resources,
			     xmLabelGCacheObjClassRec.object_class.num_resources,
			     &labels, &nlabels);

    combined = (XtResourceList)XtMalloc(sizeof(XtResource) * ncom);
    bcopy(labels, combined, nlabels * sizeof(XtResource));
    bcopy(cache_resources,
	  &combined[nlabels],
	  XtNumber(cache_resources) * sizeof(XtResource));
    XtFree((char *)labels);

    xmPushButtonGCacheObjClassRec.object_class.resources = combined;
    xmPushButtonGCacheObjClassRec.object_class.num_resources = ncom;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmPUSH_BUTTON_GADGET_BIT);
}

static void
initialize_prehook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "PushBG InitializePrehook\n");
}

static void
initialize_posthook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XmWidgetExtData ext;

    XdbDebug(__FILE__, new, "PushBG InitializePosthook\n");

    /* don't let the null fool you */
    LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
                                   (XtPointer)LabG_Cache(new),
                                   sizeof(XmLabelGCacheObjPart));
    PBG_Cache(new) = _XmCachePart(PBG_ClassCachePart(NULL),
                                  (XtPointer)PBG_Cache(new),
                                  sizeof(XmPushButtonGCacheObjPart));

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);
    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);
    XtFree((char *)ext);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XtGCMask valueMask;
    Dimension margin, margin_extra;

    valueMask = GCForeground;
    PBG_FillGC(new) = XtAllocateGC(new, 0, 0, NULL,
				   valueMask, ~valueMask);

    if (!XtIsSubclass(XtParent(new), xmManagerWidgetClass))
        _XmError(new, "parent should be manager.");

    if (!LabG_Font(new))
	LabG_Font(new) = _XmGetDefaultFontList(new,
					       XmBUTTON_FONTLIST);

    PBG_Armed(new) = False;

    if (IN_MENU(new))
	LabG_Highlight(new) = 0;
    else {
	/* take care of the default button shadow stuff */
	/*
	 * This new code adjusts button size in two cases : when ShowAsDefault
	 * is non-zero, and when DefaultButtonShadow is non-zero.
	 */
        margin = 0;
	margin_extra = 0;
        if (PBG_DefaultButtonShadow(new)) {
            margin = 2 * PBG_DefaultButtonShadow(new) + LabG_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}
        else if (PBG_ShowAsDefault(new)) {
            margin = 2 * PBG_ShowAsDefault(new) + LabG_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}

        LabG_MarginLeft(new) = margin + margin_extra;
        LabG_MarginRight(new) = margin + margin_extra;
        LabG_MarginTop(new) = margin + margin_extra;
        LabG_MarginBottom(new) = margin + margin_extra;

#if 1
	XtWidth(new) += (margin + margin_extra) * 2;
	XtHeight(new) += 2 * margin + margin_extra;
#else
	_XmLabelRecomputeSize(new);
#endif
    }

    G_EventMask(new) = XmARM_EVENT | XmACTIVATE_EVENT | XmENTER_EVENT |
		       XmLEAVE_EVENT | XmFOCUS_IN_EVENT | XmFOCUS_OUT_EVENT;
		       /* FIX ME -- more here */

    if (LabG_Accelerator(new))
	_XmManagerInstallAccelerator(XtParent(new), new, LabG_Accelerator(new));
}

static void
destroy(Widget w)
{
    _XmCacheDelete(PBG_Cache(w));
}

static Boolean
set_values_prehook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec, rsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(PBG_Cache(new),
          &((XmPushButtonGCacheObject)nsec)->pushbutton_cache,
          sizeof(XmPushButtonGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    _XmGadgetImportSecondaryArgs(new, args, num_args);

    XtSetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    bcopy(nsec, rsec, size);

    LabG_Cache(new) = &(((XmPushButtonGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmPushButtonGCacheObject)rsec)->label_cache);
    PBG_Cache(new) = &(((XmPushButtonGCacheObject)nsec)->pushbutton_cache);
    PBG_Cache(request) = &(((XmPushButtonGCacheObject)rsec)->pushbutton_cache);

    _XmExtImportArgs((Widget)nsec, args, num_args);

    return FALSE;
}

static Boolean
set_values_posthook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmWidgetExtData ext;

    /* Gaaaa.  Forgot the CachePart copy!!! */
    if (!_XmLabelCacheCompare(LabG_Cache(new), LabG_Cache(old))) {
	_XmCacheDelete((XtPointer)LabG_Cache(old));

	LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
				       (XtPointer)LabG_Cache(new),
				       sizeof(XmLabelGCacheObjPart));
    }
    else
	LabG_Cache(new) = LabG_Cache(old);

    if (!_XmPushBCacheCompare(PBG_Cache(new), PBG_Cache(old))) {

	_XmCacheDelete((XtPointer)PBG_Cache(old));

	PBG_Cache(new) = _XmCachePart(PBG_ClassCachePart(NULL),
				      (XtPointer)PBG_Cache(new),
				      sizeof(XmPushButtonGCacheObjPart));
    }
    else
	PBG_Cache(new) = PBG_Cache(old);

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);

    XtFree( (char *) ext);

    return FALSE;
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = False;
    Dimension margin, margin_extra;

    XdbDebug(__FILE__, new, "SetValues\n");

    if (!IN_MENU(new) &&
	(PBG_DefaultButtonShadow(new) != PBG_DefaultButtonShadow(old) ||
	 PBG_ShowAsDefault(new) != PBG_ShowAsDefault(old))) {

	margin = 0;
	margin_extra = 0;
	if (PBG_DefaultButtonShadow(new)) {
	    margin = 2 * PBG_DefaultButtonShadow(new) + LabG_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}
	else if (PBG_ShowAsDefault(new)) {
	    margin = 2 * PBG_ShowAsDefault(new) + LabG_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}

	LabG_MarginLeft(new) = margin + margin_extra;
	LabG_MarginRight(new) = margin + margin_extra;
	LabG_MarginTop(new) = margin + margin_extra;
	LabG_MarginBottom(new) = margin + margin_extra;

#if 1
	XtWidth(new) += 2 * (margin + margin_extra);
	XtHeight(new) += 2 * margin + margin_extra;
#else
 	_XmLabelRecomputeSize(new);
#endif

 	refresh_needed = True;
    }

    if (LabG_Accelerator(new) != LabG_Accelerator(old)) {
	_XmManagerUninstallAccelerator(XtParent(new), new);
	_XmManagerInstallAccelerator(XtParent(new), new, LabG_Accelerator(new));
	refresh_needed = True;
    }
    return refresh_needed;
}

static void
get_values_prehook(Widget new, ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(PBG_Cache(new),
          &((XmPushButtonGCacheObject)nsec)->pushbutton_cache,
          sizeof(XmPushButtonGCacheObjPart));

    /*
     * don't do this and ResInd will blow up.
     */
    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    XtGetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    _XmExtGetValuesHook((Widget)nsec, args, num_args);
}

static void
get_values_posthook(Widget new, ArgList args, Cardinal *num_args)
{
     XmWidgetExtData ext;

     _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

     _XmExtObjFree((XtPointer)ext->widget);

     XtFree( (char *) ext);
}

static void
get_values_hook(Widget w, ArgList args, Cardinal *num_args)
{
    XdbDebug(__FILE__, w, "GetValuesHook\n");
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
     /*
      * these make it easier to deal with the default button stuff
      * Nah.  All drawing is easier:)
      */
    Position normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    normal_shadow_x = LabG_Highlight(w) + LabG_MarginLeft(w);
    normal_shadow_y = LabG_Highlight(w) + LabG_MarginTop(w);
    
    normal_shadow_width = XtWidth(w) - 2 * LabG_Highlight(w) - LabG_MarginLeft(w) - LabG_MarginRight(w);
    normal_shadow_height = XtHeight(w) - 2 * LabG_Highlight(w) - LabG_MarginTop(w) - LabG_MarginBottom(w);

    XSetForeground(XtDisplayOfObject(w),
		   PBG_FillGC(w),
		   PBG_ArmColor(w));

    if (!IN_MENU(w))
    {
	/*
	 * If PBG_ShowAsDefault is 0 (= False), then no shadow is drawn !!
	 */
 	if (PBG_ShowAsDefault(w) > 0)
	{
 	    Dimension shad;
	    
 	    if (PBG_DefaultButtonShadow(w) == 0)
 		shad = PBG_ShowAsDefault(w);
 	    else
 		shad = PBG_DefaultButtonShadow(w);
	    
  	    _XmDrawShadows(XtDisplayOfObject(w), XtWindowOfObject(w),
  			   XmParentTopShadowGC(w),
  			   XmParentBottomShadowGC(w),
 			   XtX(w) + normal_shadow_x - (2 * shad + LabG_Shadow(w)),
 			   XtY(w) + normal_shadow_y - (2 * shad + LabG_Shadow(w)),
 			   normal_shadow_width + 2 * (2 * shad + LabG_Shadow(w)),
			   normal_shadow_height + 2 * (2 * shad + LabG_Shadow(w)),
 			   shad,
			   XmSHADOW_IN);
	}

	if (XtSensitive(w) && PBG_Armed(w) && PBG_FillOnArm(w))
	{
	    XFillRectangle(XtDisplayOfObject(w), 
			   XtWindowOfObject(w),
			   PBG_FillGC(w),
			   XtX(w) + normal_shadow_x + LabG_Shadow(w),
			   XtY(w) + normal_shadow_y + LabG_Shadow(w),
			   normal_shadow_width - 2 * LabG_Shadow(w),
			   normal_shadow_height - 2 * LabG_Shadow(w));
	}

	/* now draw the normal shadow */
	_XmDrawShadows(XtDisplayOfObject(w), 
		       XtWindowOfObject(w), 
		       XmParentTopShadowGC(w),
		       XmParentBottomShadowGC(w),
		       XtX(w) + normal_shadow_x,
		       XtY(w) + normal_shadow_y,
		       normal_shadow_width,
		       normal_shadow_height,
		       LabG_Shadow(w),
		       XtSensitive(w) && PBG_Armed(w) ? XmSHADOW_IN : XmSHADOW_OUT);
    }
    else
	_XmDrawShadows(XtDisplayOfObject(w), 
		       XtWindowOfObject(w), 
		       XmParentTopShadowGC(w),
		       XmParentBottomShadowGC(w),
		       XtX(w),  /* G_Highlight should be 0 in a menu */
		       XtY(w),
		       XtWidth(w),
		       XtHeight(w),
		       LabG_Shadow(w),
		       XtSensitive(w) && PBG_Armed(w) ? XmSHADOW_OUT : XmNO_LINE);

#define superclass (&xmLabelGadgetClassRec)
    (*superclass->rect_class.expose)(w, event, region);
#undef superclass
}

static Cardinal
get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data)
{
    /* FIXME */

    return _XmSecondaryResourceData(&_XmPushBGRectClassExtRec,
                                    data, NULL, NULL, NULL, NULL);
}

static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;
    Position normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XmProcessTraversal(w, XmTRAVERSE_CURRENT);

    PBG_Armed(w) = True;

    normal_shadow_x = LabG_Highlight(w) + LabG_MarginLeft(w);
    normal_shadow_y = LabG_Highlight(w) + LabG_MarginTop(w);

    normal_shadow_width = XtWidth(w) -
				(2 * LabG_Highlight(w)
				 + LabG_MarginLeft(w)
				 + LabG_MarginRight(w));
    normal_shadow_height = XtHeight(w) -
				(2 * LabG_Highlight(w)
				 + LabG_MarginTop(w)
				 + LabG_MarginBottom(w));

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.click_count = PBG_ClickCount(w);
    XFlush(XtDisplay(w));
    XtCallCallbackList(w,
		       PBG_ArmCallback(w),
		       (XtPointer)&cbs);

    _XmDrawShadows(XtDisplayOfObject(w),
		   XtWindowOfObject(w),
		   XmParentTopShadowGC(w),
		   XmParentBottomShadowGC(w),
		   XtX(w) + normal_shadow_x,
		   XtY(w) + normal_shadow_y,
		   normal_shadow_width, normal_shadow_height,
		   LabG_Shadow(w),
		   XmSHADOW_IN);

    if (PBG_FillOnArm(w))
    {
	XSetForeground(XtDisplayOfObject(w),
		       PBG_FillGC(w),
		       PBG_ArmColor(w));

	XFillRectangle(XtDisplayOfObject(w), 
		       XtWindowOfObject(w),
		       PBG_FillGC(w),
		       XtX(w) + normal_shadow_x + LabG_Shadow(w),
		       XtY(w) + normal_shadow_y + LabG_Shadow(w),
		       normal_shadow_width - 2 * LabG_Shadow(w),
		       normal_shadow_height - 2 * LabG_Shadow(w));

#define superclass (&xmLabelGadgetClassRec)
    (*superclass->rect_class.expose)(w, NULL, (Region)NULL);
#undef superclass
    }
}

static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;
    Position normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.click_count = PBG_ClickCount(w);
 
    normal_shadow_x = LabG_Highlight(w) + LabG_MarginLeft(w);
    normal_shadow_y = LabG_Highlight(w) + LabG_MarginTop(w);

    normal_shadow_width = XtWidth(w) -
				(2 * LabG_Highlight(w)
				 + LabG_MarginLeft(w)
				 + LabG_MarginRight(w));
    normal_shadow_height = XtHeight(w) -
				(2 * LabG_Highlight(w)
				 + LabG_MarginTop(w)
				 + LabG_MarginBottom(w));

    XFlush(XtDisplay(w));
    XtCallCallbackList(w,
		       PBG_DisarmCallback(w),
		       (XtPointer)&cbs);

    PBG_Armed(w) = False;

    _XmDrawShadows(XtDisplayOfObject(w),
		   XtWindowOfObject(w),
		   XmParentTopShadowGC(w),
		   XmParentBottomShadowGC(w),
		   XtX(w) + normal_shadow_x,
		   XtY(w) + normal_shadow_y,
		   normal_shadow_width, normal_shadow_height,
		   LabG_Shadow(w),
		   XmSHADOW_OUT);

    if (PBG_FillOnArm(w))
    {
	XClearArea(XtDisplayOfObject(w),
		   XtWindowOfObject(w),
		   XtX(w) + normal_shadow_x + LabG_Shadow(w),
		   XtY(w) + normal_shadow_y + LabG_Shadow(w),
		   normal_shadow_width - 2 * LabG_Shadow(w),
		   normal_shadow_height - 2 * LabG_Shadow(w),
		   False);

#define superclass (&xmLabelGadgetClassRec)
    (*superclass->rect_class.expose)(w, NULL, (Region)NULL);
#undef superclass
    }    
}

static void 
Activate(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    XdbDebug(__FILE__, w, "Activate\n");

#if 1
/*
 * Having this test breaks accelerators. Danny
 * MLM: Not having means PB's break if the button is released outside
 * the widget after it is armed.
 *
 * Test refined so it doesn't fail for accelerators. -- Danny
 */
    if (ev->type == KeyPress || ev->type == KeyRelease
	|| ((ev->x > XtX(w) && ev->x < XtX(w) + XtWidth(w))
	&& (ev->y > XtY(w) && ev->y < XtY(w) + XtHeight(w))))
#endif
    {
	cbs.reason = XmCR_ACTIVATE;
	cbs.event = event;
	cbs.click_count = PBG_ClickCount(w);

	XFlush(XtDisplay(w));
	XtCallCallbackList(w,
		           PBG_ActivateCallback(w),
		           (XtPointer)&cbs);
    }

    Disarm(w,event,params,num_params);
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "ArmAndActivate\n");

    Arm(w, event, params, num_params);
    Activate(w, event, params, num_params);
}

static void 
EnterWindow(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XdbDebug(__FILE__, w, "EnterWindow()\n");

    normal_shadow_x = LabG_Highlight(w) + LabG_MarginLeft(w);
    normal_shadow_y = LabG_Highlight(w) + LabG_MarginTop(w);
    
    normal_shadow_width = XtWidth(w) -
	(2 * LabG_Highlight(w)
	 + LabG_MarginLeft(w)
	 + LabG_MarginRight(w));
    normal_shadow_height = XtHeight(w) -
	(2 * LabG_Highlight(w)
	 + LabG_MarginTop(w)
	 + LabG_MarginBottom(w));

    if (LabG_MenuType(w) == XmWORK_AREA)
    {
	if (PBG_Armed(w))
	{
	    _XmDrawShadows(XtDisplayOfObject(w),
			   XtWindowOfObject(w),
			   XmParentTopShadowGC(w),
			   XmParentBottomShadowGC(w),
			   XtX(w) + normal_shadow_x,
			   XtY(w) + normal_shadow_y,
			   normal_shadow_width,
			   normal_shadow_height,
			   LabG_Shadow(w),
			   XmSHADOW_IN);
	    
	    if (PBG_FillOnArm(w))
	    {
		XSetForeground(XtDisplayOfObject(w),
			       PBG_FillGC(w),
			       PBG_ArmColor(w));

		XFillRectangle(XtDisplayOfObject(w), 
			       XtWindowOfObject(w),
			       PBG_FillGC(w),
			       XtX(w) + normal_shadow_x + LabG_Shadow(w),
			       XtY(w) + normal_shadow_y + LabG_Shadow(w),
			       normal_shadow_width - 2 * LabG_Shadow(w),
			       normal_shadow_height - 2 * LabG_Shadow(w));
		
#define superclass (&xmLabelGadgetClassRec)
		(*superclass->rect_class.expose)(w, NULL, (Region)NULL);
#undef superclass
	    }
	}
    }
    else /* we're in a menu */
    {
	if (_XmGetInDragMode(w))
	{
	    ShellWidget popupShell;

	    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
	    if  (popupShell)
	    {
		if (popupShell->shell.popped_up)
		    (* xmLabelGadgetClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, 
								    (Widget)popupShell, 
								    NULL, 
								    event, 
								    NULL);
	    }

	    _XmDrawShadows(XtDisplayOfObject(w),
			   XtWindowOfObject(w),
			   XmParentTopShadowGC(w),
			   XmParentBottomShadowGC(w),
			   XtX(w), /* LabG_Highlight should be 0 in a menu */
			   XtY(w),
			   XtWidth(w),
			   XtHeight(w),
			   LabG_Shadow(w),
			   XmSHADOW_OUT);

	    PBG_Armed(w) = True; 

	    MGR_SelectedGadget(XtParent(w)) = (XmGadget)w;

	    cbs.reason = XmCR_ARM;
	    cbs.event = event;
	    cbs.click_count = PBG_ClickCount(w);
	    XFlush(XtDisplay(w));
	    XtCallCallbackList(w,
			       PBG_ArmCallback(w),
			       (XtPointer)&cbs);
	}
    }
}

static void 
LeaveWindow(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    normal_shadow_x = LabG_Highlight(w) + LabG_MarginLeft(w);
    normal_shadow_y = LabG_Highlight(w) + LabG_MarginTop(w);
    
    normal_shadow_width = XtWidth(w) -
	(2 * LabG_Highlight(w)
	 + LabG_MarginLeft(w)
	 + LabG_MarginRight(w));
    normal_shadow_height = XtHeight(w) -
	(2 * LabG_Highlight(w)
	 + LabG_MarginTop(w)
	 + LabG_MarginBottom(w));
 
    if (LabG_MenuType(w) == XmWORK_AREA)
    {
	if (PBG_Armed(w))
	{
	    _XmDrawShadows(XtDisplayOfObject(w),
			   XtWindowOfObject(w),
			   XmParentTopShadowGC(w),
			   XmParentBottomShadowGC(w),
			   XtX(w) + normal_shadow_x,
			   XtY(w) + normal_shadow_y,
			   normal_shadow_width,
			   normal_shadow_height,
			   LabG_Shadow(w),
			   XmSHADOW_OUT);

	    if (PBG_FillOnArm(w))
	    {
		XClearArea(XtDisplayOfObject(w),
			   XtWindowOfObject(w),
			   XtX(w) + normal_shadow_x + LabG_Shadow(w),
			   XtY(w) + normal_shadow_y + LabG_Shadow(w),
			   normal_shadow_width - 2 * LabG_Shadow(w),
			   normal_shadow_height - 2 * LabG_Shadow(w),
			   False);
		
#define superclass (&xmLabelGadgetClassRec)
		(*superclass->rect_class.expose)(w, NULL, (Region)NULL);
#undef superclass
	    }
	}
    }
    else /* we're in a menu */
    {
	if (_XmGetInDragMode(w))
	{
	    _XmDrawShadows(XtDisplayOfObject(w),
			   XtWindowOfObject(w),
			   XmParentTopShadowGC(w),
			   XmParentBottomShadowGC(w),
 			   XtX(w), /* LabG_Highlight should be 0 in a menu */
 			   XtY(w),
 			   XtWidth(w),
			   XtHeight(w),
			   LabG_Shadow(w),
			   XmNO_LINE);

	    PBG_Armed(w) = False;

	    MGR_SelectedGadget(XtParent(w)) = NULL;

	    cbs.reason = XmCR_DISARM;
	    cbs.event = event;
	    cbs.click_count = PBG_ClickCount(w);
	    XFlush(XtDisplay(w));
	    XtCallCallbackList(w,
			       PBG_DisarmCallback(w),
			       (XtPointer)&cbs);
	}
    }
}

static void 
ButtonUp(Widget w, 
	 XEvent *event, 
	 String *params, 
	 Cardinal *num_params)
{
    Widget parent,shell;
    Boolean validButton, poppedUp;
    XmPushButtonCallbackStruct cbs;

    XdbDebug(__FILE__, w, "ButtonUp()\n");

    parent = XtParent(w);

    shell = parent;
    while (!XtIsShell(shell))
	shell = XtParent(shell);

    if (event && (event->type == ButtonRelease))
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON, parent, NULL, event, &validButton);

    if (!validButton)
	return;

    if (IN_MENU(w) && !XmIsMenuShell(shell))
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_POPDOWN, w, NULL, event, &poppedUp);
    else
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON_POPDOWN, w , NULL, event, &poppedUp);

    _XmRecordEvent(event);
    
    if (poppedUp)
	return;

    PBG_Armed(w) = False;

    XFlush(XtDisplay(w));

    cbs.reason = XmCR_ACTIVATE;
    cbs.event = event;
    cbs.click_count = PBG_ClickCount(w);
    XtCallCallbackList(w,
		       PBG_ActivateCallback(w),
		       NULL);

    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   XmParentTopShadowGC(w),
		   XmParentBottomShadowGC(w),
		   LabG_Highlight(w),
		   LabG_Highlight(w),
		   XtWidth(w) - 2 * LabG_Highlight(w),
		   XtHeight(w) - 2 * LabG_Highlight(w),
		   LabG_Shadow(w),
		   XmNO_LINE);

    _XmSetInDragMode(w, False);
}


static void 
ButtonDown(Widget w, 
	   XEvent *event, 
	   String *params, 
	   Cardinal *num_params)
{
   /* modified from the MegaButton widget */
    ShellWidget popupShell;
    int validButton;
    
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
    
    if (event && (event->type == ButtonPress))
    {
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON, 
							 XtParent(w), 
							 NULL, 
							 event, 
							 &validButton);
	if (!validButton)
	    return;
    }

    _XmSetInDragMode(w, True);

    PBG_Armed(w) = True;

    MGR_SelectedGadget(XtParent(w)) = (XmGadget)w;

    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
    if  (popupShell)
    {
	if (popupShell->shell.popped_up)
	    (* xmLabelGadgetClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, 
							    (Widget)popupShell, 
							    NULL, 
							    event, 
							    NULL);
    }

    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   XmParentTopShadowGC(w),
		   XmParentBottomShadowGC(w),
		   LabG_Highlight(w),
		   LabG_Highlight(w),
		   XtWidth(w) - 2 * LabG_Highlight(w),
		   XtHeight(w) - 2 * LabG_Highlight(w),
		   LabG_Shadow(w),
		   XmSHADOW_OUT);

    _XmRecordEvent(event);
}

static void
input_dispatch(Widget gadget, 
	       XEvent *event, 
	       Mask event_mask) 
{
    switch (event_mask)
    {
    case XmARM_EVENT:
	XdbDebug(__FILE__, gadget, "got arm event\n");
	if (XmIsRowColumn(XtParent(gadget)) 
	    && (RC_Type(XtParent(gadget)) == XmMENU_PULLDOWN))
	    ButtonDown(gadget, event, NULL, NULL);
	else
	    Arm(gadget, event, NULL, NULL);
	break;
    case XmACTIVATE_EVENT:
	XdbDebug(__FILE__, gadget, "got activate event\n");
/*
 * The test below is expanded so it also checks for the Shell.
 * In tearoff menus, the shell will be a TransientShell, thus we'll trigger the
 * Activate event.
 */
	if (LabG_MenuType(gadget) == XmMENU_PULLDOWN
		&& XtIsSubclass(XtParent(XtParent(gadget)), xmMenuShellWidgetClass))
	    ButtonUp(gadget, event, NULL, NULL);
	else
	    Activate(gadget, event, NULL, NULL);
	break;
    case XmENTER_EVENT:
	XdbDebug(__FILE__, gadget, "got an enter window\n");
	EnterWindow(gadget, event, NULL, NULL);
	break;
    case XmLEAVE_EVENT:
	XdbDebug(__FILE__, gadget, "got a leave cwindow\n");
	LeaveWindow(gadget, event, NULL, NULL);
	break;
    case XmMOTION_EVENT:
	XdbDebug(__FILE__, gadget, "got a motion event\n");
	break;
    case XmFOCUS_IN_EVENT:
	_XmFocusInGadget(gadget, event, NULL, NULL);
	break;
    case XmFOCUS_OUT_EVENT:
	_XmFocusOutGadget(gadget, event, NULL, NULL);
	break;
    default:
	_XmWarning(gadget, "PushButtonGadget got unknown event\n");
    }
}

void
_XmClearBGCompatibility(Widget pbg)
{
}

Widget
XmCreatePushButtonGadget(Widget parent,
		    char *name,
		    Arg *arglist,
		    Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmPushButtonGadgetClass,
			  parent,
			  arglist,
			  argcount);
}
