/**
 *
 * $Id: RowColumn.c,v 1.48 1996/05/02 21:13:15 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: RowColumn.c,v 1.48 1996/05/02 21:13:15 miers Exp $";

#include <LTconfig.h>
#include <X11/Xfuncs.h>
#include <Xm/XmP.h>
#include <Xm/BaseClassP.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/DebugUtil.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/ManagerP.h>
#include <Xm/MenuShellP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RepType.h>
#include <Xm/RowColumnP.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/TearOffBP.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/TransltnsP.h>

#include <string.h>

#define MOSAIC_27B4_HACK

/*
 * builtin widgets for option menus
 */
#define RC_OPTION_LABEL		"OptionLabel"
#define RC_OPTION_CBG		"OptionButton"

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void resize(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static XtGeometryResult geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply);
static void change_managed(Widget w);
static void insert_child(Widget w);
static void DeleteChild(Widget w);
static void DoLayout(Widget w);
static Widget getChildByPosition(Widget rc, int position);
static void prefered_size(Widget rc, Dimension *needed_width, Dimension *needed_height);
static void toggle_callback(Widget w, XtPointer cd, XtPointer cbs);
static void initialize_boxes(Widget w);

#define Offset(field) XtOffsetOf(XmRowColumnRec, row_column.field)

/* Resources for the RowColumn class */
static XtResource resources[] = {
    {
	XmNresizeWidth, XmCResizeWidth, XmRBoolean,
	sizeof(Boolean), Offset(resize_width),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNresizeHeight, XmCResizeHeight, XmRBoolean,
	sizeof(Boolean), Offset(resize_height),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNwhichButton, XmCWhichButton, XmRWhichButton,
	sizeof(unsigned int), Offset(postButton),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
	/* add support for this!!! */
    },
    {
	XmNmenuPost, XmCMenuPost, XmRString,
	sizeof(String), Offset(menuPost),
	XmRString, (XtPointer)NULL
    },
    {
	XmNadjustLast, XmCAdjustLast, XmRBoolean,
	sizeof(Boolean), Offset(adjust_last),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_width),
	XtRCallProc, (XtPointer)_XmRowColumnMarginDefault
       /* FIXME: should be XmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_height),
	XtRCallProc, (XtPointer)_XmRowColumnMarginDefault
	/* FIXME: should be XmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNentryCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(entry_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNmapCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(map_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNunmapCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(unmap_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNorientation, XmCOrientation, XmROrientation,
	sizeof(unsigned char), Offset(orientation),
	XmRImmediate, (XtPointer)XmVERTICAL
	/* FIXME: Should be XmROrientation, (XtPointer)some whacko thing here */
    },
    {
	XmNspacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(spacing),
	XtRCallProc, (XtPointer)_XmRowColumnSpacingDefault
	/* FIXME: Should beXmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNentryBorder, XmCEntryBorder, XmRHorizontalDimension,
	sizeof(Dimension), Offset(entry_border),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNisAligned, XmCIsAligned, XmRBoolean,
	sizeof(Boolean), Offset(do_alignment),
	XmRImmediate, (XtPointer)True
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNentryAlignment, XmCAlignment, XmRAlignment,
	sizeof(unsigned char), Offset(entry_alignment),
	XtRImmediate, (XtPointer)XmALIGNMENT_BEGINNING
	/* FIXME: Motif has XmRAlignment, (XtPointer)whacko value */
    },
    {
	XmNadjustMargin, XmCAdjustMargin, XmRBoolean,
	sizeof(Boolean), Offset(adjust_margin),
	XtRImmediate, (XtPointer)True
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNpacking, XmCPacking, XmRPacking,
	sizeof(unsigned char), Offset(packing),
	XtRCallProc, (XtPointer)_XmRowColumnPackingDefault
	/* FIXME: Motif has XmRPacking, (XtPointer)whacko value */
    },
    {
	XmNnumColumns, XmCNumColumns, XmRShort,
	sizeof(short), Offset(num_columns),
	XtRImmediate, (XtPointer)1
	/* FIXME: Motif has XmRShort, (XtPointer)whacko value */
    },
    {
	XmNradioBehavior, XmCRadioBehavior, XmRBoolean,
	sizeof(Boolean), Offset(radio),
	XmRImmediate, (XtPointer)False
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNradioAlwaysOne, XmCRadioAlwaysOne, XmRBoolean,
	sizeof(Boolean), Offset(radio_one),
	XmRImmediate, (XtPointer)True
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNisHomogeneous, XmCIsHomogeneous, XmRBoolean,
	sizeof(Boolean), Offset(homogeneous),
	XtRCallProc, (XtPointer)_XmRowColumnIsHomogeneousDefault
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNentryClass, XmCEntryClass, XmRWidgetClass,
	sizeof(WidgetClass), Offset(entry_class),
	XmRCallProc, (XtPointer)_XmRowColumnEntryClassDefault
	/* Motif has XmRWidgetClass, (XtPointer)NULL */
    },
    {
	XmNrowColumnType, XmCRowColumnType, XmRRowColumnType,
	sizeof(unsigned char), Offset(type),
	XtRImmediate, (XtPointer)XmWORK_AREA
	/* FIXME: Motif has XmRRowColumnType, (XtPointer)whacko value */
    },
    {
	XmNmenuHelpWidget, XmCMenuWidget, XmRMenuWidget,
	sizeof(Widget), Offset(help_pushbutton),
	XmRImmediate, (XtPointer)NULL
	/* FIXME: Motif has XmRMenuWidget, (XtPointer)whacko value */
    },
    {
	XmNlabelString, XmCXmString, XmRXmString,
	sizeof(XmString), Offset(option_label),
	XmRXmString, (XtPointer)NULL
    },
    {
	XmNsubMenuId, XmCMenuWidget, XmRMenuWidget,
	sizeof(Widget), Offset(option_submenu),
	XmRImmediate, (XtPointer)NULL
	/* FIXME: Motif has XmRMenuWidget, (XtPointer)whacko value */
    },
    {
	XmNmenuHistory, XmCMenuWidget, XmRMenuWidget,
	sizeof(Widget), Offset(memory_subwidget),
	XmRImmediate, (XtPointer)NULL
	/* FIXME: Motif has XmRMenuWidget, (XtPointer)whacko value */
    },
    {
	XmNpopupEnabled, XmCPopupEnabled, XmRBoolean,
	sizeof(Boolean), Offset(popup_enabled),
	XmRImmediate, (XtPointer)True
	/* FIXME: Motif has XmRBoolean, (XtPointer)whacko value */
    },
    {
	XmNmenuAccelerator, XmCAccelerators, XmRString,
	sizeof(String), Offset(menu_accelerator),
	XtRCallProc, (XtPointer)_XmRowColumnMenuAcceleratorDefault
	/* FIXME: Motif has XmRString, (XtPointer)whacko values */
    },
    {
	XmNmnemonic, XmCMnemonic, XmRKeySym,
	sizeof(KeySym), Offset(mnemonic),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNmnemonicCharSet, XmCMnemonicCharSet, XmRString,
	sizeof(String), Offset(mnemonicCharSet),
	XtRImmediate, (XtPointer)XmFONTLIST_DEFAULT_TAG
    },
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmRowColumnRec, manager.shadow_thickness),
	XmRImmediate, (XtPointer)0
	/* FIXME: Motif has XmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNpostFromList, XmCPostFromList, XmRWidgetList,
	sizeof(WidgetList), Offset(postFromList),
	XmRWidgetList, (XtPointer)NULL
    },
    {
	XmNpostFromCount, XmCPostFromCount, XmRInt,
	sizeof(int), Offset(postFromCount),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNnavigationType, XmCNavigationType, XmRNavigationType,
	sizeof(XmNavigationType), XtOffsetOf(XmRowColumnRec, manager.navigation_type),
	XmRImmediate, (XtPointer)((XmNavigationType)XmUNSPECIFIED)
    },
    {
	XmNentryVerticalAlignment, XmCVerticalAlignment, XmRVerticalAlignment,
	sizeof(unsigned char), Offset(entry_vertical_alignment),
	XtRImmediate, (XtPointer)XmALIGNMENT_BEGINNING
	/* FIXME: Motif has XmRVerticalAlignment, (XtPointer)whacko values */
    },
    {
	XmNtearOffModel, XmCTearOffModel, XmRTearOffModel,
	sizeof(unsigned char), Offset(TearOffModel),
	XtRImmediate, (XtPointer)XmTEAR_OFF_DISABLED
	/* FIXME: Motif has XmRTearOffModel, (XtPointer)whacko values */
    },
    {
	XmNtearOffMenuActivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(tear_off_activated_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNtearOffMenuDeactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(tear_off_deactivated_callback),
	XmRCallback, (XtPointer)NULL
    },
    {
	XmNinsertPosition, XmCInsertPosition, XmRFunction,
	sizeof(XtOrderProc), XtOffsetOf(XmRowColumnRec, composite.insert_position),
	XmRImmediate, (XtPointer)NULL /* FIXME: NEED PROC HERE */
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNmnemonicCharSet,
	sizeof(String), Offset(mnemonicCharSet),
	NULL /* FIXME */, NULL
    },
    {
	XmNmenuAccelerator,
	sizeof(String), Offset(menu_accelerator),
	NULL /* FIXME */, NULL
    },
    {
	XmNmenuPost,
	sizeof(String), Offset(menuPost),
	NULL /* FIXME */, NULL
    },
    {
	XmNlabelString,
	sizeof(XmString), Offset(option_label),
	NULL /* FIXME */, NULL
    },
    {
	XmNspacing,
	sizeof(Dimension), Offset(spacing),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginHeight,
	sizeof(Dimension), Offset(margin_height),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNmarginWidth,
	sizeof(Dimension), Offset(margin_width),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNentryBorder,
	sizeof(Dimension), Offset(entry_border),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }
};

#undef Offset

#define Offset(field) XtOffsetOf(XmRowColumnConstraintRec, row_column.field)

static XtResource rowColumnConstraintResources[] = {
    {
	XmNpositionIndex, XmCPositionIndex, XmRShort,
	sizeof(short), Offset(position_index),
	XmRImmediate, (XtPointer)XmLAST_POSITION
    }
};

/* not all actually written yet...*/
static void MenuBarEnter(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuBarLeave(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuBarGadgetSelect(Widget w, XEvent *event, String *params, Cardinal *num_params);

static void MenuBtnDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuBtnUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuHelp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuEnter(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuUnmap(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuFocusIn(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MenuFocusOut(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void DoBtnEventCleanupReplay(Widget w, XEvent *event, String *params, Cardinal num_params);
static Boolean ExternalBtnEvent(Widget w, XEvent *event);


char _XmRowColumn_menu_traversal_table[] =
    "<Unmap>:              MenuUnmap()\n\
     <EnterWindow>Normal:  MenuEnter()\n\
     <FocusIn>:            MenuFocusIn()\n\
     <FocusOut>:           MenuFocusOut()\n\
     <Key>osfHelp:         MenuHelp()\n\
     <Key>osfLeft:         MenuGadgetTraverseLeft()\n\
     <Key>osfRight:        MenuGadgetTraverseRight()\n\
     <Key>osfUp:           MenuGadgetTraverseUp()\n\
     <Key>osfDown:         MenuGadgetTraverseDown()";

char _XmRowColumn_bar_table[] =
    "<BtnDown>:            MenuBtnDown()\n\
     <BtnUp>:              MenuBtnUp()\n\
     <Key>osfSelect:       MenuBarGadgetSelect()\n\
     <Key>osfActivate:     MenuBarGadgetSelect()\n\
     <Key>osfHelp:         MenuHelp()\n\
     <Key>osfCancel:       MenuGadgetEscape()\n\
     ~s ~m ~a <Key>Return: MenuBarGadgetSelect()\n\
     ~s ~m ~a <Key>space:  MenuBarGadgetSelect()";

char _XmRowColumn_option_table[] =
   "<BtnDown>:             MenuBtnDown()\n\
    <BtnUp>:               MenuBtnUp()\n\
    <Key>osfActivate:      ManagerParentActivate()\n\
    <Key>osfCancel:        ManagerParentCancel()\n\
    <Key>osfSelect:        ManagerGadgetSelect()\n\
    <Key>osfHelp:          MenuHelp()\n\
    ~s ~m ~a <Key>Return:  ManagerParentActivate()\n\
    ~s ~m ~a <Key>space:   ManagerGadgetSelect()";

char _XmRowColumn_menu_table[] =
   "<BtnDown>:             MenuBtnDown()\n\
    <BtnUp>:               MenuBtnUp()\n\
    <Key>osfActivate:      ManagerGadgetSelect()\n\
    <Key>osfSelect:        ManagerGadgetSelect()\n\
    <Key>osfCancel:        MenuGadgetEscape()\n\
    <Key>osfHelp:          MenuHelp()\n\
    ~s ~m ~a <Key>Return:  ManagerGadgetSelect()\n\
    ~s ~m ~a <Key>space:   ManagerGadgetSelect()";

static XtActionsRec actions[] = {
    {"MenuBarEnter", MenuBarEnter},
    {"MenuBarLeave", MenuBarLeave},
    {"MenuBarGadgetSelect", MenuBarGadgetSelect},
    {"MenuBtnDown", MenuBtnDown},
    {"MenuBtnUp", MenuBtnUp},
    {"MenuFocusIn", MenuFocusIn},
    {"MenuFocusOut", MenuFocusOut},
    {"MenuHelp", MenuHelp},
    {"MenuUnmap", MenuUnmap},
    {"MenuEnter", MenuEnter},
    {"MenuGadgetEscape", _XmMenuEscape},
    {"MenuGadgetTraverseLeft", _XmRC_GadgetTraverseLeft},
    {"MenuGadgetTraverseRight", _XmRC_GadgetTraverseRight},
    {"MenuGadgetTraverseUp", _XmRC_GadgetTraverseUp},
    {"MenuGadgetTraverseDown", _XmRC_GadgetTraverseDown},
};

static XmBaseClassExtRec _XmRowColumnCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

static CompositeClassExtensionRec rcCompositeExt = {
    /* next_extension */  NULL,
    /* record_type    */  NULLQUARK,
    /* version        */  XtCompositeExtensionVersion,
    /* record_size    */  sizeof(CompositeClassExtensionRec),
    /* accepts_objects */ True,
#if XtSpecificationRelease >= 6
    /* allows_change_managed_set */ True
#endif
};

static XmManagerClassExtRec _XmRowColumnMClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmManagerClassExtVersion,
    /* record_size               */ sizeof(XmManagerClassExtRec),
    /* traversal_children        */ NULL /* FIXME */
};

XmRowColumnClassRec xmRowColumnClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmManagerClassRec,
        /* class_name            */ "XmRowColumn",
	/* widget_size           */ sizeof(XmRowColumnRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ XtInheritTranslations,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ XtInheritDisplayAccelerator,
	/* extension             */ (XtPointer)&_XmRowColumnCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */ geometry_manager, 
        /* change_managed   */ change_managed, 
        /* insert_child     */ insert_child,
        /* delete_child     */ DeleteChild,
        /* extension        */ (XtPointer)&rcCompositeExt,
    },
    /* Constraint class part */
    {
	/* subresources      */ rowColumnConstraintResources,
        /* subresource_count */ XtNumber(rowColumnConstraintResources),
        /* constraint_size   */ sizeof(XmRowColumnConstraintRec),    
        /* initialize        */ NULL, 
        /* destroy           */ NULL, 
        /* set_values        */ NULL, 
        /* extension         */ NULL, 
    },
    /* XmManager class part */
    {
        /* translations                 */ XmInheritTranslations,
        /* syn_resources                */ syn_resources,
        /* num_syn_resources            */ XtNumber(syn_resources),
        /* syn_constraint_resources     */ NULL,
        /* num_syn_constraint_resources */ 0,
        /* parent_process               */ XmInheritParentProcess,
	/* extension                    */ (XtPointer)&_XmRowColumnMClassExtRec
    },
    /* XmRowColumn Area part */
    {
	/* menuProcedures   */ NULL,  /* FIXME */
        /* armAndActivate   */ NULL,  /* FIXME */
        /* traversalHandler */ NULL,  /* FIXME */
	/* extension        */ NULL,  /* FIXME */
    },
};

WidgetClass xmRowColumnWidgetClass = (WidgetClass)&xmRowColumnClassRec;


static void 
class_initialize()
{
    _XmRowColumnCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    CompositeClassExtension ext, *extptr;
    XmRowColumnWidgetClass rc_class = (XmRowColumnWidgetClass)widget_class;

    extptr = (CompositeClassExtension*)_XmGetClassExtensionPtr((XmGenericClassExt*)&(rc_class->composite_class.extension),
							       NULLQUARK);

    if (extptr == NULL || *extptr == NULL)
    {
	ext = (CompositeClassExtension) XtNew(CompositeClassExtensionRec);
	if (ext != NULL)
	{
	    ext->next_extension = rc_class->composite_class.extension;
	    ext->record_type = NULLQUARK;
	    ext->version = XtCompositeExtensionVersion;
	    ext->record_size = sizeof(CompositeClassExtensionRec);
	    ext->accepts_objects = True;
#if XtSpecificationRelease >= 6
	    ext->allows_change_managed_set = True;
#endif
	    rc_class->composite_class.extension = (XtPointer) ext;
	}
    }

    _XmFastSubclassInit(widget_class, XmROW_COLUMN_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    if (RC_Type(new) == XmMENU_BAR || RC_Type(new) == XmMENU_POPUP
	|| RC_Type(new) == XmMENU_PULLDOWN)
    {
	MGR_ShadowThickness(new) = 2;
    }

    if (RC_Type(new) == XmWORK_AREA)
	MGR_NavigationType(new) = XmTAB_GROUP;
    else
	MGR_NavigationType(new) = XmNONE;
    
    if (RC_Type(new) == XmWORK_AREA || RC_Type(new) == XmMENU_OPTION)
	MGR_TraversalOn(new) = True;
    else
	MGR_TraversalOn(new) = False;
    
    /* now, we install our translations, 
       depending on the row column type */

    if (RC_Type(new) != XmWORK_AREA)
    {
	XtOverrideTranslations(new, 
			       XtParseTranslationTable(_XmRowColumn_menu_table));
	XtOverrideTranslations(new, 
			       XtParseTranslationTable(_XmRowColumn_menu_traversal_table));
    }

    if (RC_Type(new) == XmMENU_OPTION)
	XtOverrideTranslations(new, 
			       XtParseTranslationTable(_XmRowColumn_option_table));
    else if (RC_Type(new) == XmMENU_BAR)
	XtOverrideTranslations(new,
			       XtParseTranslationTable(_XmRowColumn_bar_table));

    RC_Boxes(new) = NULL; /* no initial children */

    /* Internal widgets */

    RC_CascadeBtn(new) = NULL;
    RC_MemWidget(new) = NULL;
    RC_PopupPosted(new) = NULL;
    RC_LastSelectToplevel(new) = NULL;

    if ((RC_Type(new) == XmMENU_PULLDOWN 
	 || RC_Type(new) == XmMENU_POPUP)
	&& RC_TearOffModel(new) == XmTEAR_OFF_ENABLED)
    {
	RC_TearOffControl(new) = XtVaCreateManagedWidget("tearoffcontrol",
			                            xmTearOffButtonWidgetClass,
			                            new,
			                            NULL);
    }
    else
	RC_TearOffControl(new) = NULL;

    if (RC_Type(new) == XmMENU_OPTION) 
    {
	XtVaCreateManagedWidget(RC_OPTION_LABEL,
				xmLabelGadgetClass,
				new,
				XmNlabelString, RC_OptionLabel(new),
				NULL);

	XtVaCreateManagedWidget(RC_OPTION_CBG,
				xmCascadeButtonGadgetClass,
				new,
				XmNsubMenuId, RC_OptionSubMenu(new),
				NULL);
    }

    /* just to initialize it. */
    RC_SetFromResize(new, 0);
}


static void
destroy(Widget w)
{
    if (RC_Boxes(w))
	XtFree((char*)RC_Boxes(w));

    if (RC_TearOffControl(w))
        XtDestroyWidget(RC_TearOffControl(w));
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean need_refresh = False;

    XdbDebug(__FILE__, new, "RowColumn set_values()\n");

    if ((RC_Orientation(old) != RC_Orientation(new))
	|| (RC_Packing(old) != RC_Packing(new)))
    {
	XtFree((char*)RC_Boxes(old));

	initialize_boxes(new);

	DoLayout(new);
	
	need_refresh = True;
    }

    if ((RC_TearOffModel(new) != RC_TearOffModel(old))
	&& (RC_Type(new) == XmMENU_POPUP
	    || RC_Type(new) == XmMENU_PULLDOWN))
    {
	if (RC_TearOffModel(new) == XmTEAR_OFF_ENABLED)
	    RC_TearOffControl(new) = XtVaCreateManagedWidget("TearOffControl",
				                   xmTearOffButtonWidgetClass,
				                   new,
				                   XmNpositionIndex, 0, 
				                   NULL);
	else
	    XtDestroyWidget(MGR_Children(old)[0]); /* FIX ME */
    }

    return need_refresh;
}

static void 
expose(Widget w, 
       XEvent *event, 
       Region region)
{
    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   MGR_TopShadowGC(w),
		   MGR_BottomShadowGC(w),
		   0,0,
		   XtWidth(w),
		   XtHeight(w),
		   MGR_ShadowThickness(w),
		   XmSHADOW_OUT);

    /* display the gadgets, if there are any */
    _XmRedisplayGadgets(w, event, region);
}

static XtGeometryResult 
query_geometry(Widget w, 
	       XtWidgetGeometry *request, 
	       XtWidgetGeometry *reply)
{
    XtGeometryResult result = XtGeometryYes;
    Dimension width, height;

    prefered_size(w, &width, &height);
    XdbDebug(__FILE__, w, "prefered_size calculates w/h %d %d\n", width, height);
    if (request->request_mode & CWWidth)
        XdbDebug(__FILE__, w, "preferred width %d\n", request->width);
    if (request->request_mode & CWHeight)
        XdbDebug(__FILE__, w, "preferred height %d\n", request->height);
    reply->width = width;
    reply->height = height;

    request->request_mode &= CWWidth | CWHeight;	/* Not interested in more flags */

    if (request->request_mode == 0) {
	reply->request_mode = CWWidth | CWHeight;
	XdbDebug(__FILE__, w, "query_geometry(NULL) returning XtGeometryYes, %d %d\n", width, height);
	return result;
    }

    if (request->request_mode & CWWidth) 
	if (request->width < width){
	    result = XtGeometryAlmost;
	    reply->width = width;
	    reply->request_mode |= CWWidth;
	}
    if (request->request_mode & CWHeight) 
	if (request->height < height){
	    result = XtGeometryAlmost;
	    reply->height = height;
	    reply->request_mode |= CWHeight;
	}    

    reply->width = width;
    reply->height = height;
    reply->request_mode = CWWidth | CWHeight;

    XdbDebug(__FILE__, w, "query_geometry() returning %s, %d %d\n",
	XdbGeometryResult2String(result), width, height);

    return result;
}

static void
initialize_boxes(Widget w)
{
    int i;
    XmRCKidGeometry kid_geometry;

    XdbDebug(__FILE__, w, "initialize_boxes(%d children)\n", MGR_NumChildren(w));

    RC_Boxes(w) = (XmRCKidGeometry)XtCalloc(MGR_NumChildren(w), sizeof(XmRCKidGeometryRec));
    
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	Dimension *baselines;
	int number_of_baselines;

	kid_geometry = &(RC_Boxes(w)[i]);
	kid_geometry->kid = getChildByPosition(w, i);
	
	XtQueryGeometry(kid_geometry->kid, NULL, &(RC_Boxes(w)[i].box));

	XdbDebug(__FILE__, w, "Queried geometry: w/h %d %d: %s\n",
		kid_geometry->box.width, kid_geometry->box.height,
		XtName(kid_geometry->kid));

	kid_geometry->margin_top =
	    kid_geometry->margin_bottom = 0;
	XtVaGetValues(kid_geometry->kid,
		      XmNmarginTop, &kid_geometry->margin_top,
		      XmNmarginBottom, &kid_geometry->margin_bottom,
		      NULL);
	
	if (XmWidgetGetBaselines(kid_geometry->kid, &baselines, &number_of_baselines))
	{
	    /* we set the baseline of the child to the lowest baseline of
	       the widget */
	    kid_geometry->baseline = baselines[number_of_baselines-1];
	    
	    XtFree((char*)baselines);
	}
	else
	    kid_geometry->baseline = 0; /* is this right ? */
    }
}

static void
prefered_size_HT(Widget w,
		 Dimension *needed_width,
		 Dimension *needed_height)
{
    int i;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension max_width = 0;
    Dimension max_height = 0;
    XmRCKidGeometry kid_geometry;
    Widget kid;

    if (!RC_Boxes(w)) {
	*needed_width = 2 * (RC_MarginW(w) + MGR_ShadowThickness(w));
	*needed_height = 2 * (RC_MarginH(w) + MGR_ShadowThickness(w));
	return;
    }
    for (i=0; i< MGR_NumChildren(w); i++)
    {
	kid_geometry = &(RC_Boxes(w)[i]);
	kid = kid_geometry->kid;

	if (!kid || !XtIsManaged(kid))
	    continue;

	if (XtIsRealized((Widget)w) && current_x + kid_geometry->box.width > XtWidth(w))
	{
	    current_y += max_height + RC_Spacing(w);
	    current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
	}

	if (i == MGR_NumChildren(w) - 1) /* don't add the spacing after the last child */
	    current_x += kid_geometry->box.width;
	else
	    current_x += RC_Spacing(w) + kid_geometry->box.width;

	if (current_x > max_width)
	    max_width = current_x;

	if (kid_geometry->box.height + current_y > max_height)
	    max_height = kid_geometry->box.height + current_y;
    }

    *needed_width = max_width + RC_MarginW(w) + MGR_ShadowThickness(w);
    *needed_height = max_height + RC_MarginH(w) + MGR_ShadowThickness(w);
}

static void
prefered_size_HC(Widget w,
		 Dimension *needed_width,
		 Dimension *needed_height)
{
    int i;
    int number_per_row;
    Dimension width_of_widgets = 0;
    Dimension *height_of_row;

    if (RC_NCol(w) == 0)
	/* what the hell.  punt and go to .. */
	prefered_size_HT(w, needed_width, needed_height);

    XdbDebug(__FILE__, w, "prefered_size_HC()\n");
	    
#define ROW_OF_THIS_WIDGET(i) (int)((float)(i) / number_per_row + 0.5)

    /* we need to round up */
    number_per_row = (int)((float)MGR_NumChildren(w) / RC_NCol(w) + 0.5);
    
    height_of_row = (Dimension*)XtCalloc(RC_NCol(w), sizeof(Dimension));
    
    for (i=0; i<RC_NCol(w); i++)
	height_of_row[i] = 0;
    
    /* first, figure out the width of each column and the height of each row */
    
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	Widget kid = kid_geometry->kid;
	
	if (!kid || !XtIsManaged(kid))
	    continue;

	if (width_of_widgets < kid_geometry->box.width)
	    width_of_widgets = kid_geometry->box.width;

	if (height_of_row[ ROW_OF_THIS_WIDGET(i) ] < kid_geometry->box.height)
	    height_of_row[ ROW_OF_THIS_WIDGET(i) ] = kid_geometry->box.height;
    }

    /* then we multiply and add :) */

    *needed_width = (2 * (RC_MarginW(w) + MGR_ShadowThickness(w)) 
		     + width_of_widgets * number_per_row 
		     + RC_Spacing(w) * (number_per_row - 1));
		     
    *needed_height = (2 * (RC_MarginH(w) + MGR_ShadowThickness(w))
		      + RC_Spacing(w) * (RC_NCol(w) - 1));

    for (i = 0; i < RC_NCol(w); i++)
	*needed_height += height_of_row[i];
}
    
static void
prefered_size_VT(Widget w,
		 Dimension *needed_width,
		 Dimension *needed_height)
{
    int i;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension max_width = 0;
    Dimension max_height = 0;

    if (!RC_Boxes(w)) {
	*needed_width = 2 * (RC_MarginW(w) + MGR_ShadowThickness(w));
	*needed_height = 2 * (RC_MarginH(w) + MGR_ShadowThickness(w));
	return;
    }
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	Widget kid = kid_geometry->kid;

	if (!kid || !XtIsManaged(kid))
	    continue;

	if (XtIsRealized(w) && current_y + kid_geometry->box.height > XtHeight(w))
	{
	    current_x += max_width + RC_Spacing(w);
	    current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
	}

	if (i == MGR_NumChildren(w) - 1) /* don't add the spacing after the last child */
	    current_y += kid_geometry->box.height;
	else
	    current_y += RC_Spacing(w) + kid_geometry->box.height;

	if (current_y > max_height)
	    max_height = current_y;

	if (kid_geometry->box.width + current_x > max_width)
	    max_width = kid_geometry->box.width + current_x;
    }

    *needed_width = max_width + RC_MarginW(w) + MGR_ShadowThickness(w);
    *needed_height = max_height + RC_MarginH(w) + MGR_ShadowThickness(w);
}

static void
prefered_size_VC(Widget w,
		 Dimension *needed_width,
		 Dimension *needed_height)
{
    int i;
    int number_per_column;
    Dimension height_of_widgets = 0;
    Dimension *width_of_column;

    if (RC_NCol(w) == 0)
	/* what the hell.  punt and go to .. */
	prefered_size_VT(w, needed_width, needed_height);

    XdbDebug(__FILE__, w, "prefered_size_VC()\n");
	    
/*
 * This calculation makes the range of column numbers 1 .. NCOL,
 *	and *not* 0..NCOL-1.
 * Therefore, the for loops in this routine must have that range.
 *
 * Danny 19/3/1996.
 */
#define COLUMN_OF_THIS_WIDGET(i) (int)((float)(i) / number_per_column + 0.5)

    /* we need to round up */
    number_per_column = (int)((float)MGR_NumChildren(w) / RC_NCol(w) + 0.5);
    
    width_of_column = (Dimension*)XtCalloc(RC_NCol(w) + 1, sizeof(Dimension));
 
    for (i=0; i<RC_NCol(w) + 1; i++)
	width_of_column[i] = 0;
    
    /* first, figure out the width of each column and the height of each row */
    
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	Widget kid = kid_geometry->kid;
	
	if (!kid || !XtIsManaged(kid))
	    continue;

	if (height_of_widgets < kid_geometry->box.height)
	    height_of_widgets = kid_geometry->box.height;

	if (width_of_column[ COLUMN_OF_THIS_WIDGET(i) ] < kid_geometry->box.width)
	    width_of_column[ COLUMN_OF_THIS_WIDGET(i) ] = kid_geometry->box.width;
    }

    /* then we multiply and add :),

       as a special case, if we're doing tear off stuff, we can decrement
       the number_per_column count by one, and explicitly add the height
       of the tear off button. */

    *needed_width = (2 * (RC_MarginW(w) + MGR_ShadowThickness(w)) 
		     + RC_Spacing(w) * (RC_NCol(w) - 1));

		    
    if ((RC_Type(w) == XmMENU_PULLDOWN
         || RC_Type(w) == XmMENU_POPUP)
        && RC_TearOffModel(w) == XmTEAR_OFF_ENABLED)
    {
        *needed_height = (2 * (RC_MarginH(w) + MGR_ShadowThickness(w))
                          + height_of_widgets * (number_per_column - 1)
                          + XtHeight(RC_TearOffControl(w))
		          + RC_Spacing(w) * (number_per_column - 1));
                          
    }
    else
        *needed_height = (2 * (RC_MarginH(w) + MGR_ShadowThickness(w))
		          + height_of_widgets * number_per_column
		          + RC_Spacing(w) * (number_per_column - 1));

    for (i = 0; i < RC_NCol(w) + 1; i++)
	*needed_width += width_of_column[i];

    XdbDebug(__FILE__, w, "  I really need to be %dx%d...\n", *needed_width, *needed_height);
    XtFree((XtPointer)width_of_column);
}

static void
prefered_size(Widget w, 
	      Dimension *needed_width,
	      Dimension *needed_height)
{
    *needed_width = 0;
    *needed_height = 0;

    switch(RC_Type(w))
    {
    case XmWORK_AREA:
	switch (RC_Orientation(w))
	{
	case XmHORIZONTAL:
	    if (RC_Packing(w) == XmPACK_TIGHT)
		prefered_size_HT(w, needed_width, needed_height);
	    else if (RC_Packing(w) == XmPACK_COLUMN)
		prefered_size_HC(w, needed_width, needed_height);
	    break;
	case XmVERTICAL:
	    if (RC_Packing(w) == XmPACK_TIGHT)
		prefered_size_VT(w, needed_width, needed_height);
	    else if (RC_Packing(w) == XmPACK_COLUMN)
		prefered_size_VC(w, needed_width, needed_height);
	    break;
	}
	break;
    case XmMENU_BAR:
	prefered_size_HT(w, needed_width, needed_height);
	break;
    case XmMENU_PULLDOWN:
    case XmMENU_POPUP:
	prefered_size_VC(w, needed_width, needed_height);
	break;
    case XmMENU_OPTION:
	prefered_size_HT(w, needed_width, needed_height);
	break;
    }
}

static void 
DoLayoutHT(Widget w)
{    
    int i,j;
    int first_in_row = 0;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension max_height = 0;
    Dimension our_width;
    
    XdbDebug(__FILE__, w, "DoLayoutHT()\n");

    if (RC_FromResize(w))
	our_width = XtWidth(w);
    else
	our_width = 65535; /* something higher than it should ever really be */

    XdbDebug(__FILE__, w, "Our width: %d\n", our_width);

    /* we have figure out the layout of the children */
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	Widget kid = kid_geometry->kid;

	if (kid_geometry->box.height > max_height)
	    max_height = kid_geometry->box.height;

	if (!kid || !XtIsManaged(kid))
	    continue;
	
	if (RC_Type(w) == XmMENU_BAR && kid == RC_HelpPb(w))
	    continue; /* don't lay it out until the end */
	
	if (current_x + kid_geometry->box.width > our_width)
	{
	    /* we're done with this row.  Now, go back, and make
	     * them all the same height */
	  for (j=first_in_row; j<i; j++)
          {
	      XmRCKidGeometry kid2_geometry = &(RC_Boxes(w)[j]);
	      Widget kid2 = kid2_geometry->kid;

	      if (!kid2 || !XtIsManaged(kid2))
		continue;

  	      XdbDebug(__FILE__, w, "Setting height to %d\n", max_height);
	      
	      kid2_geometry->box.height = max_height;
	  }
	    
#if 0
/* this seems to cause problems in the adjust last test below */
	    current_y += max_height + RC_Spacing(w);
#else
	    current_y = max_height + RC_Spacing(w);
#endif
	    current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
	    first_in_row = i;

	    max_height = 0;
	}
	
	kid_geometry->box.x = current_x;
	kid_geometry->box.y = current_y;
	
	current_x += RC_Spacing(w) + kid_geometry->box.width;
    }
    
    /* now we fill in the last row, so it takes up the remaining height, if XmNadjustLast is True. */
    if (RC_AdjLast(w) && RC_FromResize(w)) {
	for (j=first_in_row; j<MGR_NumChildren(w); j++)
	{
	    XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[j]);
	    Widget kid = kid_geometry->kid;
	    
	    if (!kid || !XtIsManaged(kid))
		continue;

#if 0
/* this original code is a problem if XtHeight(w) is zero */
	    kid_geometry->box.height = XtHeight(w) - (current_y
						      + RC_MarginH(w)
						      + MGR_ShadowThickness(w));
#else
#ifndef MOSAIC_27B4_HACK
	    if ((XtHeight(w) <= current_y + RC_MarginH(w)) 
		|| (max_height - current_y > XtHeight(w) - (current_y + RC_MarginH(w))))
            {
	        if (current_y + max_height > XtHeight(w) - (current_y + RC_MarginH(w)))
  		    kid_geometry->box.height = XtHeight(w) - (current_y + RC_MarginH(w) + MGR_ShadowThickness(w));		    
		else
		    kid_geometry->box.height = max_height;
	    }
#else
	    if (XtHeight(w) < (current_y + RC_MarginH(w)))
		;
#endif
	    else
		kid_geometry->box.height = XtHeight(w) - (current_y + RC_MarginH(w) + MGR_ShadowThickness(w));
#endif
	}
    }

    if (RC_Type(w) == XmMENU_BAR && RC_HelpPb(w))
    {
	/* first we find the help child in the boxes array, and then set it's position */
	XmRCKidGeometry help_kid_geometry = &(RC_Boxes(w)[RC_constraint_IndexPosition(RC_HelpPb(w))]);
	
	help_kid_geometry->box.x = (our_width
				    - MGR_ShadowThickness(w) 
				    - help_kid_geometry->box.width);
	help_kid_geometry->box.y = current_y;
   }

    RC_SetFromResize(w, 0);
}

static void
DoLayoutHC(Widget w)
{
    int i;
    int number_per_row;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension width_of_widgets = 0;
    Dimension *height_of_row;
    XmRCKidGeometry kid_geometry;
    Widget kid;
	    
    XdbDebug(__FILE__, w, "DoLayoutVC()\n");

#define ROW_OF_THIS_WIDGET(i) (int)((float)(i) / number_per_row + 0.5)

    if (RC_NCol(w) == 0)
	/* what the hell.  punt and go to .. */
	DoLayoutHT(w);

    /* we need to round up */
    number_per_row = (int)((float)MGR_NumChildren(w) / RC_NCol(w) + 0.5);
    
    height_of_row = (Dimension*)XtCalloc(RC_NCol(w), sizeof(Dimension));
    
    for (i=0; i<RC_NCol(w); i++)
	height_of_row[i] = 0;
    
    /* first, figure out the width of each column and the height of each row */
    
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	kid_geometry = &(RC_Boxes(w)[i]);
	kid = kid_geometry->kid;
	
	if (!kid || !XtIsManaged(kid))
	    continue;
	
	if (width_of_widgets < kid_geometry->box.width)
	    width_of_widgets = kid_geometry->box.width;
	
	if (height_of_row[ ROW_OF_THIS_WIDGET(i) ] < kid_geometry->box.height)
	    height_of_row[ ROW_OF_THIS_WIDGET(i) ] = kid_geometry->box.height;
    }
    
    /* now we lay out the children */
    
    for (i = 0; i < MGR_NumChildren(w); i++)
    {
	if (i != 0 && (i % number_per_row) == 0)
	{
	    current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
	    current_y += height_of_row[ ROW_OF_THIS_WIDGET(i) ] + RC_Spacing(w);
	}

	kid_geometry = &(RC_Boxes(w)[i]);
	kid = kid_geometry->kid;
	
	if (!kid || !XtIsManaged(kid))
	    continue;
	
	kid_geometry->box.x = current_x;
	kid_geometry->box.y = current_y;
	
	kid_geometry->box.width = width_of_widgets;
	kid_geometry->box.height = height_of_row[ ROW_OF_THIS_WIDGET(i) ];
	
	current_x += RC_Spacing(w) + width_of_widgets;
    }
    
    /* now we fill in the last row, so it takes up the remaining height, if XmNadjustLast is True. */
    if (RC_AdjLast(w))
	for (i=MGR_NumChildren(w) - number_per_row; i<MGR_NumChildren(w); i++)
	{
	    kid_geometry = &(RC_Boxes(w)[i]);
	    kid = kid_geometry->kid;
	    
	    if (!kid || !XtIsManaged(kid))
		continue;
	    
	    kid_geometry->box.height = XtHeight(w) - (current_y + RC_MarginH(w) + MGR_ShadowThickness(w));
	}

#undef ROW_OF_THIS_WIDGET
}

static void 
DoLayoutVT(Widget w)
{    
    int i,j;
    int first_in_column = 0;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension max_width = 0;

    XdbDebug(__FILE__, w, "DoLayoutVT()\n");

    for (i=0; i<MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	Widget kid = kid_geometry->kid;

	if (!kid || !XtIsManaged(kid))
	    continue;

	if (current_y + kid_geometry->box.height > XtHeight(w))
	{
	    /* we're done with this column.  Now, go back, and make them all the same width */
	    for (j=first_in_column; j<i; j++)
	    {
		XmRCKidGeometry kid2_geometry = &(RC_Boxes(w)[i]);
		Widget kid2 = kid2_geometry->kid;

		if (!kid2 || !XtIsManaged(kid2))
		    continue;

		kid2_geometry->box.width = max_width;

	    }

	    current_x += max_width + RC_Spacing(w);
	    current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
	    first_in_column = i;

	    max_width = 0;
	}

	kid_geometry->box.x = current_x;
	kid_geometry->box.y = current_y;
	
	current_y += RC_Spacing(w) + kid_geometry->box.height;

	if (kid_geometry->box.width > max_width)
	    max_width = kid_geometry->box.width;
    }

    /* now we fill in the last column, so it takes up the remaining width, if XmNadjustLast is True. */
    if (RC_AdjLast(w))
    {
        XdbDebug(__FILE__, w, "DoLayoutVT -- adjusting last column\n");
	for (j=first_in_column; j<MGR_NumChildren(w); j++)
	{
	    XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[j]);
	    Widget kid = kid_geometry->kid;

	    if (!kid || !XtIsManaged(kid))
		continue;

#ifndef MOSAIC_27B4_HACK
	    if ((XtWidth(w) <= current_x + RC_MarginW(w)) 
		|| (max_width - current_x > XtWidth(w) - (current_x + RC_MarginW(w))))
	    {
		if (current_x + max_width > XtWidth(w) - (current_x + RC_MarginW(w))) 
                    kid_geometry->box.width = XtWidth(w) - (current_x + RC_MarginW(w) + MGR_ShadowThickness(w));
                else 
		    kid_geometry->box.width = max_width;
	    }
#else
	    if (XtWidth(w) < (current_x + RC_MarginW(w)))
		;
#endif
	    else
		kid_geometry->box.width = XtWidth(w) - (current_x + RC_MarginW(w) + MGR_ShadowThickness(w));
	}
    }
}

static void
DoLayoutVC(Widget w)
{
    int i,j;
    int starting;
    int number_per_column;
    Dimension current_x = RC_MarginW(w) + MGR_ShadowThickness(w);
    Dimension current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
    Dimension height_of_widgets = 0;
    Dimension *width_of_column;
    Widget kid;
    XmRCKidGeometry kid_geometry;

    XdbDebug(__FILE__, w, "DoLayoutVC()\n");

#define COLUMN_OF_THIS_WIDGET(i) (int)((float)(i) / number_per_column + 0.5)

    if (RC_NCol(w) == 0)
	/* what the hell.  punt and go to .. */
	DoLayoutVT(w);

    /* we need to round up */
    number_per_column = (int)((float)MGR_NumChildren(w) / RC_NCol(w) + 0.5);
    
    width_of_column = (Dimension*)XtCalloc(RC_NCol(w), sizeof(Dimension));
    
    for (i=0; i<RC_NCol(w); i++)
	width_of_column[i] = 0;
    
    /* first, figure out the height of each row and the width of each column */
    
    for (i=0; i<MGR_NumChildren(w); i++)
    {
	kid_geometry = &(RC_Boxes(w)[i]);
	kid = kid_geometry->kid;
	
	if (!kid || !XtIsManaged(kid))
	    continue;

	if (height_of_widgets < kid_geometry->box.height)
	    height_of_widgets = kid_geometry->box.height;

	if (width_of_column[ COLUMN_OF_THIS_WIDGET(i) ] < kid_geometry->box.width)
	    width_of_column[ COLUMN_OF_THIS_WIDGET(i) ] = kid_geometry->box.width;
    }

    /* now we lay out the children */

    /* First, we do our tear off control, if we have one */

    if ((RC_Type(w) == XmMENU_POPUP
         || RC_Type(w) == XmMENU_PULLDOWN)
        && RC_TearOffModel(w) == XmTEAR_OFF_ENABLED)
    {
        kid_geometry = &(RC_Boxes(w)[0]); /* the tear off control is here */
        kid = kid_geometry->kid;

        kid_geometry->box.x = current_x;
        kid_geometry->box.y = current_y;
        kid_geometry->box.width =  width_of_column[ COLUMN_OF_THIS_WIDGET(i) ];
        kid_geometry->box.height = XtHeight(kid);

        current_y += RC_Spacing(w) + kid_geometry->box.height;
        starting = 1;
    }
    else
        starting = 0;

    for (i = starting; i < MGR_NumChildren(w); i++)
    {
	
	if (i != 0 && (i % number_per_column) == 0)
	{
	    current_y = RC_MarginH(w) + MGR_ShadowThickness(w);
	    current_x += width_of_column[ COLUMN_OF_THIS_WIDGET(i) ] + RC_Spacing(w);
	}

	kid_geometry = &(RC_Boxes(w)[i]);
	kid = kid_geometry->kid;

	if (!kid || !XtIsManaged(kid) || XmIsTearOffButton(kid))
	    continue;

	kid_geometry->box.x = current_x;
	kid_geometry->box.y = current_y;

	kid_geometry->box.width = width_of_column[ COLUMN_OF_THIS_WIDGET(i) ];
	kid_geometry->box.height = height_of_widgets;

	current_y += RC_Spacing(w) + height_of_widgets;
    }

    /* now we fill in the last column 
       so it takes up the remaining width 
       if XmNadjustLast is True. */
    if (RC_AdjLast(w))
	for (j = MGR_NumChildren(w) - number_per_column; 
             j < MGR_NumChildren(w);  
             j++)
	{
	    kid_geometry = &(RC_Boxes(w)[j]);
	    kid = kid_geometry->kid;


	    if (!kid || !XtIsManaged(kid))
		continue;

	    if (current_x + RC_MarginW(w) + MGR_ShadowThickness(w) < XtWidth(w))
		kid_geometry->box.width = (XtWidth(w) 
                                           - current_x 
                                           - RC_MarginW(w) 
                                           - MGR_ShadowThickness(w));
	    XdbDebug2(__FILE__, w, kid, "adjusting child to width %d\n", 
		      kid_geometry->box.width);
	}
}

static void
DoLayout(Widget w)
{
    int i;

    /* No need to do anything else if we don't have any children */
    if (MGR_NumChildren(w) == 0)
	return;

    XdbDebug(__FILE__, w, "From DoLayout\n");

    if (RC_FromResize(w) || !RC_Boxes(w))
    {
	XtFree((XtPointer)RC_Boxes(w));
	initialize_boxes(w);
    }

    switch(RC_Type(w))
    {
    case XmWORK_AREA:
	switch (RC_Orientation(w))
	{
	case XmHORIZONTAL:
	    if (RC_Packing(w) == XmPACK_TIGHT)
		DoLayoutHT(w);
	    else if (RC_Packing(w) == XmPACK_COLUMN)
		DoLayoutHC(w);
	    break;
	case XmVERTICAL:
	    if (RC_Packing(w) == XmPACK_TIGHT)
		DoLayoutVT(w);
	    else if (RC_Packing(w) == XmPACK_COLUMN)
		DoLayoutVC(w);
	    break;
	}
	break;
    case XmMENU_BAR:
	DoLayoutHT(w);
	break;
    case XmMENU_PULLDOWN:
    case XmMENU_POPUP:
	DoLayoutVC(w);
	break;
    case XmMENU_OPTION:
	DoLayoutHT(w);
	break;
    }

    /* here we actually lay out our children.  */
    
    for (i=0; i < MGR_NumChildren(w); i++)
    {
	XmRCKidGeometry kid_geometry = &(RC_Boxes(w)[i]);
	
	_XmConfigureObject(kid_geometry->kid,
			   kid_geometry->box.x,
			   kid_geometry->box.y,
			   kid_geometry->box.width,
			   kid_geometry->box.height,
			   XtBorderWidth(kid_geometry->kid));
    }
}

static void
resize(Widget w)
{
    RC_SetFromResize(w, 1);

    DoLayout(w);
} 

static XtGeometryResult
geometry_manager(Widget w,
		 XtWidgetGeometry *request,
		 XtWidgetGeometry *reply)
{
    Widget rc = XtParent(w);
    
    if (XmIsMenuShell(XtParent(rc))) 
	/* we're the direct child of a menu shell, so allow any resizing -- FIX ME */
    {
	Widget msw = XtParent(rc);

	reply->width = request->width;
	reply->height = request->height;

	XtWidth(rc) += (request->width - XtWidth(w));
	XtHeight(rc) += (request->height - XtHeight(w));

	XtWidth(msw) += (request->width - XtWidth(w));
	XtHeight(msw) += (request->height - XtHeight(w));
    }

    return XtGeometryYes;
}

static void
change_managed(Widget w)
{
    Dimension my_width, my_height;
    
    XdbDebug(__FILE__, w, "change_managed()\n");

    XtFree((XtPointer)RC_Boxes(w));
    initialize_boxes(w);

    prefered_size(w, &my_width, &my_height);

    if (!XtIsRealized(w))
    {
	XtWidth(w) = my_width;
	XtHeight(w) = my_height;
	
	if (XmIsMenuShell(XtParent(w)))
	{
	    XtWidth(XtParent(w)) = my_width;
	    XtHeight(XtParent(w)) = my_height;
	}
    }

    DoLayout(w);

    _XmNavigChangeManaged(w);
}

static void
toggle_callback(Widget w, 
                XtPointer cd,
                XtPointer cs)
{
    Widget tgl;
    Widget rc = (Widget)cd;
    XmToggleButtonCallbackStruct *cbs = (XmToggleButtonCallbackStruct *)cs;
    int i;

    for (i = 0; i < MGR_NumChildren(rc); i++)
    {
        tgl = MGR_Children(rc)[i];
        if (RC_RadioBehavior(rc))
        {
            if (XmIsToggleButton(tgl) && XmToggleButtonGetState(tgl))
            {
		XdbDebug(__FILE__, w, "is toggle and set\n");
               if (w != tgl && cbs && cbs->set) {
                   XmToggleButtonSetState(tgl, False, True);
		   XdbDebug(__FILE__, w, "clearing toggle %d\n", i);
            }
            else if (w == tgl && cbs && cbs->set)
                XmToggleButtonSetState(tgl, True, False);
            }
            if (XmIsToggleButtonGadget(tgl) && XmToggleButtonGadgetGetState(w))
            { 
                if (w != tgl && cbs && cbs->set)
                    XmToggleButtonGadgetSetState(tgl, False, True);
            }
        }
    } 
}

static void
insert_child(Widget w)
{
    Widget rc = (Widget)XtParent(w);
    Arg args[1];

    XdbDebug(__FILE__, rc, "insert_child: num_children: %d\n",
		MGR_NumChildren(rc));

/*
  This may be correct, but it keeps me from adding CascadeButtonGadgets
  to a menu bar...   Chris

    if (rc->row_column.is_homogeneous
        && (rc->row_column.entry_class != XtClass(w))) 
    {
       _XmWarning(w, "Child of homogeneous rowcolumn is of wrong class!");
       return;
    }
    else 
    {
*/
    if (RC_RadioBehavior(rc) &&
	((XtClass(w) == xmToggleButtonWidgetClass)
	 || (XtClass(w) == xmToggleButtonGadgetClass)))
	XtAddCallback(w, XmNvalueChangedCallback, toggle_callback, rc);
/*
    }
*/

#define superclass (&xmManagerClassRec)    
    (*superclass->composite_class.insert_child)(w);
#undef superclass

    /*
     * if it's a label subclass, set its alignment to our
     * RC_EntryAlignment resource
     */
    XtSetArg(args[0], XmNalignment, RC_EntryAlignment(rc));
    if (XtIsSubclass(w, xmLabelWidgetClass) ||
	XtIsSubclass(w, xmLabelGadgetClass))
	XtSetValues(w, args, 1);

    if (RC_constraint_IndexPosition(w) == XmLAST_POSITION) {
	RC_constraint_IndexPosition(w) = MGR_NumChildren(rc)-1;

	XdbDebug2(__FILE__, rc, w,
		  "InsertChild(XmLAST_POSITION) => position %d\n",
		RC_constraint_IndexPosition(w));
    }
    else {
	int i;
	
	if (MGR_NumChildren(rc)) {
	    for (i=MGR_NumChildren(rc)-1; i>RC_constraint_IndexPosition(w); i--)
	    {
                Widget tmp;
            
                tmp = getChildByPosition(rc, i); 
                if (tmp == NULL)
                    _XmError(rc, "getChildByPosition returned NULL.");

		RC_constraint_IndexPosition(tmp)++;
	    }
	}
	XdbDebug2(__FILE__, rc, w, "InsertChild() => position %d\n",
		RC_constraint_IndexPosition(w));
    }

    /* This broke something when it was done at the beginning of this func */
    XtFree((XtPointer)RC_Boxes(rc));
    initialize_boxes(rc);
}

static Widget 
getChildByPosition(Widget rc, int position)
{
    int i;

    for (i=0; i<MGR_NumChildren(rc); i++) {
	int	p = RC_constraint_IndexPosition(MGR_Children(rc)[i]);
	if (p == position)
	    return MGR_Children(rc)[i];
    }

    /*
     * Print lots of info here because this case will likely
     * crash applications
     */
    if (XdbInDebug(__FILE__, rc)) {
	XdbDebug(__FILE__, rc, "GetChildByPosition(%d) : no match\n", position);
	for (i=0; i<MGR_NumChildren(rc); i++) {
	    XdbDebug2(__FILE__, rc, MGR_Children(rc)[i], "Position is %d\n",
		RC_constraint_IndexPosition(MGR_Children(rc)[i]));
	}
    }

    return NULL;
}


/*
 * If a child is deleted, the positions of the remaining children
 * need to be checked.
 */
static void
DeleteChild(Widget w)
{
	int	i;
	Widget	rc = XtParent(w);

	for (i=0; i<MGR_NumChildren(rc); i++)
	    if (RC_constraint_IndexPosition(MGR_Children(rc)[i]) > RC_constraint_IndexPosition(w))
		RC_constraint_IndexPosition(MGR_Children(rc)[i])--;

#define superclass (&xmManagerClassRec)    
    (*superclass->composite_class.delete_child)(w);
#undef superclass
}

/* Determine if widget w is a top level menu pane/bar, and that the given event
   (assumed to be a button event !) occured outside widget w's child widgets */
static Boolean
ExternalBtnEvent(Widget w,
		 XEvent *event)
{
    Widget event_widget;
    Boolean is_child = False;

    /* Determine the top-level widget for 'w' */
    Widget w_top_level = RC_LastSelectToplevel(w);

    XdbDebug(__FILE__, w, "    Determining if the button event was external to the menu system\n");
    
    /* Determine if w is a top level menu pane/bar */
    if ((w_top_level == w) || !w_top_level)
    {
	/* Determine the event window */
	Window event_window = (event->xbutton.subwindow) ?
	    event->xbutton.subwindow : event->xbutton.window;
	
	/* Convert window to a widget ID */
	event_widget = XtWindowToWidget(XtDisplay(w), event_window);
	
	/* Now determine if the event widget is a child (direct of indirect)
	   of widget w. */
	if (event_widget && (event_widget != w))
        {
	    Widget parent = XtParent(event_widget);
	    
	    /* Search event widgets parents, to see if 'w' is an ancestor */
	    while (parent && (parent != w)) parent = XtParent(parent);
	    
	    is_child = (parent == w);
	} /* if event widget is not 'w' */
    } /* If event widget is a top level menu pane/bar */
    
    return (!is_child);
}

/* action routines */

static void
MenuBtnDown(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    Widget gadget;
    XdbDebug(__FILE__, w, "MenuBtnDown()\n");

    /* If event was in a child gadget, then arm it, otherwise determine
       whether the event occured outside the menu system, and do a cleanup
       if it did. */
    gadget = (Widget)_XmInputInGadget(w,
				      event->xkey.x,
				      event->xkey.y);

    if (gadget) 
    {
	/* Event was in a gadget */

	MGR_HighlightedWidget(w) = gadget;
	
	/* turn on mouse traversal */
	_XmSetInDragMode(w, True);
	
	/* Now we arm the widget */
	_XmGadgetArm(w, event, params, num_params);
    }
    else if (ExternalBtnEvent(w, event))
    {
	/* Event was external to the menu system; Do a cleanup, and replay
	   the event to the outside world. */
	DoBtnEventCleanupReplay(w, event, params, *num_params);
    }
}

static void
DoBtnEventCleanupReplay(Widget w,
			XEvent *event,
			String *params,
			Cardinal num_params)
{
    if (RC_PopupPosted(w))
    {
	Widget menu_shell = RC_PopupPosted(w);

	if (menu_shell)
        {
	    XtCallActionProc(menu_shell, "MenuShellPopdownDone",
			     event, params, num_params);
	}

	/* Replay the event */
	XAllowEvents(XtDisplay(w), ReplayPointer, CurrentTime);

	/* Resume normal pointer processing */
	XtUngrabPointer(w, CurrentTime);
	
	/* Resume normal keyboard processing */
	XUngrabKeyboard(XtDisplay(w), CurrentTime);
    }
}

static void
MenuBtnUp(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *num_params)
{
    Widget gadget;

    XdbDebug(__FILE__, w, "MenuBtnUp()\n");

    /* If event was in a child gadget, then arm it, otherwise determine
       whether the event occured outside the menu system, and do a cleanup
       if it did. */

    gadget = (Widget)_XmInputInGadget(w,
				      event->xkey.x,
				      event->xkey.y);

    if (gadget) 
    {
	/* Now we activate the gadget */
	_XmGadgetActivate(w, event, params, num_params);
    }
    else if (ExternalBtnEvent(w, event))
    {
	/* Event was external to the menu system; Do a cleanup, and replay
	   the event to the outside world. */
	DoBtnEventCleanupReplay(w, event, params, *num_params);
    }
}

static void
MenuHelp(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XtCallCallbacks(w,
		    XmNhelpCallback,
		    NULL);
}

static void 
MenuEnter(Widget w, 
          XEvent *event, 
          String *params, 
          Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuEnter()\n");
}

static void 
MenuUnmap(Widget w, 
          XEvent *event, 
          String *params, 
          Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuUnmap()\n");
}

static void 
MenuFocusIn(Widget w, 
	    XEvent *event, 
	    String *params, 
	    Cardinal *num_params)
{
    Window window_return;
    int revert_to_return;

#if 0
    XGetInputFocus(XtDisplay(w),
		   &window_return,
		   &revert_to_return);

    /* keep track of the widget that had the focus before hand */

    XSetInputFocus(XtDisplay(w),
		   XtWindow(w),
		   RevertToParent,
		   CurrentTime);
#endif
}

static void 
MenuFocusOut(Widget w, 
	     XEvent *event, 
	     String *params, 
	     Cardinal *num_params)
{
    /* restore the focus to the widget that had it before moving to the menu bar */
}

static void
ManagerGadgetSelect(Widget w,
		    XEvent *event,
		    String *params,
		    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "ManagerGadgetSelect()\n");
}

static void
MenuGadgetEscape(Widget w,
		 XEvent *event,
		 String *params,
		 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuGadgetEscape()\n");
}

static void 
MenuBarEnter(Widget w, 
	     XEvent *event, 
	     String *params, 
	     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuBarEnter()\n");
}

static void 
MenuBarLeave(Widget w, 
	     XEvent *event, 
	     String *params, 
	     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuBarLeave()\n");
}

static void 
MenuBarGadgetSelect(Widget w, 
		    XEvent *event, 
		    String *params, 
		    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MenuBarGadgetSelect()\n");
}

/* convenience functions */

Widget 
XmCreateMenuBar(Widget parent, 
		char *name, 
		Arg *arglist, 
		Cardinal argcount)
{
    /* menu bar's have the their rowColumnType set to XmMENU_BAR and
       are homogeneous (they only accept CascadeButtons, and CascadeButtonGadgets */

    Widget w;
    Arg myArgList[4];
    int n=0;

    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_BAR); n++;
    XtSetArg(myArgList[n], XmNorientation, XmHORIZONTAL); n++;
    XtSetArg(myArgList[n], XmNisHomogeneous, True); n++;
    XtSetArg(myArgList[n], XmNentryClass, xmCascadeButtonWidgetClass); n++;

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    w = XtCreateWidget(name, 
		       xmRowColumnWidgetClass,
		       parent,
		       combined, n+argcount);

    XtFree((char*)combined);

    return w;
}


Widget 
XmCreateOptionMenu(Widget parent, 
		   char *name, 
		   Arg *arglist, 
		   Cardinal argcount)
{
    /* option menus have the their rowColumnType set to XmMENU_OPTION */

    Widget w;
    Arg myArgList[1];
    int n=0;

    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_OPTION); n++;

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    w = XtCreateWidget(name, 
		       xmRowColumnWidgetClass,
		       parent,
		       combined, n+argcount);

    XtFree((char*)combined);

    return w;
}


Widget 
XmCreatePopupMenu(Widget parent, 
		  char *name, 
		  Arg *arglist, 
		  Cardinal argcount)
{
    /* popup menus have the their rowColumnType set to XmMENU_POPUP */

    Widget w;
    Arg myArgList[1];
    int n=0;

    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_POPUP); n++;

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    w = XtCreateWidget(name, 
		       xmRowColumnWidgetClass,
		       parent,
		       combined, n+argcount);

    XtFree((char*)combined);

    return w;
}

Widget 
XmCreatePulldownMenu(Widget parent, 
		     char *name, 
		     Arg *arglist, 
		     Cardinal argcount)
{
    /* pulldown menus have their rowColumnType set to XmMENU_PULLDOWN */

    Widget w, ms;
    Arg myArgList[5];
    int n=0;
    char *popup_name = XtMalloc(strlen("popup_") + strlen(name) + 1); 
    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    strcpy(popup_name, "popup_");
    strcat(popup_name, name);

    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_PULLDOWN); n++;
    XtSetArg(myArgList[n], XmNorientation, XmVERTICAL); n++; 
    XtSetArg(myArgList[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(myArgList[n], XmNnumColumns, 1); n++;

/*
    if (XmIsRowColumn(parent) && (RC_Type(parent) == XmMENU_PULLDOWN))
	parent = XtParent(parent);
	*/

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    ms = XtCreatePopupShell(popup_name,
			    xmMenuShellWidgetClass,
			    parent, NULL, 0);

    w = XtCreateManagedWidget(name, 
			      xmRowColumnWidgetClass,
			      ms,
			      combined, n+argcount);

    XtFree((char*)combined);

    return w;
}


Widget 
XmCreateRadioBox(Widget parent, 
		 char *name, 
		 Arg *arglist, 
		 Cardinal argcount)
{
    /* radio boxes have their rowColumnType set to XmWORK_AREA, and their radioBehavior
       set to true.  The also are homogeneous and accept ToggleButtons, and ToggleButtonGadgets */

    Widget w;
    Arg myArgList[2];
    int n=0;

    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    XtSetArg(myArgList[n], XmNrowColumnType, XmWORK_AREA); n++;
    XtSetArg(myArgList[n], XmNradioBehavior, True); n++;

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    w = XtCreateWidget(name, 
		       xmRowColumnWidgetClass,
		       parent,
		       combined, n+argcount);

    XtFree((char*)combined);

    return w;
}

Widget 
XmCreateRowColumn(Widget parent, 
		  char *name, 
		  Arg *arglist, 
		  Cardinal argcount)
{
    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    return XtCreateWidget(name,
			  xmRowColumnWidgetClass,
			  parent,
			  arglist,
			  argcount);
}

Widget
XmCreateWorkArea(Widget parent,
		 char *name,
		 Arg *arglist,
		 Cardinal argcount)
{
    Widget w;
    Arg myArgList[2];
    int n=0;

    ArgList combined;

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    XtSetArg(myArgList[n], XmNrowColumnType, XmWORK_AREA); n++;

    combined = XtMergeArgLists(myArgList, n, arglist, argcount);

    w = XtCreateWidget(name, 
		       xmRowColumnWidgetClass,
		       parent,
		       combined, n+argcount);

    XtFree((char*)combined);

    return w;
}

Widget
XmOptionButtonGadget(Widget option_menu)
{
    return XtNameToWidget(option_menu, RC_OPTION_CBG);
}

Widget
XmOptionLabelGadget(Widget option_menu)
{
    return XtNameToWidget(option_menu, RC_OPTION_LABEL);
}

void
XmMenuPosition(Widget menu, 
	       XButtonPressedEvent *event)
{
    /* should be all that's needed */
    XtMoveWidget(XtParent(menu),
		 event->x_root,
		 event->y_root);
}

Widget
XmGetTearOffControl(Widget menu)
{
    if (XmIsRowColumn(menu))
        return RC_TearOffControl(menu);
    return NULL;
}

#ifdef	notdef
/*
 * This function deals with children of a menu that want to add
 * accelerators and mnemonics.
 *
 * Parameters :
 *	b is the button child
 *	tr is the string describing the translation
 *	mode is 1 for add, ... (FIX ME)
 */
void
_XmRCProcessMenuButtonTranslations(Widget rc, Widget b, String tr, int mode)
{
    int			i;

    if (tr == NULL || strlen(tr) == 0)
		return;
    if (! XmIsRowColumn(rc))
		return;

    XdbDebug2(__FILE__, rc, b, "_XmRCProcessMenuButtonTranslations(%s)\n", tr);

    if (RC_Type(rc) == XmMENU_PULLDOWN || RC_Type(rc) == XmMENU_OPTION
		|| RC_Type(rc) == XmMENU_BAR) {
	/* Make sure there are items in the list */
	if (MGR_NumKeyboardEntries(rc) == 0
		|| (MGR_NumKeyboardEntries(rc) == MGR_SizeKeyboardList(rc))) {
		MGR_SizeKeyboardList(rc)++;

		MGR_KeyboardList(rc) = (XmKeyboardData *)XtRealloc((XtPointer)MGR_KeyboardList(rc),
			sizeof(XmKeyboardData) * MGR_SizeKeyboardList(rc));
		i = MGR_SizeKeyboardList(rc) - 1;
		MGR_KeyboardList(rc)[i].component = NULL;
	} else {
		for (i=0; i<MGR_SizeKeyboardList(rc); i++)
			if (MGR_KeyboardList(rc)[i].component == NULL)
				break;
	}
	if (MGR_KeyboardList(rc)[i].component != NULL) {
		_XmError(b, "_XmRCProcessMenuButtonTranslations: This should not happen\n");
	}

/* Put the data in the entry */
	MGR_KeyboardList(rc)[i].component = b;
	MGR_KeyboardList(rc)[i].eventType = KeyPress;
	MGR_KeyboardList(rc)[i].accelerator = tr;
#if 0
/* Not implemented yet ... FIX ME !!! */
	MGR_KeyboardList(rc)[i].keysym = b;
	MGR_KeyboardList(rc)[i].key = b;
	MGR_KeyboardList(rc)[i].modifiers = b;
	MGR_KeyboardList(rc)[i].needGrab = b;
	MGR_KeyboardList(rc)[i].isMnemonic = b;
#endif
    }

	/*
	 * Signal the parent hierarchy if we're realized and if we're not a
	 * menu bar
	 */
	if (XtIsRealized(rc) && (RC_Type(rc) == XmMENU_PULLDOWN || RC_Type(rc) == XmMENU_OPTION)) {
		Widget	p;
		for (p = XtParent(rc); XtParent(p) && ! XtIsSubclass(p, xmRowColumnWidgetClass);)
				p = XtParent(p);
		_XmRCProcessMenuButtonTranslations(p, b, tr, mode);
	}
/* Menu Bar : add to parent */
}
#endif

void
XmAddToPostFromList(Widget menu_wid, Widget widget)
{
}

void
XmRemoveFromPostFromList(Widget menu_wid, Widget widget)
{
}

Widget
XmGetPostedFromWidget(Widget menu)
{
    if (XmIsRowColumn(menu))
	return RC_LastSelectToplevel(menu);
    return NULL;
}

/*
 * most of these are already written under different names
 */
void
_XmPostPopupMenu(Widget wid, XEvent *event)
{
}

void
_XmSetPopupMenuClick(Widget wid, Boolean popupMenuClick)
{
}

Boolean
_XmGetPopupMenuClick(Widget wid)
{
    return False;
}

void
_XmAllowAcceleratedInsensitiveUnmanagedMenuItems(Widget wid,
						 Boolean allowed)
{
}

void
_XmSetSwallowEventHandler(Widget widget, Boolean add_handler)
{
}

void
_XmMenuFocus(Widget w, int operation, Time _time)
{
}

void
_XmGetActiveTopLevelMenu(Widget wid, Widget *rwid)
{
}

Boolean
_XmMatchBSelectEvent(Widget wid, XEvent *event)
{
    return False;
}

Boolean
_XmMatchBDragEvent(Widget wid, XEvent *event)
{
    return False;
}

void
_XmHandleMenuButtonPress(Widget wid, XEvent *event)
{
}

void
_XmMenuBtnDown(Widget wid, XEvent *event,
	       String *params, Cardinal *num_params)
{
}

void
_XmMenuBtnUp(Widget wid, XEvent *event,
	     String *params, Cardinal *num_params)
{
}

void
_XmCallRowColumnMapCallback(Widget wid, XEvent *event)
{
}

void
_XmCallRowColumnUnmapCallback(Widget wid, XEvent *event)
{
}

void
_XmMenuPopDown(Widget w, XEvent *event, Boolean *popped_up)
{
}

Boolean
_XmIsActiveTearOff(Widget w)
{
    return False;
}

void
_XmMenuHelp(Widget wid, XEvent *event, String *params, Cardinal *num_params)
{
}
