/* pam_dispatch.c - handles module function dispatch */

/*
 * $Id: pam_dispatch.c,v 1.4 1996/07/07 23:55:29 morgan Exp $
 *
 * last modified by AGM:1996/3/4
 */

#include <stdlib.h>
#include <stdio.h>

#include "pam_private.h"

static int _pam_dispatch_aux(pam_handle_t *pamh,
			     int flags, struct handler *h);

int _pam_dispatch(pam_handle_t *pamh, int flags, int choice)
{
    struct handler *h = NULL;
    int res;

    IF_NO_PAMH("_pam_dispatch",pamh,PAM_SYSTEM_ERR);

    /* Load all modules, resolve all symbols */

    if ((res = _pam_init_handlers(pamh)) != PAM_SUCCESS) {
	_pam_log_error("unable to dispatch function");
	return res;
    }

    switch (choice) {
    case PAM_AUTHENTICATE:  h = pamh->handlers.conf.authenticate; break;
    case PAM_SETCRED:       h = pamh->handlers.conf.setcred; break;
    case PAM_ACCOUNT:       h = pamh->handlers.conf.acct_mgmt; break;
    case PAM_OPEN_SESSION:  h = pamh->handlers.conf.open_session; break;
    case PAM_CLOSE_SESSION: h = pamh->handlers.conf.close_session; break;
    case PAM_CHAUTHTOK:     h = pamh->handlers.conf.chauthtok; break;
    default:
	_pam_log_error("undefined fn choice; %d",choice);
	return PAM_ABORT;
    }

    if (h == NULL) {     /* there was no handlers.conf... entry; will use
			  * handlers.other... */
	switch (choice) {
	case PAM_AUTHENTICATE:  h = pamh->handlers.other.authenticate; break;
	case PAM_SETCRED:       h = pamh->handlers.other.setcred; break;
	case PAM_ACCOUNT:       h = pamh->handlers.other.acct_mgmt; break;
	case PAM_OPEN_SESSION:  h = pamh->handlers.other.open_session; break;
	case PAM_CLOSE_SESSION: h = pamh->handlers.other.close_session; break;
	case PAM_CHAUTHTOK:     h = pamh->handlers.other.chauthtok; break;
	}
    }

    /* call the list of module functions */
    
    return _pam_dispatch_aux(pamh, flags, h);
}

static int _pam_dispatch_aux(
    pam_handle_t *pamh,
    int flags,
    struct handler *h
    )
{
    int ret;
    int result = PAM_SUCCESS;
    int tried_one = 0;

    IF_NO_PAMH("_pam_dispatch_aux",pamh,PAM_SYSTEM_ERR);
    
    while (h) {

	ret = h->func(pamh, flags, h->argc, h->argv);

	if (ret == PAM_SUCCESS) {

	    tried_one = 1;        /* ensure something has passed! */

	    if (h->control_flag == PAM_SUFFICIENT && result == PAM_SUCCESS) {
		break;  /* treat as SUFFICIENT only if we've not failed a
			   a previous "PAM_REQUIRED" module */
	    }

	} else if (ret != PAM_IGNORE) {

	    tried_one = 1;

#ifdef PAM_FAIL_NOW_ON
	    if (ret == PAM_FAIL_NOW) {
	        /*
		 * This is the result of an exceptional condition.  The
		 * module wants to stop talking to the user immediately.
		 */
	        result = PAM_PERM_DENIED;
		break;
	    }
#endif /* PAM_FAIL_NOW_ON */

	    if (h->control_flag == PAM_REQUIRED && result == PAM_SUCCESS) {
		result = ret;   /* this takes the value of the first fail
				   on a PAM_REQUIRED module */
	    }

	} /* PAM_IGNORE = this module doesn't want to be called... */

	h = h->next;
    }

    if (tried_one)
	return result;

/* this is if there are only PAM_OPTIONAL entries (or none at all)
   and they all fail! Is there a better error to return than this?  */

    return PAM_PERM_DENIED;
}
