/*
 * tclMacPort.h --
 *
 *	This header file handles porting issues that occur because of
 *	differences between the Mac and Unix. It should be the only
 *	file that contains #ifdefs to handle different flavors of OS.
 *
 * Copyright (c) 1995-1996 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tclMacPort.h 1.61 96/07/25 13:29:02
 */

#ifndef _MACPORT
#define _MACPORT

#ifndef _TCL
#include "tcl.h"
#endif

#include "tclErrno.h"

/* Includes */
#ifdef THINK_C
	/*
	 * The Symantic C code has not been tested
	 * and probably will not work.
	 */
#   include <pascal.h>
#   include <posix.h>
#   include <string.h>
#   include <fcntl.h>
#   include <pwd.h>
#   include <sys/param.h>
#   include <sys/types.h>
#   include <sys/stat.h>
#   include <unistd.h>
#elif defined(__MWERKS__)
#   include <time.h>
#   include <unistd.h>
#   include <fcntl.h>

/*
 * MetroWerks stat.h file is rather weak.  The defines
 * after the include are needed to fill in the missing
 * defines.
 */
#   include <stat.h>
#   ifndef S_IFIFO
#	define   S_IFIFO	0x0100
#   endif
#   ifndef S_IFBLK
#	define   S_IFBLK	0x0600
#   endif
#   ifndef S_ISLNK
#	define   S_ISLNK(m)	(((m)&(S_IFMT)) == (S_IFLNK))
#   endif
#   ifndef S_ISSOCK
#	define   S_ISSOCK(m)	(((m)&(S_IFMT)) == (S_IFSOCK))
#   endif

#   define isatty(arg) 1

/* 
 * Defines used by access function.  This function is provided
 * by Mac Tcl as the function TclMacAccess.
 */
 
#   define	F_OK		0	/* test for existence of file */
#   define	X_OK		0x01	/* test for execute or search permission */
#   define	W_OK		0x02	/* test for write permission */
#   define	R_OK		0x04	/* test for read permission */

#endif

/*
 * waitpid doesn't work on a Mac - the following makes
 * Tcl compile without errors.  These would normally
 * be defined in sys/wait.h on UNIX systems.
 */
#ifdef NO_SYS_WAIT_H
#   define WNOHANG 1
#   define WIFSTOPPED(stat) (1)
#   define WIFSIGNALED(stat) (1)
#   define WIFEXITED(stat) (1)
#   define WIFSTOPSIG(stat) (1)
#   define WIFTERMSIG(stat) (1)
#   define WIFEXITSTATUS(stat) (1)
#   define WEXITSTATUS(stat) (1)
#   define WTERMSIG(status) (1)
#   define WSTOPSIG(status) (1)
#endif

/*
 * These defines are for functions that are now obsolete.  The only
 * Tcl code that still uses then is not called by the Mac.  The interfaces
 * should go away soon.
 */
#define TclOpenFile(fname, mode) ((Tcl_File)NULL)
#define TclCloseFile(file) (-1)
#define TclReadFile(file, shouldBlock, buf, toRead) (toRead)
#define TclWriteFile(file, shouldBlock, buf, toWrite) (-1)
#define TclSeekFile(file, offset, whence) (-1)

/*
 * Define "NBBY" (number of bits per byte) if it's not already defined.
 */

#ifndef NBBY
#   define NBBY 8
#endif

/*
 * These functions always return dummy values on Mac.
 */
#ifndef geteuid
#   define geteuid() 1
#endif
#ifndef getpid
#   define getpid() -1
#endif

#define NO_SYS_ERRLIST
#define WAIT_STATUS_TYPE int

/*
 * Make sure that MAXPATHLEN is defined.
 */

#ifndef MAXPATHLEN
#   ifdef PATH_MAX
#       define MAXPATHLEN PATH_MAX
#   else
#       define MAXPATHLEN 2048
#   endif
#endif

/*
 * The following functions are declared in tclInt.h but don't do anything
 * on Macintosh systems.
 */

#define TclSetSystemEnv(a,b)

/*
 * Many signals are not supported on the Mac and are thus not defined in
 * <signal.h>.  They are defined here so that Tcl will compile with less
 * modification.
  */

#ifndef SIGQUIT
#define SIGQUIT 300
#endif

#ifndef SIGPIPE
#define SIGPIPE 13
#endif

#ifndef SIGHUP
#define SIGHUP  100
#endif

extern char **environ;

/*
 * Prototypes needed for compatability
 */

EXTERN int 	TclMacCreateEnv _ANSI_ARGS_((void));
EXTERN FILE *	fdopen(int fd, const char *mode);
EXTERN int	fileno(FILE *stream);
EXTERN struct in_addr inet_addr(char *address);
EXTERN char *	inet_ntoa(struct in_addr inaddr);

#if (defined(THINK_C) || defined(__MWERKS__))
double		hypot(double x, double y);
#endif

/*
 * The following declarations belong in tclInt.h, but depend on platform
 * specific types (e.g. struct tm).
 */

EXTERN struct tm *	TclpGetDate _ANSI_ARGS_((const time_t *tp,
			    int useGMT));
EXTERN size_t		TclStrftime _ANSI_ARGS_((char *s, size_t maxsize,
			    const char *format, const struct tm *t));
#define TclStrftime(s,m,f,t) (strftime((s),(m),(f),(t)))

/*
 * The following prototypes and defines replace the Macintosh version
 * of the POSIX functions "stat" and "access".  The various compilier 
 * vendors don't implement this function well nor consistantly.
 */
EXTERN int TclMacStat _ANSI_ARGS_((char *path, struct stat *buf));
#define stat(path, bufPtr) TclMacStat(path, bufPtr)
#define lstat(path, bufPtr) TclMacStat(path, bufPtr)
EXTERN int TclMacAccess _ANSI_ARGS_((const char *filename, int mode));
#define access(path, mode) TclMacAccess(path, mode)
EXTERN FILE * TclMacFOpenHack _ANSI_ARGS_((const char *path,
	const char *mode));
#define fopen(path, mode) TclMacFOpenHack(path, mode)
EXTERN int TclMacReadlink _ANSI_ARGS_((char *path, char *buf, int size));
#define readlink(fileName, buffer, size) TclMacReadlink(fileName, buffer, size)

/*
 * Defines for Tcl internal commands that aren't really needed on
 * the Macintosh.  They all act as no-ops.
 */
#define TclCreateCommandChannel(out, in, err, num, pidPtr)	NULL
#define TclClosePipeFile(x)

/*
 * These definitions force putenv & company to use the version
 * supplied with Tcl.
 */
#ifndef putenv
#   define unsetenv	TclUnsetEnv
#   define putenv	Tcl_PutEnv
#   define setenv	TclSetEnv
void	TclSetEnv(CONST char *name, CONST char *value);
int	Tcl_PutEnv(CONST char *string);
void	TclUnsetEnv(CONST char *name);
#endif

/*
 * The default platform eol translation on Mac is TCL_TRANSLATE_CR:
 */

#define	TCL_PLATFORM_TRANSLATION	TCL_TRANSLATE_CR

#endif /* _MACPORT */
