/* d_res.cc
 *$Header: /al/acs/src/RCS/d_res.cc,v 9.21 95/10/21 18:09:22 al Exp $
 * functions for resistor.
 * x = amps, y.f0 = volts, ev = y.f1 = ohms
 */
#include "error.h"
#include "u_opt.h"
#include "d_res.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_RESISTANCE::expand();
// 	int	DEV_RESISTANCE::dotr();
// 	void	DEV_RESISTANCE::doac();
/*--------------------------------------------------------------------------*/
void DEV_RESISTANCE::expand()
{
  if (val == 0.){
    error(bPICKY, "%s: short circuit\n", printlabel());
    y0.f1 = OPT::shortckt;
  }else{
    y0.f1 = val;
  }
  y0.f0 = LINEAR;
  m0.f1 = 1./y0.f1;
  m0.c0 = 0.;
  ev    = val;
  acg   = m0.f1;
  assert(loss == 0.);
}
/*--------------------------------------------------------------------------*/
int DEV_RESISTANCE::dotr()
{
  if (trfun){
    trsetup();
    m0.x = volts_limited(n[OUT1],n[OUT2]);
    y0.x = m0.c0 + m0.f1 * m0.x;
    (*trfun)(this);
    if (y0.f1 == 0.){
      error(bPICKY, "%s: short circuit\n", printlabel());
      y0.f1 = OPT::shortckt;
    }
    m0.f1 = 1./y0.f1;
    m0.c0 = y0.x - y0.f0 / y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    m0.x = n[OUT1].v0() - n[OUT2].v0();
    y0.x = m0.c0 + m0.f1 * m0.x;
    y0.f0 = y0.x * y0.f1;
    assert(conchk(m0.f1, 1./y0.f1, OPT::abstol));
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }else{
    assert(conchk(m0.f1, 1./y0.f1, OPT::abstol));
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_RESISTANCE::doac()
{
  if (acfun){
    double dcvolts = n[OUT1].vdc() - n[OUT2].vdc();
    acbias = m0.c0 + m0.f1*dcvolts;
    ev = (*acfun)(this);
    if (ev == 0.){
      error(bPICKY, "%s: short circuit\n", printlabel());
      ev = OPT::shortckt;
    }
    acg = 1. / ev;
  }else if (trfun){
    ev  = y0.f1;
    acg = 1. / y0.f1;
  }else{
    //assert(acg == 1./y0.f1);
  }
  acload_passive();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
