/* d_trnlin.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/d_trln.h,v 9.21 95/10/21 18:10:46 al Exp $
 * structures, etc. for transmission lines
 */
#ifndef D_TRNLIN_H
#define D_TRNLIN_H
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
enum {NUM_INIT_COND = 4};
/*--------------------------------------------------------------------------*/
class TRANSLINE_COMMON : private COMPONENT_COMMON {
friend class DEV_TRANSLINE;
  TRANSLINE_COMMON();
  TRANSLINE_COMMON(const TRANSLINE_COMMON& p):COMPONENT_COMMON(p){*this = p;}
  double	z0;		/* characteristic impedance */
  double	td;		/* delay time (not used, yet) */
  double	f;		/* specification frequency */
  double	nl;		/* length (wavelengths) at f */
  double	ic[NUM_INIT_COND];/* initial conditions: v1, i1, v2, i2	*/
  double	reson;		/* quarter wave frequency */
  int		icset;		/* flag: initial condition set */
};
/*--------------------------------------------------------------------------*/
class DEV_TRANSLINE : public ELEMENT {
public:
	DEV_TRANSLINE();
	DEV_TRANSLINE(const DEV_TRANSLINE& p):ELEMENT(p){}
	CARD*	clone()const{return new DEV_TRANSLINE(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
	int	dotr();
	void	doac();
private:
static	void	setinitcond(CS&);
  enum	{NUMNODES = 4};
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
