
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>

#define LL (8)

unsigned char buf[LL+1];

void quit(char *str)
{
  perror(str);
  exit(1);
}

int writebuf(int count)
{
  int i;
  
  if(printf("\t") != 1)
    return(1);
  for(i=0; i<count-1; i++)
    if(printf("0x%02x, ", buf[i]) != 6)
      return(1);
  if(i<count)
    if(printf("0x%02x", buf[i]) != 4)
      return(1);
  return(0);
}

int main(int argc, char *argv[])
{
  int stat;
  int end=0;

  if(argc!=2) {
    fprintf(stderr, "%s: Usage '%s variable_name'\n",
	    argv[0],
	    argv[0]);
    exit(1);
  }
  if(printf("\nunsigned char %s[] = {\n", argv[1]) != (22 + strlen(argv[1])))
    quit(argv[0]);
  stat=fread(buf+LL, 1, 1, stdin);
  if(stat!=1) {
    if(ferror(stdin))
      quit(argv[0]);
    end=1;
  }
  while(!end) {
    *buf=*(buf+LL);
    stat=fread(buf+1, 1, LL, stdin);
    if(stat!=LL) {
      if(ferror(stdin))
	quit(argv[0]);
      end=1;
      if(writebuf(stat+1))
	quit(argv[0]);
    }
    else {
      if(writebuf(LL))
	quit(argv[0]);
      if(printf(",\n") != 2)
	quit(argv[0]);
    }
  }  
  if(printf(" };\n") != 4)
    quit(argv[0]);

  return(0);
}
