/*
 * Programm XBLAST V1.2.13 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 22nd 1996
 * started August 1993
 *
 * File: include.h
 * constants and macros for all files.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 /* base dimensions */
#define BASE_X 8
#define BASE_Y 6

  /* constants */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define MAX_PLAYER 4
#define LEVEL_MAX 53

#define STEP_HORI BASE_X
#define STEP_VERT BASE_Y

#define DEFAULT_DELAY 5

#define BLOCK_WIDTH  (8*BASE_X) 
#define BLOCK_HEIGHT (8*BASE_Y)

#define MAZE_W 15
#define MAZE_H 13

#define ILL_X (4*BASE_X)
#define ILL_Y (5*BASE_Y)

#define CHARW 3
#define CHARH 5


#define MAX_BLOCK 11

#define Healthy        0
#define IllBomb        1
#define IllSlow        2
#define IllRun         3
#define IllMini        4
#define IllEmpty       5
#define IllInvisible   6
#define IllMalfunction 7
#define IllReverse     8
#define IllTeleport    9

#define MAX_ILL        9


#define ILLTIME 256
#define BOMB_PROB 32

#define MAX_JUNKIE_TIME (384 + (rand() & 31))

#define MAX_EXTRA   2

  /* Blocktypen */


#define BTFree      0
#define BTShadow    1
#define BTBlock     2
#define BTBlockRise 3
#define BTExtra     4
#define BTExtraOpen 5
#define BTBomb      6
#define BTRange     7
#define BTSick      8
#define BTSpecial   9
#define BTVoid      10
#define BTEvil      11 /* No Real Block, */

  /* SpriteTypen */

#define STPlayer 0
#define STBomb   1

  /* Walk-Directions */

#define GoStop (-1)
#define GoUp    0
#define GoLeft  1
#define GoDown  2
#define GoRight 3
#define GoDefault 4

  /* Makros */



#define MAX(a,b) ( (a)>=(b) ? (a) : (b) )
#define MIN(a,b) ( (a)<=(b) ? (a) : (b) )
#define ABS(a)   ( (a)>=0 ? (a) : (-(a)) )

/*
 * end file include.j
 */












