/*
 * XLife Copyright 1989 Jon Bennett jb7m+@andrew.cmu.edu, jcrb@cs.cmu.edu
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include "defs.h"
#include "data.h"
#include <stdio.h>
#include <pwd.h>
#include <ctype.h>

char *gethome()
{
    return(getpwuid(getuid())->pw_dir);
}


char *checktilda(stng)
char *stng;
{
    static char full[1024];
    struct passwd *pw;
    int i;
    if (stng[0]=='~') {
	i=1;
	while(stng[i]!='/' && stng[i]!='\0')
	    full[i-1]=stng[i], i++;
	if (i==1) 
	    strcpy(full,gethome());
	else {
	    full[i-1]='\0';
	    if((pw = getpwnam(full)) == NULL){
		XClearWindow(disp,inputw);
		XDrawString(disp,inputw,ntextgc,ICOORDS(0,0),SYSERR,strlen(SYSERR));
	    }
	    else{
		strcpy(full,pw->pw_dir);
	    }
	}
	strcat(full,stng+i);
    } else
	strcpy(full,stng);
    return(full);
}

char *addlifeext(buf)
char *buf;
{
    int len=strlen(buf);
    if(strcmp(buf+len-5,".life")){
	return(".life");
    }
    return("");
}

void savefile(){

    FILE *savefl;
    char outbuf[100];
    
    strcpy(inpbuf,"Save to:");
    minbuflen=8;
    strcat(inpbuf, "./");
    XClearWindow(disp,inputw);
    XDrawString(disp, inputw, ntextgc,ICOORDS(0,0),inpbuf, strlen(inpbuf));

    getxstring();

    strcpy(outbuf,checktilda(inpbuf+8));
    inpbuf[0]=0;
    strcat(outbuf,addlifeext(outbuf));
    if((savefl=fopen(outbuf,"w")) != NULL){
	saveall(savefl, '\0');
	fclose(savefl);
    }
    else{
	XClearWindow(disp,inputw);
	XDrawString(disp,inputw,ntextgc,ICOORDS(0,0),SYSERR,strlen(SYSERR));
    }
}


int do_loadfile(filename, hotx, hoty)
    char *filename;
    int hotx, hoty;
{
    FILE *loadfl;
    int x,y, linect = 0;
#define M_ABSOLUTE	0
#define M_RELATIVE	1
#define M_PICTURE	2
    int loadmode = M_ABSOLUTE;

    if ((loadfl=fopen(filename,"r")) != NULL)
    {
	char	buf[BUFSIZ];
	int	xoff = 0, yoff = 0;

	while (fgets(buf, BUFSIZ, loadfl) != (char *)NULL)
	{
	    if (buf[0] == '#')
	    {
		char	incl[BUFSIZ];
		int	lx, ly;

		incl[0] = '\0';
		switch(buf[1])
		{

		  case 'N':
		    (void) strcat(fname,buf+2);
		    fname[strlen(fname)-1]=0;
		    break;

		  case 'A':
		    loadmode = M_ABSOLUTE;
		    break;
		    
		  case 'R':
		    loadmode = M_RELATIVE;
		    xoff = yoff = 0;
		    (void) sscanf(buf+2, " %d %d", &xoff, &yoff);
		    break;
		    
		  case 'P':
		    loadmode = M_PICTURE;
		    xoff = yoff = 0;
		    (void) sscanf(buf+2, " %d %d", &xoff, &yoff); 
		    break;
		    
		  case 'I':
		    xoff = yoff = 0;
		    (void) sscanf(buf+2, " %s %d %d", incl, &xoff, &yoff); 
		    (void) strcat(incl, addlifeext(incl));
		    if (!do_loadfile(incl, hotx + xoff, hoty + yoff))
			return(0);
		    break;
		    
		  case 'L':
		    (void) sscanf(buf+2, " %d %d %[^\n]", &lx, &ly, incl); 
		    XDrawString(disp, lifew, ntextgc,
				RXPOS(xoff+lx, xpos), RYPOS(yoff+ly, ypos),
				incl, strlen(incl));
		    break;

		    
		  default:
		    break;
		}
	    }
	    else if (loadmode == M_ABSOLUTE && sscanf(buf,"%d %d\n",&x,&y)==2)
	    {
		addcell(xpos + x, ypos + y);
		numcells++;
	    }
	    else if (loadmode == M_RELATIVE && sscanf(buf,"%d %d\n",&x,&y)==2)
	    {
		addcell(hotx + xoff + x, hoty + yoff + y);
		numcells++;
	    }
	    else /* loadmode == M_PICTURE */
	    {
		char	*cp;

		for (cp = buf; *cp; cp++)
		    if (*cp == '*')
		    {
			addcell(hotx + xoff + (cp-buf),
				hoty + yoff + linect);
			numcells++;
		    }
	    }
	    linect++;
	}
	fclose(loadfl);
	return 1;
    } else
	return 0;
}


void loadfile(){

    char outbuf[100];
    
    strcpy(inpbuf,"Load from:");
    minbuflen=10;
    strcat(inpbuf,loadirbuf);
    XClearWindow(disp,inputw);
    XDrawString(disp, inputw, ntextgc,ICOORDS(0,0),inpbuf, strlen(inpbuf));

    getxstring();
       
    strcpy(outbuf,checktilda(inpbuf+10));
    inpbuf[0]=0;
    strcat(outbuf,addlifeext(outbuf));
    if (do_loadfile(outbuf, XPOS(event.xmotion.x, xpos), YPOS(event.xmotion.y, ypos))) {
/*		    scale = 1;	*/
	XClearWindow(disp,lifew);
        redrawscreen();
    }
    else{
	XClearWindow(disp,inputw);
	XDrawString(disp,inputw,ntextgc,ICOORDS(0,0),SYSERR,strlen(SYSERR));
    }
}
			
