
/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  xrubik.c
#
###
#
#  Copyright (c) 1994 - 96	David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 4: 94/04/07 Xt
  Version 3: 93/05/20 Motif
  Version 2: 92/01/16 XView
  Version 1: 91/01/16 SunView
*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#define getlogin cuserid
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Rubik.h"
#include "Rubik2d.h"
#include "Rubik3d.h"
#include "rubik.xbm"

#ifndef SCOREFILE
#define SCOREFILE "/usr/games/lib/rubik.scores"
#endif

/* The following are in RubikP.h also */
#define MINCUBES 1
#define MAXFACES 6

#define MAXCUBES 6
#define MAXRECORD 32767
#define MAXPROGNAME 80
#define MAXNAME 256

static void Initialize(void);
static void CallbackRubik(Widget w, caddr_t clientData,
			  rubikCallbackStruct * callData);

static void PrintRecord(int size, Boolean orient, Boolean practice,
			char *record);
static int  HandleSolved(int counter, int size, Boolean orient);
static void PrintState(Widget w, char *prog, int dim, int size, int moves,
		       char *record, char *message);
static void ReadRecords(void);
static void WriteRecords(void);

static Widget rubik2d, rubik3d;
static Arg  arg[4];
static int  rubikRecord[2][MAXCUBES - MINCUBES + 1], movesDsp = 0;
static char progDsp[64] = "xrubik";
static char recordDsp[16] = "INF";
static char messageDsp[128] = "Welcome";
static char titleDsp[256] = "";

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xrubik\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
	   "\t[-{border|bd} {color}] [-mono] [-size {int}] [-[no]orient]\n");
	(void) fprintf(stderr,
		       "\t[-[no]practice] [-face{0|1|2|3|4|5} {color}]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*rubik.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*rubik.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-border", "*rubik.pieceBorder", XrmoptionSepArg, NULL},
	{"-bd", "*rubik.pieceBorder", XrmoptionSepArg, NULL},
	{"-mono", "*rubik.mono", XrmoptionNoArg, "TRUE"},
	{"-size", "*rubik.size", XrmoptionSepArg, NULL},
	{"-orient", "*rubik.orient", XrmoptionNoArg, "TRUE"},
	{"-noorient", "*rubik.orient", XrmoptionNoArg, "FALSE"},
	{"-practice", "*rubik.practice", XrmoptionNoArg, "TRUE"},
	{"-nopractice", "*rubik.practice", XrmoptionNoArg, "FALSE"},
	{"-face0", "*rubik.faceColor0", XrmoptionSepArg, NULL},
	{"-face1", "*rubik.faceColor1", XrmoptionSepArg, NULL},
	{"-face2", "*rubik.faceColor2", XrmoptionSepArg, NULL},
	{"-face3", "*rubik.faceColor3", XrmoptionSepArg, NULL},
	{"-face4", "*rubik.faceColor4", XrmoptionSepArg, NULL},
	{"-face5", "*rubik.faceColor5", XrmoptionSepArg, NULL},
};

int
main(int argc, char **argv)
{
	Widget      toplevel, shell;

	toplevel = XtInitialize(argv[0], "Rubik",
				options, XtNumber(options), &argc, argv);
	if (argc != 1)
		Usage();

	shell = XtCreateApplicationShell(argv[0], topLevelShellWidgetClass, NULL,
					 0);
	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			    (char *) rubik_bits, rubik_width, rubik_height));
	XtSetArg(arg[1], XtNinput, True);
	XtSetValues(toplevel, arg, 2);
	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(shell),
				       RootWindowOfScreen(XtScreen(shell)),
			    (char *) rubik_bits, rubik_width, rubik_height));
	XtSetArg(arg[1], XtNinput, True);
	XtSetValues(shell, arg, 2);
	rubik2d = XtCreateManagedWidget("rubik", rubik2dWidgetClass, toplevel,
					NULL, 0);
	XtAddCallback(rubik2d, XtNselectCallback, (XtCallbackProc) CallbackRubik,
		      (XtPointer) NULL);
	rubik3d = XtCreateManagedWidget("rubik", rubik3dWidgetClass, shell,
					NULL, 0);
	XtAddCallback(rubik3d, XtNselectCallback, (XtCallbackProc) CallbackRubik,
		      (XtPointer) NULL);
	Initialize();
	XtRealizeWidget(toplevel);
	XtRealizeWidget(shell);
	XGrabButton(XtDisplay(rubik2d), AnyButton, AnyModifier, XtWindow(rubik2d),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(rubik2d),
		    XCreateFontCursor(XtDisplay(rubik2d), XC_crosshair));
	XGrabButton(XtDisplay(rubik3d), AnyButton, AnyModifier, XtWindow(rubik3d),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(rubik3d),
		    XCreateFontCursor(XtDisplay(rubik3d), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

/* There's probably a better way to assure that they are the same but I don't
   know it off hand. */
static void
MakeEquivalent(int *size, Boolean * orient, Boolean * practice)
{
	Boolean     mono;
	Pixel       foreground, background, pieceBorder;
	String      faceColor[MAXFACES];

	XtVaGetValues(rubik2d,
		      XtNsize, size,
		      XtNorient, orient,
		      XtNpractice, practice,
		      XtNmono, &mono,
		      XtNforeground, &foreground,
		      XtNbackground, &background,
		      XtNpieceBorder, &pieceBorder,
		      XtNfaceColor0, &(faceColor[0]),
		      XtNfaceColor1, &(faceColor[1]),
		      XtNfaceColor2, &(faceColor[2]),
		      XtNfaceColor3, &(faceColor[3]),
		      XtNfaceColor4, &(faceColor[4]),
		      XtNfaceColor5, &(faceColor[5]),
		      NULL);
	XtVaSetValues(rubik2d,
		      XtNdirection, RUBIK_IGNORE,
		      XtNstart, FALSE,
		      NULL);
	XtVaSetValues(rubik3d,
		      XtNsize, *size,
		      XtNorient, *orient,
		      XtNmono, mono,
		      XtNdirection, RUBIK_IGNORE,
		      XtNpractice, *practice,
		      XtNstart, FALSE,
		      XtNforeground, foreground,
		      XtNbackground, background,
		      XtNpieceBorder, pieceBorder,
		      XtNfaceColor0, faceColor[0],
		      XtNfaceColor1, faceColor[1],
		      XtNfaceColor2, faceColor[2],
		      XtNfaceColor3, faceColor[3],
		      XtNfaceColor4, faceColor[4],
		      XtNfaceColor5, faceColor[5],
		      NULL);
}

static void
Initialize(void)
{
	int         size;
	Boolean     orient, practice;

	MakeEquivalent(&size, &orient, &practice);
	ReadRecords();
	PrintRecord(size, orient, practice, recordDsp);
	PrintState(XtParent(rubik2d), progDsp, 2, size, movesDsp,
		   recordDsp, messageDsp);
	PrintState(XtParent(rubik3d), progDsp, 3, size, movesDsp,
		   recordDsp, messageDsp);
}

static void
CallbackRubik(Widget w, caddr_t clientData, rubikCallbackStruct * callData)
{
	int         size, dim, otherdim;
	Boolean     orient, practice, start;
	Widget      otherw;

	if (w == rubik2d) {
		dim = 2;
		otherw = rubik3d;
		otherdim = 3;
	} else {		/* (w == rubik3d) */
		dim = 3;
		otherw = rubik2d;
		otherdim = 2;
	}
	XtVaGetValues(w,
		      XtNsize, &size,
		      XtNorient, &orient,
		      XtNpractice, &practice,
		      XtNstart, &start,
		      NULL);
	(void) strcpy(messageDsp, "");
	switch (callData->reason) {
		case RUBIK_RESTORE:
			XtSetArg(arg[0], XtNdirection, RUBIK_RESTORE);
			XtSetValues(otherw, arg, 1);
			XtSetValues(w, arg, 1);
			movesDsp = 0;
			break;
		case RUBIK_RESET:
			movesDsp = 0;
			break;
		case RUBIK_ILLEGAL:
			if (practice || start)
				(void) strcpy(messageDsp, "Illegal move");
			else
				(void) strcpy(messageDsp, "Randomize to start");
			break;
		case RUBIK_MOVED:
			movesDsp++;
#ifdef DEBUG
			if (movesDsp > 256)
				exit(1);
#endif
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetArg(arg[1], XtNface, callData->face);
			XtSetArg(arg[2], XtNpos, callData->position);
			XtSetArg(arg[3], XtNdirection, callData->direction);
			XtSetValues(otherw, arg, 4);
			XtSetValues(w, arg, 1);
			break;
		case RUBIK_CONTROL:
			XtSetArg(arg[0], XtNface, callData->face);
			XtSetArg(arg[1], XtNpos, callData->position);
			XtSetArg(arg[2], XtNdirection, callData->direction);
			XtSetValues(otherw, arg, 3);
			return;
		case RUBIK_SOLVED:
			if (practice)
				movesDsp = 0;
			else {
				if (HandleSolved(movesDsp, size, orient))
					(void) sprintf(messageDsp, "Congratulations %s!!", getlogin());
				else
					(void) strcpy(messageDsp, "Solved!");
			}
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			XtSetValues(otherw, arg, 1);
			break;
		case RUBIK_PRACTICE:
			movesDsp = 0;
			practice = !practice;
			if (!practice)
				(void) strcpy(messageDsp, "Randomize to start");
			PrintRecord(size, orient, practice, recordDsp);
			XtSetArg(arg[0], XtNpractice, practice);
			XtSetArg(arg[1], XtNstart, FALSE);
			XtSetValues(w, arg, 2);
			XtSetValues(otherw, arg, 2);
			break;
		case RUBIK_RANDOMIZE:
			movesDsp = 0;
			XtSetArg(arg[0], XtNpractice, FALSE);
			XtSetArg(arg[1], XtNstart, FALSE);
			XtSetValues(w, arg, 2);
			XtSetValues(otherw, arg, 2);
			break;
		case RUBIK_DEC:
			movesDsp = 0;
			size--;
			PrintRecord(size, orient, practice, recordDsp);
			XtSetArg(arg[0], XtNsize, size);
			XtSetValues(w, arg, 1);
			XtSetValues(otherw, arg, 1);
			break;
		case RUBIK_ORIENT:
			movesDsp = 0;
			orient = !orient;
			PrintRecord(size, orient, practice, recordDsp);
			XtSetArg(arg[0], XtNorient, orient);
			XtSetValues(w, arg, 1);
			XtSetValues(otherw, arg, 1);
			break;
		case RUBIK_INC:
			movesDsp = 0;
			size++;
			PrintRecord(size, orient, practice, recordDsp);
			XtSetArg(arg[0], XtNsize, size);
			XtSetValues(w, arg, 1);
			XtSetValues(otherw, arg, 1);
			break;
		case RUBIK_COMPUTED:
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			XtSetValues(otherw, arg, 1);
			break;
		case RUBIK_UNDO:
			movesDsp--;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetArg(arg[1], XtNface, callData->face);
			XtSetArg(arg[2], XtNpos, callData->position);
			XtSetArg(arg[3], XtNdirection, callData->direction);
			XtSetValues(otherw, arg, 4);
			XtSetValues(w, arg, 1);
			break;
	}
	PrintState(XtParent(w), progDsp, dim, size, movesDsp,
		   recordDsp, messageDsp);
	PrintState(XtParent(otherw), progDsp, otherdim, size, movesDsp,
		   recordDsp, messageDsp);
}

static void
PrintRecord(int size, Boolean orient, Boolean practice, char *record)
{
	int         i = (orient) ? 1 : 0;
	int         j = size - MINCUBES;

	if (practice)
		(void) strcpy(record, "practice");
	else if (size > MAXCUBES)
		(void) strcpy(record, "NOT RECORDED");
	else if (rubikRecord[i][j] >= MAXRECORD)
		(void) strcpy(record, "NEVER");
	else
		(void) sprintf(record, "%d", rubikRecord[i][j]);
}

static int
HandleSolved(int counter, int size, Boolean orient)
{
	int         i = (orient) ? 1 : 0;
	int         j = size - MINCUBES;

	if (size <= MAXCUBES && counter < rubikRecord[i][j]) {
		rubikRecord[i][j] = counter;
		if (size < 2 || (orient && (rubikRecord[i][j] < rubikRecord[!i][j])))
			rubikRecord[!i][j] = counter;
		WriteRecords();
		(void) sprintf(recordDsp, "%d", counter);
		return TRUE;
	}
	return FALSE;
}

static void
PrintState(Widget w, char *prog, int dim, int size, int moves, char *record, char *message)
{
	(void) sprintf(titleDsp, "%s%dd: %d@ (%d/%s) - %s", prog, dim, size, moves,
		       record, message);
	XtSetArg(arg[0], XtNtitle, titleDsp);
	XtSetValues(w, arg, 1);
}

static void
ReadRecords(void)
{
	FILE       *fp;
	int         i, n, orient;

	for (orient = 0; orient < 2; orient++)
		for (i = 0; i < MAXCUBES - MINCUBES + 1; i++)
			rubikRecord[orient][i] = MAXRECORD;
	if ((fp = fopen(SCOREFILE, "r")) == NULL)
		(void) sprintf(messageDsp,
			     "Can not open %s, taking defaults.", SCOREFILE);
	else {
		for (orient = 0; orient < 2; orient++)
			for (i = 0; i < MAXCUBES - MINCUBES + 1; i++) {
				(void) fscanf(fp, "%d", &n);
				rubikRecord[orient][i] = n;
			}
		(void) fclose(fp);
	}
}

static void
WriteRecords(void)
{
	FILE       *fp;
	int         i, orient;

	if ((fp = fopen(SCOREFILE, "w")) == NULL)
		(void) sprintf(messageDsp, "Can not write to %s.", SCOREFILE);
	else {
		for (orient = 0; orient < 2; orient++) {
			for (i = 0; i < MAXCUBES - MINCUBES + 1; i++)
				(void) fprintf(fp, "%d ", rubikRecord[orient][i]);
			(void) fprintf(fp, "\n");
		}
		(void) fclose(fp);
	}
}
