#include <config.h>
#ifdef PLAN9_DRIVER
#include <u.h>
#include <libc.h>
#include <stdio.h>
#include <libg.h>
#include "zoom.h"
#include "ui.h"
#include "palette.h"
#include "gif.h"

Bitmap *mybitmap;
char *buffers[2];
Rectangle rect, rect1;
int width, height;
int current = 0;
int nopalette;

RGB cmap[256];
int ncolors = 255;
static int mousex, mousey, mousebuttons;
static int plan9_set_color(int r, int g, int b, int init)
{
    RGB c =
    {r * 256 * 256 * 256, g * 256 * 256 * 256, b * 256 * 256 * 256};
    if (nopalette) {
	return (rgbpix(&screen, c));
    } else {
	ncolors--;
	if (init)
	    ncolors = 254;
	if (ncolors < 5)
	    return -1;
	cmap[255].red = 0;
	cmap[255].green = 0;
	cmap[255].blue = 0;
	cmap[0].red = 0xffffffffUL;
	cmap[0].green = 0xffffffffUL;
	cmap[0].blue = 0xffffffffUL;

	cmap[ncolors].red = (unsigned long) r *256UL * 256UL * 256UL;
	cmap[ncolors].green = (unsigned long) g *256UL * 256UL * 256UL;
	cmap[ncolors].blue = (unsigned long) b *256UL * 256UL * 256UL;
	wrcolmap(&screen, cmap);
    }
    return (ncolors);
}

static void plan9_print(int x, int y, char *text)
{
    Point p =
    {rect.min.x + x, rect.min.y + y};
    string(&screen, p, font, text, S);
    bflush();

}
static void plan9_getmouse(int *x, int *y, int *buttons)
{
    *x = mousex;
    *y = mousey;
    *buttons = mousebuttons;

}

static void plan9_display(void)
{
    wrbitmap(mybitmap, 0, height, (unsigned char *) buffers[current]);
    bitblt(&screen, rect.min, mybitmap, rect1, S);
    bflush();
}

static void plan9_flip_buffers(void)
{
    current ^= 1;
/*
   xflip_buffers(d);
 */
}

void ereshaped(Rectangle rect1)
{
    ui_resize();
}
static void plan9_processevent(int wait, int *mx, int *my, int *b, int *k)
{
    int iflag = 0;
    static int keys;
    int inmovement = 0;
    Event E;
    int quit = 0;
    while (wait || ecanread(Emouse | Ekeyboard)) {
	wait = 0;
	switch (event(&E)) {
	case Emouse:
	    mousex = E.mouse.xy.x - rect.min.x;
	    mousey = E.mouse.xy.y - rect.min.y;
	    inmovement = E.mouse.buttons;
	    mousebuttons = 0;
	    inmovement = 1;
	    if (E.mouse.buttons & 1)
		mousebuttons = BUTTON1;
	    if (E.mouse.buttons & 2)
		mousebuttons |= BUTTON2;
	    if (E.mouse.buttons & 4)
		mousebuttons |= BUTTON3;
	    break;
	case Ekeyboard:{
		int sym;
		if (E.kbdc == '[')
		    keys ^= 1;
		if (E.kbdc == ']')
		    keys ^= 2;
		if (E.kbdc == '\'')
		    keys ^= 4;
		if (E.kbdc == ';')
		    keys ^= 8;
		ui_key(tolower(E.kbdc));
	    }
	    break;
	}

    }

    *mx = mousex;
    *my = mousey;
    *b = mousebuttons;
    *k = keys;
}
static void plan9_getsize(int *w, int *h)
{
    bscreenrect(&rect);
    width = rect.max.x - rect.min.x;
    height = rect.max.y - rect.min.y;
    rect1.min.x = 0;
    rect1.min.y = 0;
    rect1.max.x = width;
    rect1.max.y = height;
    *w = width;
    *h = height;
}
static int plan9_allocbuffers(char **b1, char **b2)
{
    mybitmap = balloc(rect1, 3);
    current = 0;
    *b1 = buffers[0] = (char *) malloc(width * (height + 1));
    *b2 = buffers[1] = (char *) malloc(width * (height + 1));
    return (1);
}
static void plan9_freebuffers(char *b1, char *b2)
{
    free(buffers[0]);
    free(buffers[1]);
    bfree(mybitmap);
}
struct ui_driver plan9_driver;

static int plan9_init(void)
{
    binit(NULL, NULL, "XaoS");
    einit(Ekeyboard | Emouse);
    if (nopalette)
	plan9_driver.randomsize = plan9_driver.updateafterpalette = 1;
    return 1;
    /*ui_init(context, display, set_color, 1, myprint, font->height); */
}
static void plan9_uninit()
{
    bexit();
}

static char *helptext[] =
{
    "PLAN9 DRIVER VERSION 2.0               ",
    "========================               ",
    "  This driver is bit uncomplette.      ",
    "  please read README.plan9 and help me ",
    "  complete it if you want.             ",
    "                                       ",
    "  Additional keys:                     ",
    "  '[' and '[' changing iterations      ",
    "  ';' amd ''' changing speed           ",
    "                                       ",
    "  Palette handling:                    ",
    "  By default XaoS changes colormap.    ",
    "  This will break all colorfull        ",
    "  programs like mortha (is there any   ",
    "  other?) There is easy trick:         ",
    "  use -nopalette switch. At the other  ",
    "  hand this makes XaoS look ugly.      ",
    "  Nothing is perfect...                ",
    "                                       ",
    "  PLAN9 driver was done by Jan Hubicka ",
    "              (C) 1996                 ",
};
#define UGLYTEXTSIZE (sizeof(helptext)/sizeof(char *))
static struct params params[] =
{
    {"-nopalette", P_SWITCH, &nopalette, "Disable palette allocating. Use ugly looking rgbpixel instead"},
    {NULL, 0, NULL, NULL}
};

struct ui_driver plan9_driver =
{
    "plan9",
    plan9_init,
    plan9_getsize,
    plan9_processevent,
    plan9_getmouse,
    plan9_uninit,
    plan9_set_color,
    plan9_print,
    plan9_display,
    plan9_allocbuffers,
    plan9_freebuffers,
    plan9_flip_buffers,
    0,
    256,
    14,
    0,
    0,
    0,
    helptext,
    UGLYTEXTSIZE,
    params
};

#endif
