/*
*****************************************************************************
** xbmbrowser version 4.0  (c) Copyright Ashley Roll, all rights reserved.
** FILE: xbmbrowser.h 
**
** xbmbrowser is Public Domain. However it, and all the code still belong to me.
** I do, however grant permission for you to freely copy and distribute it on 
** the condition that this and all other copyright notices remain unchanged in 
** all distributions.
**
** This software comes with NO warranty whatsoever. I therefore take no
** responsibility for any damages, losses or problems that the program may 
** cause.
*****************************************************************************
*/

#include <stdio.h>             /* C library includes */
#include <X11/Xos.h>           /* include some system files */ 
#include <dirent.h> 
#include <sys/stat.h>
#include <assert.h>            /* debugging assertions */

#include <X11/Xlib.h>          /* X programming includes */
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>      
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>      /* widget includes */
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h> 
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#ifdef DO_XPMS
# include <xpm.h>
#endif

/***************************************************************************
    SITE SPECIFIC STUFF - EDIT TO MATCH YOUR SETUP
 ***************************************************************************/
/*
** The full path to the default menu configuration file
*/
#ifndef LIBRARY_RC
#define LIBRARY_RC "/usr/lib/X11/xbmbrowser.menu"
#endif

/*
** The name of the users menu (rc) file to find in users home
*/
#ifndef USERS_RC
#define USERS_RC ".xbmbrowserrc"
#endif

/***************************************************************************
    PROGRAM STUFF - CHANGE IT AT YOUR OWN RISK
 ***************************************************************************/

/***** Type Definitions *****/

/* the various types of file we deal with */
enum FileType {
  Unknown,                       /* Unknown, Special Files */
  Dir, DirUp, DirLink, DirBad,   /* Directory types */
  /* NOTE: Non-File == (type < File) */
  File, Text, Binary,    /* File types  ( File = undetermined file ) */
  Xbm, Xpm, XpmBad,      /* Image files ( XpmBad is a filed load ) */
  NumFileTypes           /* Count of file types */
};

/* item structure */
typedef struct _item {
  char              fname[MAXNAMLEN];   /* This files name in current dir */
  char              info[MAXNAMLEN+40]; /* information to store in widget */
  time_t            mtime;       /* last modification time */
  enum FileType     type;        /* file type */
  Pixmap            bitmap;      /* bitmap from this file - to widget */
  int               index;       /* widget the bitmap is currently in */
  struct _item     *next;        /* next item */
#ifdef DO_XPMS
  XpmAttributes     attr;        /* xpm attributes -- colors to free */
#endif
} Item;

/* resource data structure */
typedef struct {
  char    *cmd_rc;         /* the config file given on command line */
  char    *user_rc;        /* the user's rc file in his/her home dir */
  char    *library_rc;     /* the library menu configuration file */
  Boolean  icons_only;     /* display icons only  */
  Boolean  show_dir;       /* show these file symbols ( unless icons_only ) */
  Boolean  show_xpmbad;
  Boolean  show_other;
  Boolean  recursive;      /* recursive directory scan -- watch it */
  Pixel    sym_fore;       /* foreground for file symbols */
  Pixel    sym_back;       /* background for file symbols */
  Pixel    icon_fore;      /* foreground for bitmap icons */
  Pixel    icon_back;      /* background for bitmap icons */
} AppData, *AppDataPtr;


/***** Variable Definitions *****/

#ifdef MAIN
#define ext
#else
#define ext extern
#endif

ext AppData    app_data;            /* the application resource structure */
ext Display   *display;             /* Xlib display pointer */
ext Colormap   colormap;            /* the default colormap of screen */
ext Cursor     normalCursor, waitCursor;    /* Cursours */
ext Pixmap     tickoff, tickon;     /* tickbox bitmaps for option menu */
ext Widget     mainpw, dirwidget;   /* Globally Known Widgets */
ext Widget     dirmenu, dirlist;    /* directory list popup */
ext Widget     label, bitmaps;      /* information and bitmap box */
ext Widget     recur_opt;           /* recursive toggle menu option */

ext Pixmap filesyms[(int)NumFileTypes];  /* default file type icon images */
                                         /* To be initialized later */

/* user menu widgets which may or may-not be defined by the user */
ext Widget     menu_global, menu_bitmap, menu_pixmap;
ext Widget     menu_directory, menu_other;

/* substitution strings for function argument macro substitions */
ext char     dir_name[MAXNAMLEN];     /* %d the current directory */
ext char     file_name[MAXNAMLEN];    /* %f current filename */
ext char     base_name[MAXNAMLEN];    /* %b basename for current file */
ext char     suffix[MAXNAMLEN];       /* %s suffix of current file */
ext char     input[MAXNAMLEN];        /* %i input string from user */
ext char     home_dir[MAXNAMLEN];     /* %h the users home directory */

/* Information strings for display in application label */
ext char     label_info[MAXNAMLEN];   /* label to show when outside bitmap */
ext char    *bitmap_info;             /* information of the current widget */


/* some external variables */
extern char Translations[];

/***** Proceedure Definitions *****/

/* callback procedures   "callbacks.c" */
extern void    quit_browser();
extern void    set_name();
extern void    set_label();
extern void    rescan();
extern void    scan();
extern void    dir_return();
extern void    dir_menu();
extern void    pos_dir();
extern void    popup_user_menu();
extern void    toggle_option();

/* user defined menu module  "user-menu.c" */
extern void    menu_item_abort();
extern void    menu_item_continue();
extern void    read_user_menu();

/* user functions       "user-functs.c" */
extern void    expand_tilde();
extern void    change_dir();
extern void    exec_string();
extern void    user_confirm();
extern void    input_string();

/* icon display routines   "bitmap.c" */
extern Item   *alloc_item();
extern Item   *free_item();
extern void    free_list();
extern void    scan_bitmaps();
extern void    rescan_bitmaps();

/* miscelanous functions  "misc.c" */
extern void    set_busywait();
extern void    clear_busywait();
extern Item   *get_files();

/*********** Macros ************/

/* CAT:  Macro to concatenate two arguments into one compiler symbol
** example:   CAT(symbol,_height)  becomes  symbol_height
** Note: some sites may need to set this explicitely -- mail me the result
*/
#ifndef CAT
#  ifdef __STDC__
#    define CAT(a,b)  a##b   /* ANSI concatenate */
#  else
#    ifndef sun
#      define CAT(a,b)  a/**/b  /* Old K&R concatenate */
#    else
#      undef  IDENT
#      define IDENT(x)  x
#      define CAT(a,b)  IDENT(a)b  /* Sun concatenate */
#    endif
#  endif
#endif

/* LOAD_SYM: Macro to load the symbol table with included bitmap data
** example: LOAD_SYM(sym,file) will load the symbol `sym' in the symbol
** table with the bitmap created from the data  file_bits which was
** included from a bitmap file "file.xbm".
** A new LOAD_SYM could load X pixmap file symbols in the future.
*/
/* just load the bitmap symbols as bitmaps -- color handled on assignment */
#define LOAD_SYM(sym,file) \
    filesyms[sym] = XCreateBitmapFromData( \
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),\
              (char *)CAT(file,_bits), CAT(file,_width), CAT(file,_height) )
#ifdef SYMS_AS_PIXMAPS
#undef LOAD_SYM
/* Attempt to load bitmap as a pixmap, presetting the colors for the symbol.
** This inverts the bitmaps on some monocrome displays (like NCDs)
** (Abandoned)
*/
#define LOAD_SYM(sym,file) \
    filesyms[sym] = XCreatePixmapFromBitmapData( \
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),\
              (char *)CAT(file,_bits), CAT(file,_width), CAT(file,_height), \
              app_data.sym_fore, app_data.sym_back, \
              DefaultDepthOfScreen(XtScreen(toplevel)) )
#endif /* SYMS_AS_PIXMAPS */

/* SITE SPECIFICS -- MAIL ME YOUR CHANGES */

/* Marco for brain dead Ultrix and SVR4 machines
** Brian Dowling <bdowling@ccs.neu.edu> -- Ultrix
** John Polstra <jdp@polstra.com> -- SVR4
*/
#ifndef S_ISLNK
# ifdef S_IFLNK
#  if defined(_S_IFMT)   /* Ultrix */
#   define S_ISLNK(mode) (((mode) & _S_IFMT) == S_IFLNK)
#  elif defined(S_IFMT)  /* SVR4 */
#   define S_ISLNK(mode) (((mode) & S_IFMT) == S_IFLNK)
/*#else -- HEY how should you test for symlinks on this system? */
#  endif
# else /* no S_IFLNK then system probably has no symlinks */
#  define S_ISLNK(mode) (0)
# endif
#endif

/*********************************/

