#include "global.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

struct XObj 
{
  Window ObjWin;		/* Fenetre contenant l'objet */
  Window *ParentWin;		/* Fenetre parent */
  Display *display;
  int Screen;
  Colormap *colormap;
  XColor TabColor[6];
  GC gc;			/* gc utilise pour les requetes: 4 octets */
  int id;			/* Numero d'id */
  int x,y;			/* Origine du bouton */
  int height,width;		/* Hauteur et largeur */
  char *title;			/* Titre */
  char *icon;			/* Icon */
  char *forecolor;		/* Couleur des lignes */
  char *backcolor;		/* Couleur de fond */
  char *shadcolor;		/* Couleur des lignes */
  char *licolor;		/* Couleur de fond */
  char *font;			/* Police utilis */
  XFontStruct *xfont;
  int value;
  State state;
  void (*InitObj) (struct XObj *xobj);	/* Initialisation de l'objet */
  void (*DestroyObj) (struct XObj *xobj);	/* Destruction objet */
  void (*DrawObj) (struct XObj *xobj);	/* Dessin de l'objet */
  void (*EvtMouse) (struct XObj *xobj);	/* Traitement d'un clic souris */
  void (*EvtKey) (struct XObj *xobj,XKeyEvent *EvtKey);
  void *UserPtr;			/* Donnee additionelle */
};

void ChooseFunction(struct XObj *xobj,char *type);
