#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"
/* #define GDEBUG */

extern struct setup Setup;
extern struct stat Stat;
FD_droptable *f_droptable;

void main_droptable(FL_OBJECT *obj, long data)
{
  if(Stat.flagDroptable) return;
  Stat.flagDroptable=1;
  
  f_droptable = create_form_droptable();
  fl_show_form(f_droptable->droptable, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin drop table");
  fl_freeze_form(f_droptable->droptable);

  browser_getDatabases(f_droptable->banques);
  
  g_deactivate_object(f_droptable->tables);
  g_deactivate_object(f_droptable->drop);

  fl_unfreeze_form(f_droptable->droptable);
}

void droptable_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_droptable->droptable);
  fl_free_form(f_droptable->droptable);
  free(f_droptable);
  Stat.flagDroptable=0;
}


void droptable_banque(FL_OBJECT *obj, long data)
{
  int ligne;
  char database[33];  

  ligne = fl_get_browser(obj);
#ifdef GDEBUG
  printf("droptable_banque() fl_get_browser() -> %d lignes\n", ligne);
#endif
  fl_freeze_form(f_droptable->droptable);
  
  if(ligne > 0)
  {

    strcpy(database,fl_get_browser_line(obj, ligne)); 
#ifdef GDEBUG
  printf("droptable_banque() fl_get_browser_line() -> database=[%s]\n", database);
#endif
    browser_getTables(f_droptable->tables, database);
#ifdef GDEBUG
  printf("droptable_banque() apres browser_getTables()\n");
#endif
    if(fl_get_browser_maxline(f_droptable->tables))
    {
      g_activate_object(f_droptable->tables);
    }
    else
    {
      g_deactivate_object(f_droptable->tables);
    }
  }
  else
  {
    g_deactivate_object(f_droptable->tables);
  }
  fl_unfreeze_form(f_droptable->droptable);
}			  
			  
void droptable_tables(FL_OBJECT *obj, long data)
{
  if(fl_get_browser_maxline(f_droptable->tables))
  {
    g_activate_object(f_droptable->drop);
  }
  else
  {
    g_activate_object(f_droptable->drop);
  }

}

void droptable_drop(FL_OBJECT *obj, long data)
{
  char database[33];
  char table[33];
  int ligne;

  if(!fl_show_question("Warning\nThis will erase the table files\nDo you want to continue?", 0))
	return;
  if(!fl_show_question("Are you sure?\nThe table will be destroyed, erased, deleted\nobliterated, annihilated, killed, forgetted!\n", 0))
	return;
  /*-----------------------------------*/
  /* va chercher le nom de la database */
  /*-----------------------------------*/
  ligne = fl_get_browser(f_droptable->banques);
  strcpy(database, fl_get_browser_line(f_droptable->banques, ligne));

  {
    char sql[128];
    MYSQL connection;
    
    /*-----------------------------------*/
    /* va chercher le nom de la table    */
    /*-----------------------------------*/
    ligne = fl_get_browser(f_droptable->tables);
    strcpy(table, fl_get_browser_line(f_droptable->tables, ligne));
    
    /*---------------------------*/
    /* construit la commande sql */
    /*---------------------------*/
    sprintf(sql, "drop table %s", table);

    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;

      mysql_select_db(&connection, database);
      if(mysql_query(&connection, sql))
      {
	fl_show_alert(mysql_error(&connection),"","",0);
      }
      else
      {
	result = mysql_store_result(&connection);
	mysql_free_result(result);

	fl_show_message("The table",table,"has been destroyed >:->");
      }

      mysql_close(&connection);
    }
    else
    {
      fl_show_alert("Cannot connect to server","","",0);
    }
  }

  
  fl_freeze_form(f_droptable->droptable);
  browser_getTables(f_droptable->tables, database);
  if(fl_get_browser_maxline(f_droptable->tables))
  {
    g_activate_object(f_droptable->tables);
  }
  else
  {
    g_deactivate_object(f_droptable->tables);
  }

  g_deactivate_object(f_droptable->drop);
  fl_unfreeze_form(f_droptable->droptable);
}


