/***************************************************************************
**    xMultiLinWin.h  $Revision: 1.7 $ - $Name: V2-18 $ 
**    QWidget for manipulating Multiple lines of text in a window
**
**    Copyright (C) 1996 Joseph Croft <jcroft@unicomp.net>
**
**    This library is free software; you can redistribute it and/or
**    modify it under the terms of the GNU Library General Public
**    License as published by the Free Software Foundation; either
**    version 2 of the License, or (at your option) any later version.
**
**    This library is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**    Library General Public License for more details.
**
**    You should have received a copy of the GNU Library General Public
**    License along with this library; if not, write to the Free
**    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xMULTILINEWIN_H
#define _xMULTILINEWIN_H

#include <qwidget.h>
#include "xResources.h"
#include "xMultiLineBuf.h"

class xMultiLineWin : public QWidget, public xMultiLineBuf
{
   Q_OBJECT

public:
   xMultiLineWin(xWidgetResInfo *pPRes, QWidget *pParent = NULL,
                 const char *pName = NULL,
                 int width = 80, int height = 24,
                 int bufHeight = 200);
   ~xMultiLineWin();
   
   virtual const QString   *putString(const char *pStr);
   virtual int             getPosition() { return(botLineOfs); };
   void                    drawChar(QPainter *p, int &y, int x, int ch);
   virtual void            mouseDoubleClickEvent(QMouseEvent *pEvt);

signals:
   void changePageSize(int height);
   void linesUsedChanged(int lines);
   void textSelected(QString);

public slots:
   void scrollWindow(int lines);
   void scrollToLine(int line);

protected slots:
   void inputText(const char *pText) { putString(pText); };
   void scrollWindowImage(int lines);
   void updateImage(int lines);
   
protected:
   virtual void   paintEvent(QPaintEvent *pEvt);
   virtual void   resizeEvent(QResizeEvent *pEvt);
   virtual bool   testForScroll();
   
   QFont          f;
   QFont          fontBold;
   QColor         boldColor;
   QColor         fgColor;
   int            botLineOfs;
   int            windowHeight;
   int            windowWidth;
   int            bufferLen;

private:
   xWidgetResInfo *wdtRes;
};

#endif
