/*
  Copyright (C) 1997,1998  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Password encryption/decryption data structures and routines */

static unsigned char pkey[8] = {0x87,0xB6,0xAC,0xAF,0xC6,0xC8,0x94,0x8C},
					 ukey[64], upwd[64];

/* Initializes the pcode module */
void pcode_init(void)
{
	int i;

	for (i=0; i<8; i++)		/* since we don't want it sticking around */
		pkey[i] ^= 0xFF;	/* as plain text in the executable ;) */
}

/* Packs 64 bits saved in array of char into 8 bytes */
static void cpack(unsigned char *pb, unsigned char *ub)
{
	int i,j;
	unsigned char mask, pc;

	for (i=0; i<8; i++) {
		for (mask=0x80, pc=j=0; j<8; mask>>=1, j++) {
			pc |= (ub[i*8+j])? mask:0x00;
		}
		pb[i] = pc;
	}
}

/* Unpacks 8 bytes into 64 bits saved in array of char */
static void cupack(unsigned char *ub, unsigned char *pb)
{
	int i,j;

	for (i=0; i<8; i++) {
		for (j=0; j<8; j++) {
			ub[i*8+j] = (pb[i] & (0x80>>j)) ? 1:0;
		}
	}
}

/* Encrypts the plain-text password */
void pencode(unsigned char *ep, unsigned char *pp)
{
	int i;
	void setkey(), encrypt();

	cupack(ukey, pkey);				/* unpack the key */
	setkey(ukey);					/* insert it in crypt's machine */
	for (i=0; i<4; i++) {			/* do all 32 bytes */
		cupack(upwd, pp);			/* unpack the plain-text password */
		encrypt(upwd, 0);			/* encrypt it in place */
		cpack(ep, upwd);			/* copy it out into the result */
		ep += 8; pp += 8;			/* get next 8 bytes */
	}
}

/* Decrypts the password */
void pdecode(unsigned char *pp, unsigned char *ep)
{
	int i;
	void setkey(), encrypt();

	cupack(ukey, pkey);				/* unpack the key */
	setkey(ukey);					/* insert it in crypt's machine */
	for (i=0; i<4; i++) {			/* do all 32 bytes */
		cupack(upwd, ep);			/* unpack the encrypted password */
		encrypt(upwd, 1);			/* decrypt it in place */
		cpack(pp, upwd);			/* copy it out into the result */
		ep += 8; pp += 8;			/* get next 8 bytes */
	}
}

