// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C"
{
#include <stdlib.h>
#include <ctype.h>
}
#include <qfont.h>
#include "qweb.h"
#include "Options.h"

Options::Options( int argc, char** argv )
        : _autoLoad( TRUE ),
          _catalogFile( "/usr/lib/qweb/dtd/CATALOG" ),
          _homeUrl( "http://sunsite.auc.dk/qweb/" ),
          _debugging( FALSE ),
          _menuFontName( "helvetica" ),
          _menuFontSize( 12 ),
          _menuFontWeight( QFont::Bold ),
          _menuFontItalic( FALSE )
{
    _bookmarksUrl = "file:";
    _bookmarksUrl += getenv( "HOME" );
    _bookmarksUrl += "/bookmarks.sgml";
    load();

    for ( int i = 1; i < argc; i++ ) {
        if ( !strcmp( argv[i], "-autoload" ) ) {
            _autoLoad = TRUE;
        } else if ( !strcmp( argv[i], "-noautoload" ) ) {
            _autoLoad = FALSE;
        } else if ( !strcmp( argv[i], "-bookmarks" ) ) {
            _bookmarksUrl = argv[++i];
        } else if ( !strcmp( argv[i], "-catalog" ) ) {
            _catalogFile = argv[++i];
        } else if ( !strcmp( argv[i], "-home" ) ) {
            _homeUrl = argv[++i];
        } else if ( !strcmp( argv[i], "-debug" ) ) {
            _debugging = TRUE;
        } else if ( !strcmp( argv[i], "-nodebug" ) ) {
            _debugging = FALSE;
        } else {
            if ( strcmp( argv[i], "-h" ) ) {
                fprintf( stderr, "%s: unrecognized options '%s'\n", argv[0], argv[i] );
            }
            fprintf( stderr, "Available options:\n" );
            fprintf( stderr, "-autoload        Automatically load the home URL at startup.\n" );
            fprintf( stderr, "-noautoload      Do not automatically load the home URL.\n" );
            fprintf( stderr, "-bookmarks <url> The URL of the bookmarks file.\n" );
            fprintf( stderr, "-catalog <url>   The URL Of the SGML catalog.\n" );
            fprintf( stderr, "-home <url>      The document to load at startup.\n" );
            fprintf( stderr, "-debug           Enable debugging output.\n" );
            fprintf( stderr, "-nodebug         Disable debugging output.\n" );
            fprintf( stderr, "\n" );
            fprintf( stderr, "QWeb version %s, Copyright (C) 1997 Sean Vyain\n", QWEB_VERSION_STRING );
            fprintf( stderr, "QWeb comes with ABSOLUTELY NO WARRANTY; for details see the LICENSE file.\n" );
            fprintf( stderr, "This is free software, and you are welcome to redistribute it\n" );
            fprintf( stderr, "under certain conditions; see the LICENSE file for details.\n" );

            exit( 1 );
        }
    }
}

QString Options::getToken( FILE* fp )
{
	QString tok;
	char ch = 0;
	
	while ( !feof( fp ) && isspace( ch = getc( fp ) ) );
	tok += ch;
	while ( !feof( fp ) && !isspace( ch = getc( fp ) ) ) {
		tok += ch;
	}
	return tok;
}

void Options::load()
{
    QString fn = getenv( "HOME" );
    fn += "/.qwebrc";
    
    FILE* fp;
    if ( !(fp = fopen( fn, "r" ) ) ) return;
    
    while ( !feof( fp ) ) {
        QString type  = getToken( fp );
        QString value = getToken( fp );
        if ( type == "autoLoad" ) {
            _autoLoad = value.toInt();
        } else if ( type == "bookmarksUrl" ) {
            _bookmarksUrl = value.copy();
        } else if ( type == "catalogFile" ) {
            _catalogFile = value.copy();
        } else if ( type == "homeUrl" ) {
            _homeUrl = value.copy();
        }
    }

    fclose( fp );
}

void Options::save()
{
    QString fn = getenv( "HOME" );
    fn += "/.qwebrc";

    FILE* fp;
    if ( !(fp = fopen( fn, "w" ) ) ) return;
    
    fprintf( fp, "verson       %s\n", QWEB_VERSION_STRING );
    fprintf( fp, "autoLoad     %d\n", _autoLoad );
    fprintf( fp, "bookmarksUrl %s\n", _bookmarksUrl.data() );
    fprintf( fp, "catalogFile  %s\n", _catalogFile.data() );
    fprintf( fp, "homeUrl      %s\n", _homeUrl.data() );
    
    fclose( fp );
}
