// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qmlined.h>
#include "Canvas.h"
#include "TextAreaRenderer.h"

TextAreaRenderer::TextAreaRenderer( int         rows,
                                    int         cols,
                                    Canvas*     canvas,
                                    int         clipWidth,
                                    QObject*    parent,
                                    const char* name )
        : FormObjectRenderer( canvas, clipWidth, parent, name )
{
    _mle = new QMultiLineEdit( canvas->clip() );
    canvas->registerWidget( this, _mle );

    int w = cols * ( _mle->fontMetrics().width( '0' ) + 1 ) + 4;
    int h = rows * ( _mle->fontMetrics().height() + 1 ) + 4;

    _mle->setGeometry( 4, 4, w, h );

    _minimumWidth = w + 8;
    _maximumWidth = w + 8;
    resize( w + 8, h + 8 );
}

QString TextAreaRenderer::value()
{
    QString nm  = name();
    QString val = _mle->text();

    if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
        return "";
    }

    Url::encode( nm );
    Url::encode( val );

    QString tmp;
    tmp.sprintf( "%s=%s", nm.data(), val.data() );
    return tmp;
}

void TextAreaRenderer::reset()
{
    _mle->setText( _value );
}

bool TextAreaRenderer::redraw()
{
    return FALSE;
}

void TextAreaRenderer::endOfData()
{
}

void TextAreaRenderer::content( QString text )
{
    _value += text;
    _mle->append( text );
}
