// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: notify.cc,v 1.2 1998/08/27 04:09:54 jgg Exp $
/* ######################################################################

   Notify - Notification mechanism
   
   Implements a simple linked list and some search operators
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/notify.h"
#endif  
#include <deity/notify.h>
#include <deity/widget.h>
									/*}}}*/

// NotifyerList::NotifyerList - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
NotifyerList::NotifyerList()
{
   List = 0;
}
									/*}}}*/
// NotifyerList::~NotifyerList - Destructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
NotifyerList::~NotifyerList()
{
   for (Notifyer *I = List; I != 0;)
   {
      Notifyer *Cur = I;
      I = I->Next;
      Cur->Next = 0;
      delete Cur;
   }   
}
									/*}}}*/
// NotifyerList::Add - Add a new notification				/*{{{*/
// ---------------------------------------------------------------------
/* */
void NotifyerList::Add(Notifyer *Notify)
{
   // Add the notification at the end of the list;
   Notifyer **Last = &List;
   for (;*Last != 0; Last = &(*Last)->Next);
   Notify->Next = *Last;
   *Last = Notify;
}
									/*}}}*/
// NotifyerList::Trigger - Trigger all matching notifications		/*{{{*/
// ---------------------------------------------------------------------
/* */
bool NotifyerList::Trigger(Widget *From,Notifyer::Tag ID,void *Data)
{
   bool Result = true;
   for (Notifyer *I = List; I != 0; I = I->Next)
      if (I->ID == ID)
	 Result &= I->Trigger(From,ID,Data);
   return Result;
}
									/*}}}*/

// Notifyer::Notifyer - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
Notifyer::Notifyer(Tag ID) : Next(0), ID(ID)
{
}
									/*}}}*/
// FuncNotifyer::FuncNotifyer - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
FuncNotifyer::FuncNotifyer(Tag ID,TFunc Func) :
              Notifyer(ID), Func(Func)
{
}
									/*}}}*/
// AttachCallback - Attach a callback to a widget			/*{{{*/
// ---------------------------------------------------------------------
/* */
void AttachCallback(Widget *To,Notifyer::Tag ID,FuncNotifyer::TFunc Func)
{
    To->Add(new FuncNotifyer(ID,Func));
}
									/*}}}*/
