#! /bin/bash

# Verbose shell execution.
set -x

revext="$1"
kernel="$2"
shift 2
packages_with_modules="$*"

extractdir=/var/tmp/extract-tmp-$$

kernel_version=`echo $kernel | sed -e 's/.*kernel-image-//' | \
                        sed -e 's/_.*//'`
rm -rf $extractdir
mkdir $extractdir

echo kernel: $kernel
for i in $kernel $packages_with_modules; do
	dpkg-deb --extract $i $extractdir; \
done

if [ "$revext" = lowmem ]; then
	(cd $extractdir/lib/modules/*; 
	rm -rf block ipv? misc net pcmcia fs *MODULES )
fi

# Tecra floppies won't have some scsi modules, as they don't fit on the
# drivers disk.
if [ "$revext" = tecra ]; then
	(cd $extractdir/lib/modules/*/scsi; 
	rm -rf 53c7,8xx.o AM53C974.o BusLogic.o NCR53c406a.o advansys.o \
		aha152x.o aha1542.o aha1740.o aic7xxx.o dtc.o \
		eata.o eata_dma.o eata_pio.o fdomain.o g_NCR5380.o gdth.o \
		in2000.o megaraid.o ncr53c8xx.o pas16.o \
		qlogicfas.o qlogicisp.o seagate.o t128.o tmscsim.o \
		u14-34f.o ultrastor.o wd7000.o
	)
fi
# creating modcont

(cd $extractdir;
	for i in lib/modules/*/*; do
		if [ -d  $i ]; then
			echo -n "dir_content_`basename $i`=\"";
			for j in $i/*.o; do
				echo -n `basename $j .o` " " ;
			done ;
			echo \" ;
		fi ;
	done
) > modcont$revext

# Adding the pcmcia-unconfigured
# If this is changed, it should reflect any changes in 
# utilities/dinstall/pcmcia.c
if [ -d $extractdir/lib/modules/$kernel_version/pcmcia ]; then
	touch $extractdir/lib/modules/$kernel_version/pcmcia/.unconfigured
fi
	
# creating modules.tgz
(cd $extractdir;tar clf - lib/modules|gzip -9) > modules$revext.tgz


# creating rescmods.tgz
# not used anymore

if [ "$revext" = "" ]; then
	(cd $extractdir/lib/modules/*;
		rm -rf block ipv? misc net pcmcia fs scsi *MODULES )

	(cd $extractdir;
		echo -n "rescue_content=\"" ;
		for i in `find lib/modules -name \*.o`; do
			echo -n `basename $i .o` " ";
		done ;
		echo \" ;
	) >> modcont$revext

#	(cd $extractdir;tar clf - lib/modules |gzip -9) > rescmods$revext.tgz
fi

#

cp $extractdir/boot/vmlinuz* linux$revext
cat $extractdir/boot/System.map-* | gzip -9 > sys_map$revext.gz
rm -rf $extractdir
