#!	/bin/sh

# Install the kernel modules and modconf tool from this boot floppy onto
# the root filesystem. The commands used by this script are limited to
# the ones available on the root floppy.
set -e
umask 022

if [ ! -f install.sh ]; then
	echo "Error: Change directory to the floppy before running this script." 1>&2
	exit -1
fi
FLOPPY=`pwd`

if [ $# -gt 0 ]; then
	DDIR=$1
	cd ${DDIR}
fi
zcat < ${FLOPPY}/modules.tgz | star
zcat < ${FLOPPY}/modconf.tgz | star
test -f /bin/sed || ln -sf `pwd`/bin/sed /bin/sed
test -f /usr/bin/whiptail || ln -sf `pwd`/usr/bin/whiptail /usr/bin/whiptail
if [ -e ${FLOPPY}/pcmcia.tgz ]; then
	zcat < ${FLOPPY}/pcmcia.tgz |star
	ln -si `pwd`/sbin/ifport /sbin/ifport
	ln -si `pwd`/sbin/ifuser /sbin/ifuser
	mv `pwd`/sbin/cardmgr /sbin/cardmgr
fi

sync
exit 0
