#!	/bin/sh
# Boot Disk maker for TFTP prototcol.
# Eric Delaunay, February 1998.
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
#set -e
set -x

# Print a usage message and exit if the argument count is wrong.
if [ $# != 4 ]; then
echo "Usage: "$0" linux system.map root-image debian-version" 1>&2
	cat 1>&2 << EOF

	linux: the Linux kernel (may be compressed).
	system.map: the map file (may by compressed).
	root-image: a compressed disk image to load in ramdisk and mount as root.
	debian-version: version of the Debian release.
EOF

	exit -1
fi

# Set this to the location of the kernel
kernel=$1

# Set this to the location of the kernel map file
sysmap=$2

# Set this to the location of the root filesystem image
rootimage=$3

#Set this to the Debian version
debianversion=$4

# Make sure the files are available.
if [ -f $kernel -a -f $sysmap -a -f $rootimage ]; then
	:
else
	echo "Can't find files: $kernel, $sysmap, $rootimage" 1>&2
	exit -1
fi

tmp=/var/tmp/tftpboot.$$
mkdir -p $tmp

# Do the actual work of making the kernel image bootable.

tftpimage=tftpboot.img

# 1/ uncompress it if needed
if file $kernel | grep gzip > /dev/null; then
	zcat $kernel > $tmp/image
else
	cp $kernel $tmp/image
fi

# 2/ convert it to aout format
if file $tmp/image | grep ELF > /dev/null; then
	elftoaout -o $tftpimage $tmp/image
	rm $tmp/image
else
	mv $tmp/image $tftpimage
fi

# 3/ uncompress the system.map file if needed
if file $sysmap | grep gzip > /dev/null; then
	zcat $sysmap > $tmp/system.map
	sysmap=$tmp/system.map
fi

# 4/ append rootimage to the kernel
piggyback $tftpimage $sysmap $rootimage

size=`ls -l $tftpimage | awk '{print $5}'`
rem=`expr \( 4 - $size % 4 \) % 4`
dd if=/dev/zero bs=1 count=$rem >> $tftpimage

ls -l $tftpimage

# cleanup
rm -fr $tmp
exit 0
