#include <stdio.h>
#include <glob.h>
#include <sys/mount.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include INCLINGUA

#ifndef _TESTING_
# ifndef _CTESTING_
#  define CM_MOUNTPOINT_DIR "/instmnt"
# else
#  define CM_MOUNTPOINT_DIR "instmnt"
# endif
#else
#define CM_MOUNTPOINT_DIR "instmnt"
#endif

int dirc=0;
char **dirv;
char *pattern;

#include <string.h>
#include <dirent.h>

/* ED: floppy filesystem type is not the same for all architectures */
#if #cpu(sparc) || #cpu(powerpc)
static char *fs_type_tab[] = {"ext2",NULL};
#else
static char *fs_type_tab[] = {"msdos","ext2",NULL};
#endif


extern int mount_one(char *blockDevice, char *directory, char *filesystemType, 
  unsigned long flags, char *string_flags, int noMtab, int fake);

int mount_and_check_floppy (char *device, const char *type, const char *text) {
  int status;
  FILE *tmpstream;
  struct stat statbuf;
  char **fs_type, *actualType=NULL;

#if #cpu (m68k)
  if (strcmp(Arch2, "VME") == 0) {
  	fs_type_tab[0] = "ext2";
	fs_type_tab[1] = NULL;
  }
#endif

  for (;;) {
    do_umount("/floppy",0);

    if (!device) {
      struct d_choices choices[3];
      char *dlist[3];
      int rs, items;

      items=0;
      if (strcmp(InstallationRootDevice,"/dev/fd0")) {
	choices[items].string=MSG_FLOPPY_FD0;
	choices[items].tag=NULL;
	choices[items].state=0;
	dlist[items]="/dev/fd0";
        items++;
      }
      if (strcmp(InstallationRootDevice,"/dev/fd1")) {
	choices[items].string=MSG_FLOPPY_FD1;
	choices[items].tag=NULL;
	choices[items].state=0;
	dlist[items]="/dev/fd1";
        items++;
      }
#ifdef SCSI_FLOPPY
      if (strcmp(InstallationRootDevice,"/dev/sfd0")) {
	choices[items].string=MSG_FLOPPY_SFD0;
	choices[items].tag=NULL;
	choices[items].state=0;
	dlist[items]="/dev/sfd0";
        items++;
      }
#endif
      sprintf(prtbuf,MSG_SELECT_FLOPPY_DRIVE, text);
      rs = menuBox(prtbuf, MSG_SELECT_FLOPPY_DISK_DRIVE, choices, items, 1);
      if (rs == -1)
        return -1;
      device=dlist[rs];
    }

    if (! strncmp(device,"/dev/fd",7)
#ifdef SCSI_FLOPPY
    ||  ! strncmp(device,"/dev/sfd",8)
#endif
    ){
      sprintf(prtbuf,MSG_PLACE_FLOPPY,text,
#ifdef SCSI_FLOPPY
        (device[5]=='s')?"SCSI":
#endif
         ((device[7]=='0')?MSG_FIRST:MSG_SECOND));
      if (twoButtonBox(prtbuf,MSG_PLEASE_INSERT_DISK,
			MSG_CONTINUE,MSG_CANCEL)==0) {
        return -1;
      }
    }
    
    for (fs_type=fs_type_tab;*fs_type;fs_type++) {
      if ( mount_one(device,"/floppy",*fs_type,MS_RDONLY,"\0",0,0) == 0)
        break;
    }
    if (!*fs_type) { // all mounts failed
      sleep(2); // let see error messages given by mount
      sprintf(prtbuf,MSG_UNABLE_TO_MOUNT,text);
      problemBox(prtbuf,MSG_MOUNT_FAILED);
      return -1;
    }

    if (! NAME_ISREG( "/floppy/type.txt", &statbuf ) ) {
      sprintf(prtbuf,MSG_WRONG_FLOPPY_L,text,text,
#ifdef SCSI_FLOPPY
       (device[5]=='s')?"SCSI":
#endif
        ((device[7]=='0')?MSG_FIRST:MSG_SECOND));
      problemBox(prtbuf,MSG_MOUNT_FAILED);
      device=NULL;
      continue;
    }
    if ((tmpstream=fopen("/floppy/type.txt","r"))==NULL) {
      perrorBox(MSG_CANNOT_OPEN_TYPE_TXT);
      continue;
    }
    actualType=(char *)malloc(10);
    status=fscanf(tmpstream,"%10s",actualType)-1;
    fclose(tmpstream);
    if(status) {
      perrorBox(MSG_CANNOT_READ_TYPE_TXT);
    } else {
      status=strcmp(type,actualType);
      if(status) {
        sprintf(prtbuf,MSG_WRONG_FLOPPY_L,text,text,
#ifdef SCSI_FLOPPY
         (device[5]=='s')?"SCSI":
#endif
          ((device[7]=='0')?MSG_FIRST:MSG_SECOND));
        problemBox(prtbuf,MSG_WRONG_FLOPPY);
      }
    }
    free(actualType);
    if (!status) {
      return 0;
    }
  }
}

int match_find(const struct FileInfo * i) {
  char *name,*source;
  struct stat statbuf;
  
  source=strdup(i->source);
  name=strrchr(source,'/');
  if (name) {
    *name='\0';
    name++;
  } else {
    name=source;
  }
  if (! strcmp(name,pattern) ) {
    sprintf(prtbuf,"%s/%s",source,drivers_image_filename);
    if ( ( disqtype == base ) || 
         (NAME_ISREG( prtbuf,&statbuf)) ) {
      if ( (dirc) && (!(dirc%5)) ) 
        dirv=(char**)realloc(dirv,(dirc+5)*sizeof(char *));
      dirv[dirc]=strdup(source);
      dirc++;
    }
  }
  free(source);
  return 0;
}

static int choose_archive_dir (char *text) {
  char *mountpoint, *descr, *path=NULL, *def, *inputdir;
  static char *preventry=NULL;
/*  glob_t globbuf; */
  struct stat statbuf;
  struct FileInfo finfo;
#define ARC_default     100
#define ARC_list        101
#define ARC_manually    102
  struct d_choices ochoices[3]={ {NULL,MSG_DEFAULT_ARCHIVE,0},
    {NULL,MSG_CHOOSE_FROM_LIST,0}, {NULL,MSG_ENTER_DIR,0} }, *choices;
  int olist[3]={ ARC_default, ARC_list, ARC_manually }, *ilist;
  int status,items=2;
  choices=&ochoices[1]; 
  ilist=&olist[1];

  if (text==NULL) {
    text=MSG_CHOOSE_DIR;
    mountpoint="";
  } else {
    mountpoint=CM_MOUNTPOINT_DIR;
  }
  /* keep user entry between calls to choose_archive_dir */
  if (!preventry) preventry=strdup("/debian");
  for (;;) {
    path=inputBox(text,MSG_CHOOSE_PATH,preventry);
    if (! path) return 1;
    free(preventry);
    preventry=path;
    sprintf(prtbuf,"%s/%s",mountpoint,(path[0]=='/')?path+1:path);
    if ( NAME_ISDIR(prtbuf,&statbuf)) break;
  }
  mountpoint=strdup(prtbuf);

  switch (disqtype) {
    case kernel:
      /* this could be a wildcard pattern but no multiple match */
      pattern=kernel_image_filename;
      descr=MSG_KERNEL_AND_MODULES;
      break;
    default:
      pattern=BASETGZ;
      descr=MSG_THE_BASE_SYSTEM;
      break;
  }

  def=NULL;

/* FIXME. This isn't working fine yet.
**
**  sprintf(prtbuf,"%s/dists/""*""/main/disks-%s/current",mountpoint,ARCHNAME);
**  globbuf.gl_offs = 0;
**  i=glob( prtbuf, 0, NULL, &globbuf); 
**  if ( i != GLOB_NOMATCH ) {
**    for (i=0;i<globbuf.gl_pathc;i++) {
**      sprintf(prtbuf,"%s/%s",globbuf.gl_pathv[i],pattern);
**      if (NAME_ISREG( prtbuf,&statbuf)) {
**        sprintf(prtbuf,"%s/%s",globbuf.gl_pathv[i],DRVDISKIMG);
**        if ( (disqtype != kernel) ||
**             (NAME_ISREG( prtbuf,&statbuf)) ){
**          def=strdup(globbuf.gl_pathv[i]);
**          break;
**        }
**      } 
**    }
**  }
**  globfree(&globbuf);
**
*/

  sprintf(prtbuf,"%s/stable/main/disks-%s/current/%s",mountpoint,ARCHNAME,
      pattern);
  if (NAME_ISREG( prtbuf,&statbuf)) {
    sprintf(prtbuf,"%s/stable/main/disks-%s/current/%s",mountpoint,ARCHNAME,
        drivers_image_filename);
    if ( (disqtype != kernel) || (NAME_ISREG( prtbuf,&statbuf)) ){
      sprintf(prtbuf,"%s/stable/main/disks-%s/current",mountpoint,ARCHNAME);
      def=strdup(prtbuf);
    }
  }
  if (def) {
    sprintf(prtbuf,MSG_SELECT_DIR2,pattern,descr);
    choices--;
    ilist--;
    items++;
  } else
    sprintf(prtbuf,MSG_SELECT_DIR, pattern,descr);
  
  status = menuBox(prtbuf, MSG_SELECT_PATH, choices, items, 1);
  if ( status != -1) {
    int data;
    data = ilist[status];
    status = 0;

    switch (data) {
      case ARC_default:
        Archive_Dir=strdup(def);
        free(def);
        break;
      case ARC_list:
	/*
	 * Build the list.
	 */
	sprintf(prtbuf,MSG_BUILDING_LIST,pattern,descr);
	pleaseWaitBox(prtbuf);
	dirc=0;
	dirv=(char **)malloc(5*sizeof(char *));
	memset((void *)&finfo, 0, sizeof(struct FileInfo));
	finfo.source=strdup(mountpoint);
	stat(finfo.source,&finfo.stat);
	finfo.processDirectoriesAfterTheirContents=1;
	descend(&finfo,match_find);
	boxPopWindow();

	/*
	 * List menu
	 */
	if (dirc>0) {
	  int i;
	  struct d_choices *nchoices;
	  nchoices=calloc(dirc,sizeof(struct d_choices));
          for (i=0;i<dirc;i++) {
	    /* This shortens paths that are too long to be displayed. */
	    if(strlen(dirv[i])>56-3-2) /* text - left - 2 */
	      {
	        strcpy(prtbuf,"...");
	        strcat(prtbuf+3,dirv[i]+strlen(dirv[i])-56+3+3);
	      }
	    else
	      strcpy(prtbuf,dirv[i]);
	    nchoices[i].string=strdup(prtbuf);
          }
          sprintf(prtbuf, MSG_SELECT_DIR_USE,descr);
          status = menuBox(prtbuf, MSG_SELECT_PATH, nchoices, dirc, 1);
	  if ( status != -1 ) {
            Archive_Dir= strdup(dirv[status]);
	    status = 0;
          }
          while(dirc) {
            dirc--;
            free(dirv[dirc]);
	    free(nchoices[dirc].string);
          }
          free(dirv);
	  free(nchoices);
	} else {
	  sprintf(prtbuf,MSG_COULDNT_FIND_DIR,pattern);
          problemBox(prtbuf,MSG_FILE_NOT_FOUND);
          status = -1;
	}
        break;
      case ARC_manually:
        sprintf(prtbuf,MSG_ENTER_ARCHIVE_DIR,mountpoint);
        inputdir=inputBox(prtbuf,MSG_ENTER_ARCHIVE_DIR_T,mountpoint);
        if (! inputdir) {
          status = -1;
        } else {
	  Archive_Dir=inputdir;
          sprintf(prtbuf,"%s/%s",Archive_Dir,pattern);
          if (! NAME_ISREG(prtbuf,&statbuf)) {
            sprintf(prtbuf,MSG_NOT_CONTAIN_FILE,Archive_Dir,pattern,descr);
            problemBox(prtbuf,MSG_FILE_NOT_FOUND);
            status = -1;
          } else {
            sprintf(prtbuf,"%s/%s",Archive_Dir,drivers_image_filename);
            if ( (disqtype == kernel) &&
                 (! NAME_ISREG(prtbuf,&statbuf)) ) {
              sprintf(prtbuf,MSG_NOT_CONTAIN_FILE,Archive_Dir,drivers_image_filename,descr);
              problemBox(prtbuf,MSG_FILE_NOT_FOUND);
              status = -1;
            }
          }
        }
        break;
    }
  }
  free(mountpoint);
  return status;
}


static int choose_cdrom (void) {
  char *devs[10]={"/dev/scd0","/dev/hda","/dev/hdb","/dev/hdc","/dev/hdd",
       "/dev/hde","/dev/hdf","/dev/hdg","/dev/hdh","propietary"},*device;
  struct d_choices choices[10]={ {NULL,MSG_CD_SCSI,0}, {NULL,MSG_CD_HDA,0},
	{NULL,MSG_CD_HDB,0}, {NULL,MSG_CD_HDC,0}, {NULL,MSG_CD_HDD,0},
	{NULL,MSG_CD_HDE,0}, {NULL,MSG_CD_HDF,0}, {NULL,MSG_CD_HDG,0},
	{NULL,MSG_CD_HDH,0}, {NULL,MSG_CD_PROPIETARY,0}
  };
  int status,items=9;

  if ( (no_match("/target/lib/modules","cdrom",S_IFDIR)) == 0 ) {
    items=10;
  }
  status = menuBox(MSG_SELECT_CD_TYPE, MSG_SELECT_CD_TYPE_T, choices, items, 1);
  if ( status == -1 ) {
    return -1;
  }
  device=devs[status];

  if (!strncmp(device,"/dev",4)) {
    if (!strcmp(device,"/dev/scd0")) {
      if (no_match("/proc/scsi","0",S_IFREG)) {
        problemBox(MSG_NO_CD_SCSI,MSG_NO_CD_SCSI_T);
      }
    }
    chdir("/dev");
    unlink("cdrom");
    symlink(device,"cdrom");
  } else {
    /* propietary */
    boxSuspend();
    system("depmod -a ; /target/usr/sbin/modconf "
           " --libdir /target/usr/lib/module_help --restrict-section cdrom"
           " --target /target --run-shell cdromsymlink");
    if (strncmp(real_kver,"2.0",3)) {
      /* not on 2.0 kernels:
       * workaround for serial consoles (/dev/tty is not avail) */
      strcat(prtbuf," --tty /dev/console");
    }
    boxResume();
  }

  problemBox(MSG_PLACE_CD,MSG_PLACE_CD_T);
  do_umount(CM_MOUNTPOINT_DIR,0);
  if (system("mount -t iso9660 -o nojoliet -r /dev/cdrom " CM_MOUNTPOINT_DIR)) {
/* FIXME   write_it_down "The CD-ROM was not mounted successfully." */
    problemBox(MSG_CD_FAILED,MSG_MOUNT_FAILED);
    return 1;
  }
  if ((status=choose_archive_dir(MSG_CHOOSE_PATH_CD))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

static int choose_harddisk(void) {
  struct fdisk_partition *p;
  int status;
  char *type;

  do_umount(CM_MOUNTPOINT_DIR,0);
  p=select_not_mounted(MSG_SELECT_PARTITION_ARCHIVE,MSG_SELECT_PARTITION,
	5,FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS);
  if (!p) return 1;

  type = fdisk_fstype_name_of(p->type);
  if (!type) {
    sprintf(prtbuf,MSG_FILESYSTEM_UNKNOW,sysname(p->type));
    problemBox(prtbuf,MSG_CANNOT_MOUNT);
    return 1;
  }
  sprintf(prtbuf,"mount -t %s -r %s " CM_MOUNTPOINT_DIR,type,p->name);
  if (system(prtbuf)) {
/* FIXME   write_it_down "The Partition was not mounted successfully." */
    problemBox(MSG_MOUNT_FAILED_L,MSG_MOUNT_FAILED);
    return 1;
  }
  if ((status=choose_archive_dir(MSG_CHOOSE_PATH_HD))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

static int choose_NFS_server(void){
  char *nfsmountpath;
  static char *preventry=NULL;
  int status;

  sprintf(prtbuf,"modprobe nfs");
  system(prtbuf);
  for (;;) {
    /* keep user entry between calls to choose_NFS_server */
    if (!preventry) preventry=strdup("");
    nfsmountpath=inputBox(MSG_CHOOSE_NFS,MSG_CHOOSE_NFS_T,preventry);
    if (! nfsmountpath) return 1;
    free(preventry);
    preventry=nfsmountpath;
    do_umount(CM_MOUNTPOINT_DIR,0);
    sprintf(prtbuf,"mount -t nfs %s " CM_MOUNTPOINT_DIR,nfsmountpath);
    if (system(prtbuf)) {
/* FIXME:                     write_it_down */
      sprintf(prtbuf,MSG_MOUNT_FAILED_NFS,nfsmountpath);
      problemBox(prtbuf,MSG_MOUNT_FAILED_NFS_T);
    } else {
      break;
    }
  }
  if ((status =choose_archive_dir(MSG_CHOOSE_PATH_NFS))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

int choose_medium (void) {
  struct stat statbuf;
  char *old_archive_dir;
#define MED_none          100
#define MED_default       101
#define MED_fd0           102
#define MED_fd1           103
#define MED_cdrom         104
#define MED_harddisk      105
#define MED_mounted       106
#define MED_nfs           107
#define MED_sfd0          108
#define NITEMS 8
  int old_medium_device, offer_default=0, items=0, status=0, ilist[NITEMS];
  static int Medium_Device=MED_none;
  struct d_choices choices[NITEMS];

  memset(choices,0,NITEMS*sizeof(struct d_choices));

  if (Archive_Dir) {
    switch (disqtype) {
      case kernel:
        sprintf(prtbuf,"%s/%s",Archive_Dir,kernel_image_filename);
        if (NAME_ISREG( prtbuf,&statbuf)) {
          sprintf(prtbuf,"%s/%s",Archive_Dir,drivers_image_filename);
          if (NAME_ISREG( prtbuf,&statbuf)) offer_default=1;
        }
        break;	
      case base:
        sprintf(prtbuf,"%s/%s",Archive_Dir,BASETGZ);
        if (NAME_ISREG( prtbuf,&statbuf)) offer_default=1;
        break;	
    }
    if (offer_default) {
      choices[items].string=MSG_DEFAULT_PREVIOUS;
      ilist[items]=MED_default;
      items++;
    }
  }
  if (strcmp(InstallationRootDevice,"/dev/fd0")) {
    choices[items].string=MSG_FLOPPY_FD0;
    ilist[items]=MED_fd0;
    items++;
  }
  if (strcmp(InstallationRootDevice,"/dev/fd1")) {
    choices[items].string=MSG_FLOPPY_FD1;
    ilist[items]=MED_fd1;
    items++;
  }
#ifdef SCSI_FLOPPY
  if (strcmp(InstallationRootDevice,"/dev/sfd0")) {
    choices[items].string=MSG_FLOPPY_SFD0;
    ilist[items]=MED_sfd0;
    items++;
  }
#endif
  choices[items].string=MSG_MENU_MEDIUM_CD;
  ilist[items]=MED_cdrom;
  items++;
  choices[items].string=MSG_MENU_MEDIUM_HD;
  ilist[items]=MED_harddisk;
  items++;
  choices[items].string=MSG_MENU_MEDIUM_MOUNT;
  ilist[items]=MED_mounted;
  items++;
#ifndef _TESTING_
  if (is_network_configured()) {
#else
  if (1) {
#endif
    choices[items].string=MSG_MENU_MEDIUM_NFS;
    ilist[items]=MED_nfs;
    items++;
  }
  status = menuBox(MSG_SELECT_MEDIUM, MSG_SELECT_MEDIUM_T, choices, items, 1);
  if ( status == -1 ) {
    return -1;
  }
  old_medium_device= Medium_Device;
  Medium_Device = ilist[status];

  old_archive_dir=Archive_Dir;
  switch (Medium_Device) {
    case MED_default:
      Medium_Device=old_medium_device;
      return 0;
    case MED_fd0:
      Archive_Dir=strdup("/dev/fd0");
      status = 0;
      break;
    case MED_fd1:
      Archive_Dir=strdup("/dev/fd1");
      status = 0;
      break;
#ifdef SCSI_FLOPPY
    case MED_sfd0:
      Archive_Dir=strdup("/dev/sfd0");
      status = 0;
      break;
#endif
    case MED_mounted:
      status=choose_archive_dir(NULL);
      break;
    case MED_cdrom:
      status=choose_cdrom();
      break;
    case MED_harddisk:
      status=choose_harddisk();
      break;
    case MED_nfs:
      status=choose_NFS_server();
      break;
  }
  if (status==0) free(old_archive_dir);
  return status;
}

#ifdef DO_EJECT
int do_eject (void) {
#define EJ_none          -1
#define EJ_fd0           0
#define EJ_fd1           1
  struct d_choices ch[2]={ {NULL,MSG_FLOPPY_FD0,0}, {NULL,MSG_FLOPPY_FD1,0} };
  static int Eject_Device=EJ_none;

  Eject_Device = 
	  menuBox(MSG_SELECT_DISK2EJECT, MSG_SELECT_DISK2EJECT_T, ch, 2, 1);
  if ( Eject_Device == -1) {
    return -1;
  }

  switch (Eject_Device) {
    case EJ_fd0:
      eject_floppy("/dev/fd0");
      break;
    case EJ_fd1:
      eject_floppy("/dev/fd1");
      break;
  }
  return 0;
}
#endif

#ifdef _CTESTING_
/*
 * To test, compile using: make choose_medium_test
 */
char *real_kver = KVER;
char *drivers_image_filename;
char *kernel_image_filename;
void main(void) {
  Archive_Dir=NULL;
  disqtype=base;
  InstallationRootDevice=strdup("/dev/sdc");
  initScreen("Choose Medium test program");
  if ( choose_medium() ) {
    fprintf(stderr,"\nFailed!\n");
  } else {
    fprintf(stderr,"\nArchive_Dir = %s\n",Archive_Dir);
  }  
  if ( choose_medium() ) {
    fprintf(stderr,"\nFailed!\n");
  } else {
    fprintf(stderr,"\nArchive_Dir = %s\n",Archive_Dir);
  }  
  finishScreen();
  free(Archive_Dir);
}
#endif

