#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/fd.h>
#include "../floppy_split.h"
#include "dinstall.h"
#include INCLINGUA

#ifdef _TESTING_
  #define TEMPFILE "/tmp/buff"
#else
  #define TEMPFILE "/target/tmp/buff"
#endif

#define    HEADER_SIZE    512
static const char    magic[] = "Floppy split";

static const char bad_floppy_message[] = MSG_BAD_FLOPPY;

static int
readFloppy(int fd_in, int fd_out, struct floppy_header * h)
{
    long            bytesInThisFloppy = atol(h->bytesInThisFloppy);
    long            bytesToRead = bytesInThisFloppy;
    long            bytesRead = 0;
    unsigned long   originalChecksum = strtoul(h->checksum, 0, 0x10);
    unsigned long   checksum = 0;
    int             fd_tmp,byte = 0;
    long     status=0;
    char    buf[20 * 1024];
        
    if ( (fd_tmp = creat(TEMPFILE, S_IRUSR | S_IWUSR )) < 0 ) {
        perrorBox(MSG_CANNOT_OPENW_TEMPFILE);
        return (-2);
    }
    
    scaleBox(prtbuf, MSG_READIND_DISK, (long long)bytesInThisFloppy, 0);

    while ( bytesToRead > 0 ) {
        long    chunk = sizeof(buf);

        if ( bytesToRead < chunk )
            chunk = bytesToRead;

        errno = 0;
        if ( (status = read(fd_in, buf, chunk)) < chunk ) {
            int     old_errno = errno;
            if ( old_errno == 0 && read(fd_in, buf, 1) != 1 )
                old_errno = errno;
            if ( old_errno == 0 )
                problemBox(MSG_FLOPPY_EOF_ERROR, MSG_FLOPPY_ERROR);
            else
                perrorBox(MSG_FLOPPY_READ_ERROR);
	    status=-1;
	    break;
        }

        bytesRead += chunk;
        bytesToRead -= chunk;

        scaleBox(NULL, NULL, (long long)bytesRead, 1);

        for ( byte = 0; byte < chunk; byte++ )
            checksum += (buf[byte] & 0xff);

        if ( (status = write(fd_tmp, buf, chunk)) != chunk ) {
            perrorBox(MSG_ERROR_WRITING_TEMPFILE);
	    status=-1;
	    break;
        }
    }
    scaleBox(NULL, NULL, 0, 2);
    close(fd_tmp);
    if (status==-1) {
        unlink(TEMPFILE);
        return (-1);
    }
    if ( checksum != originalChecksum ) {
        problemBox(MSG_FLOPPY_CHECKSUM_ERROR,MSG_FLOPPY_ERROR);
        unlink(TEMPFILE);
        return (-1);
    }

    if ( (fd_tmp = open(TEMPFILE, O_RDONLY)) < 0 ) {
        perrorBox(MSG_CANNOT_OPENR_TEMPFILE);
        return (-2);
    }
    while ( status > 0 ) {
        if ( (status = read(fd_tmp, buf, sizeof(buf))) < 0) {
            perrorBox(MSG_ERROR_READING_TEMPFILE);
	    status=-2;
	    break;
        }
        if ( write(fd_out, buf, status) != status ) {
            perrorBox(MSG_ERROR_WRITING_OUTPUT_FILE);
            status=-2;
            break;
        }
    }
    close(fd_tmp);
    unlink(TEMPFILE);
    return(status);
}

int getFloppies(const char * device, const char * filename) {
    int		expectedDisk = 1;
    int		totalFloppies = 0;
    char	name[1024];
    int		fd_in=-1, fd_out;

    if (filename) {
        if ( (fd_out = creat(filename, S_IRUSR | S_IWUSR )) < 0 ) {
            perrorBox(filename);
	    return 1;
        }
    } else 
        fd_out=1;

    for ( ; ; ) {
        union header_block    block;
        int	diskNumber = 0;
        int	diskTotalFloppies;
        int	status;

        if (fd_in > 0) close(fd_in);

        sprintf(prtbuf,MSG_INSTALL_INSERT_DISK_L,
#ifdef SCSI_FLOPPY
        (device[5]=='s')?"SCSI":
#endif
          ((device[7]=='0')?MSG_FIRST:MSG_SECOND),expectedDisk);
	if (twoButtonBox(prtbuf,MSG_INSERT_DISK,MSG_CONTINUE,MSG_CANCEL)==0) {
	  close(fd_out);
	  return 1;
	}

        if ( (fd_in = open(device, O_RDONLY)) < 0 ) {
            eject_floppy(device);
            perrorBox(device);
            continue;
        }

#ifdef SCSI_FLOPPY
    if (strncmp(device,"/dev/sfd",8)) /* not scsi floppy */
#endif
        if ( ioctl(fd_in, FDFLUSH, 0) != 0 )
            perrorBox(MSG_IOCTL_FAILED);

        if ( (status = read(fd_in,(char*)&block,HEADER_SIZE)) != HEADER_SIZE) {
            eject_floppy(device);
            if ( status > 0 )
                problemBox(MSG_CANNOT_READ_EOF_ERROR,MSG_FLOPPY_ERROR);
            else
                perrorBox(MSG_CANNOT_READ_FLOPPY);
            continue;
        }
        if ( strncmp(block.header.magic, magic, sizeof(magic) - 1) != 0 ) {
            eject_floppy(device);
            problemBox(MSG_WRONG_FLOPPY_L2,MSG_WRONG_FLOPPY);
            continue;
        }
        
        diskNumber = atoi(block.header.floppyNumber);
        diskTotalFloppies = atoi(block.header.totalFloppies);
        sprintf(prtbuf,MSG_DISK_SERIES,
          diskNumber, diskTotalFloppies, block.header.name, block.header.date);
	status=strlen(prtbuf);
        if ( diskNumber != expectedDisk ) {
            eject_floppy(device);
            sprintf(prtbuf+status,MSG_WRONG_DISK_L
              ,expectedDisk);
	    problemBox(prtbuf,MSG_WRONG_DISK);
            continue;
        }
        if ( diskNumber == 1 ) {
            strcpy(name, block.header.name);
            totalFloppies = diskTotalFloppies;
        }
        else if ( strcmp(name, block.header.name) != 0 ) {
            eject_floppy(device);
            sprintf(prtbuf+status,MSG_WRONG_DISK_L2,
              block.header.name, expectedDisk, name);
	    problemBox(prtbuf,MSG_WRONG_DISK);
            continue;
        }
        status=readFloppy(fd_in, fd_out, &block.header);
#ifdef SCSI_FLOPPY
    if (strncmp(device,"/dev/sfd",8)) /* not scsi floppy */
#endif
        ioctl(fd_in, FDFLUSH, 0);
        close(fd_in);
        eject_floppy(device);
        fd_in=-1;
	if (status==0) {
	  expectedDisk++;
	} else if (status==-2) {
	  break;
	}
        if (expectedDisk > totalFloppies) break;
    }
    close(fd_out);
    return 0;
}

#ifdef _TESTING_
/*
 * To test, compile using: make floppy_merge_test
 */

void main(void) {
	initScreen("Floppy Merge test program");

	getFloppies("/dev/loop1","/tmp/testing.tgz");

	finishScreen();
}
#endif
