#include <stdio.h>
#include <glob.h>
#include "dinstall.h"

int no_match(const char *path, const char *name, __mode_t mode){
  int i,status;
  glob_t globbuf;
  struct stat statbuf;
  snprintf(prtbuf,PRTBUFSIZE,"%s/*/%s",path,name);
  glob( prtbuf, GLOB_NOSORT, NULL, &globbuf);
  status=1;
  if ( globbuf.gl_pathc > 0 ) {
    for (i=0;i<globbuf.gl_pathc;i++) {
      if ( (! stat(globbuf.gl_pathv[i],&statbuf) ) &&
           ( (statbuf.st_mode & S_IFMT) == mode ) )  {
        status=0;
        break;
      }
    }
  }
  globfree(&globbuf); 
  return status;
}
