#include <signal.h>
#include "dinstall.h"
#include INCLINGUA
#ifdef _TESTING_
  #include <stdio.h>
#endif

int reboot_system (void) {
  sync();
  if (strcmp(InstallationRootDevice,"/dev/fd0")) {      
    if (! yesNoBox(MSG_REBOOT_SYSTEM_L, MSG_REBOOT_SYSTEM) ) return 1;
  } else {
    if (! yesNoBox(MSG_REBOOT_SYSTEM_NO_RAMDISK_L, MSG_REBOOT_SYSTEM) ) return 1;
  }
  sync();
  boxSuspend();
#ifdef _TESTING_
  printf("Fake rebooting... (waiting 15 secs)\n");
#else
  kill(1, SIGUSR2);
#endif
  sleep(15);
  boxResume();
  return 1;
}

#ifdef _TESTING_
/* To test, compile using: make reboot_system_test */
void main(void){
	initScreen("Reboot System test program");

	InstallationRootDevice=strdup("/dev/sdc");
	reboot_system();

	finishScreen();
}
#endif
