/* 
   linking.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "config.h"

#include <eoaccess/common.h>
#include <eoaccess/EOModel.h>
#include <eoaccess/EOExpressionArray.h>
#include <eoaccess/EOPrimaryKeyDictionary.h>
#include <eoaccess/EOSQLExpression.h>
#include <eoaccess/EOAttributeOrdering.h>
#include <eoaccess/EOQuotedExpression.h>

#define BUNDLE_AVAILABLE 1

#ifndef BUNDLE_AVAILABLE

#ifdef SYBASE_DATABASE
# include <eoadaptors/Sybase/SybaseAdaptor.h>
#endif

#ifdef SQLSERVER_DATABASE
# include <eoadaptors/SQLServer/SQLServerAdaptor.h>
#endif

#ifdef POSTGRES95_DATABASE
# include <eoadaptors/Postgres95/Postgres95Adaptor.h>
#endif

#endif /* BUNDLE_AVAILABLE */

static void __dummy(void)
{
    [GCArray new];
    [GCDictionary new];
    [EOModel new];
    [EOExpressionArray new];
    [EOPrimaryKeyDictionary new];
    [EOSQLExpression new];
    [EOAttributeOrdering new];
    [EOQuotedExpression new];
#ifndef BUNDLE_AVAILABLE

# ifdef SYBASE_DATABASE
    [SybaseAdaptor new];
# endif /* SYBASE_DATABASE */

# ifdef SQLSERVER_DATABASE
    [SQLServerAdaptor new];
# endif /* SQLSERVER_DATABASE */

# ifdef POSTGRES95_DATABASE
    [Postgres95Adaptor new];
# endif /* POSTGRES_DATABASE */

#endif /* BUNDLE_AVAILABLE */

#if NeXT
{
    extern void gethostbyname();
    extern void sys_errlist();
    extern void sys_nerr();

    gethostbyname();
    send(0, 0, 0, 0);
    setsockopt(0, 0, 0, 0, 0);
    sys_errlist();
    sys_nerr();
    dup(0);
    fdopen(0, 0);
    fputs(0, stderr);
    ioctl(0, 0, 0);
    isatty(0);
    pclose(stderr);
    popen(0, 0);
    sigblock(0);
    sigsetmask(0);
}
#endif

    __dummy();
}
