.ifdef INITIALIZE_MMS

all ::

.else

CXXSRCS = t_string.cc t_seq_long.cc t_seq_string.cc \
          t_objref.cc t_seq_objref.cc \
          client.cc server.cc 

.first
	@ $(FIRSTACTIONS)
	@ define/nolog common [-.common]

.default
	@ !

# The stub of seq1 takes a long time and lots of resources to compile with
# optimisation. Set CXXDEBUGFLAGS to null to remove the optimisation flag.
#!!!CXXDEBUGFLAGS =

COMMON_OBJS = [-.common]common$(DebugSuffix).olb

CORBA_INTERFACES = echo seq2 seq3 seq4 seq5 seq6 seq7 seq8 seq9 seq10 \
                   seq1 shutdown
CORBA_STUB_OBJS = $(CORBA_STUB_DIR)echoSK.obj\
,$(CORBA_STUB_DIR)seq2SK.obj\
,$(CORBA_STUB_DIR)seq3SK.obj\
,$(CORBA_STUB_DIR)seq4SK.obj\
,$(CORBA_STUB_DIR)seq5SK.obj\
,$(CORBA_STUB_DIR)seq6SK.obj\
,$(CORBA_STUB_DIR)seq7SK.obj\
,$(CORBA_STUB_DIR)seq8SK.obj\
,$(CORBA_STUB_DIR)seq9SK.obj\
,$(CORBA_STUB_DIR)seq10SK.obj\
,$(CORBA_STUB_DIR)seq1SK.obj\
,$(CORBA_STUB_DIR)shutdownSK.obj

OBJ_LIBS = $(COMMON_OBJS) $(CORBA_LIB)
OBJ_LIB_DEPEND = $(CORBA_STUB_OBJS) $(COMMON_OBJS) $(CORBA_LIB_DEPEND)

t_string      = t_string$(DebugSuffix).exe
t_seq_long    = t_seq_long$(DebugSuffix).exe
t_seq_string  = t_seq_string$(DebugSuffix).exe
t_objref      = t_objref$(DebugSuffix).exe
t_seq_objref  = t_seq_objref$(DebugSuffix).exe
client        = client$(DebugSuffix).exe
server        = server$(DebugSuffix).exe

all :: $(CORBA_STUB_OBJS) $(client) $(server)

all :: $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref) $(t_seq_objref)

$(CORBA_STUB_OBJS) ::
	$(BuildCorbaStubs)

t_string.obj : t_string.cc
t_seq_long.obj : t_seq_long.cc
t_seq_string.obj : t_seq_string.cc
t_objref.obj : t_objref.cc
t_seq_objref.obj : t_seq_objref.cc
client.obj : client.cc
server.obj : server.cc

$(t_string) : t_string.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(t_seq_long) : t_seq_long.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(t_seq_string) : t_seq_string.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(t_objref) : t_objref.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(t_seq_objref) : t_seq_objref.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(client) : client.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

$(server) : server.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable) $(CORBA_STUB_OBJS)

clean ::
	@ $(RM) $(client) $(server)
	@ $(RM) $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref)
	@ $(RM) $(t_seq_objref)

.endif
