// Testing code: client of Texcept objects
//
//   exception Terrmsg {
//         string msg;
//   };
//
//   interface Texcept {
//         void trigger(in boolean yes) raises(Terrmsg);
//   };

#include <iostream.h>
#include <tstexcept.hh>
#include <common/common.h>
#include <stdlib.h>

int
main (int argc, char **argv) {

  try {

    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

    CORBA::Object_var obj;

    switch (argc) {
    case 2:
      {
	try {
	  CosNaming::Name use_name = string_to_name(argv[1]);
	  obj = getObjectReference(orb,use_name);
	}
	catch (...) {
	  obj = CORBA::Object::_nil();
	}
	if (CORBA::is_nil(obj)) {
	  cerr << "Cannot resolve compound name to an object reference."
	       << endl;
	  return 1; 
	}
	break;
      }
    case 3:
      if (strcmp(argv[1],"-i") == 0) {
	obj = orb->string_to_object(argv[2]);
	if (CORBA::is_nil(obj)) {
	  cerr << "Cannot convert stringified IOR to an object reference."
	       << endl;
	  return 1;
	}
	break;
      }
    default:
      cerr << "usage: tstexceptclt -i <stringified IOR>" << endl;
      cerr << "       tstexceptclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	   << endl;
      return 1;
    }

    Texcept_ptr e = Texcept::_narrow(obj);

    if (CORBA::is_nil(e))
      {
	cerr << "Can't create proxy.\n" << endl;
	return(1);
      }

    int loopcount = 10;
    while (loopcount--) {
      CORBA::Boolean yes = rand() % 2;

      if (yes) {
	try {
	  e->trigger(yes);
	}
	catch (Terrmsg &ex) {
	  cerr << "Caught Texcept: " << (const char*)ex.msg << endl;
	}
      }
      else {
	e->trigger(yes);
      }
    }

    CORBA::release(e);

  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  catch (const omniORB::fatalException &ex) {
    cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
    cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
    cerr << "main thread exited." << endl;
  }
  return 0;
}
