// -*- Mode: C++; -*-
//                            Package   : omniORB2
// t_objref.cc                Created on: 06/12/96
//                            Author    : Sai Lai Lo (sll)
//
// Copyright (C) Olivetti Research Limited, 1996
//
// Description:
//	This module contains omniORB2 specific code and may not be
//      usuable without modification for testing other ORBs.
 
/*
  $Log$
  */

#include <echo.hh>
#include <iostream.h>

typedef _CORBA_ObjRef_Member<Echo,Echo_Helper> Echo_member;

static
const char* test_ior1 = "IOR:000000000000000d49444c3a4563686f3a312e3000051160000000010000000000000028000100000000000d3139322e352e3233392e363100208fec0000000c000000000000000000000004";

static
const char* test_ior2 = "IOR:000000000000000d49444c3a4563686f3a312e3000051160000000010000000000000028000100000000000d3139322e352e3233392e363100208fec0000000c000000000000000000000003";

static
CORBA::ORB_ptr orb;

// test_objref_f
//	This function's signature corresponds to the mapping of this
//	OMG IDL operatoin:
//		Echo test_objref_f(in Echo a1,
//				   inout Echo a2,
//				   out Echo a3);
//
static
Echo_ptr
__test_objref_f(Echo_ptr in, Echo_ptr& inout, Echo_ptr& out)
{
  assert(in->_is_equivalent(inout));

  CORBA::Object_ptr obj = orb->string_to_object(test_ior2);
  Echo_ptr e = Echo::_narrow(obj);
  CORBA::release(obj);
  
  CORBA::release(inout);
  out = e;
  inout = Echo::_duplicate(e);
  return Echo::_duplicate(e);
}

static
Echo_ptr
test_objref_f(Echo_ptr in,
      	      _CORBA_ObjRef_INOUT_arg<Echo,Echo_var,
	                              _CORBA_ObjRef_Member<Echo,Echo_Helper> > inout,
	      _CORBA_ObjRef_OUT_arg<Echo,Echo_var,
	                            _CORBA_ObjRef_Member<Echo,Echo_Helper>,
	                            Echo_Helper> out) 
{
  return __test_objref_f(in,inout._data,out._data);
}



static
void
test_objref_1()
{
  // Testing object _var class
  CORBA::Object_ptr obj = orb->string_to_object(test_ior1);
  Echo_ptr e = Echo::_narrow(obj);
  CORBA::release(obj);

  cerr << "### ctor Echo_var()" << endl;
  Echo_var e_var1;	// ctor Echo_var()
  assert(CORBA::is_nil(e_var1));

  cerr << "### ctor Echo_var(Echo_ptr)" << endl;
  Echo_var e_var2(e);	// ctor Echo_var(Echo_ptr)
  assert(!CORBA::is_nil(e_var2));

  cerr << "### ctor Echo_var(const Echo_var &)" << endl;
  Echo_var e_var3(e_var2); // ctor Echo_var(const Echo_var &)
  assert(e_var2->_is_equivalent(e_var3));

  obj = orb->string_to_object(test_ior2);
  e = Echo::_narrow(obj);
  CORBA::release(obj);

  cerr << "### Echo_var& operator= (Echo_ptr)" << endl;
  Echo_var e_var4;
  e_var4 = e;                    // Echo_var& operator= (Echo_ptr)
  assert(!CORBA::is_nil(e_var4));
  assert(!e_var4->_is_equivalent(e_var3));
  Echo_ptr ep = e_var3;

  cerr << "### Echo_var& operator= (const Echo_var&)" << endl;
  Echo_var e_var5 = e_var4;	// Echo_var& operator= (Echo_var&)
  assert(!CORBA::is_nil(e_var5));
  assert(e_var5->_is_equivalent((Echo_ptr)e_var4));
  
  e_var5 = e_var3;
  assert(!e_var5->_is_equivalent((Echo_ptr)e_var4));
  assert(e_var5->_is_equivalent((Echo_ptr)e_var3));

  cerr << "### test_objref_f()" << endl;
  Echo_var e_var6;
  Echo_var e_var7;
  e_var7 = test_objref_f(e_var3,e_var5,e_var6);
  assert(e_var7->_is_equivalent((Echo_ptr)e_var6));
  assert(e_var7->_is_equivalent((Echo_ptr)e_var5));
  cerr << "###" << endl;
}

static
void
test_objref_2()
{
  // Testing object _member class

  CORBA::Object_ptr obj = orb->string_to_object(test_ior1);
  Echo_ptr e = Echo::_narrow(obj);
  CORBA::release(obj);

  cerr << "### ctor Echo_member()" << endl;
  Echo_member e_mem1;	// ctor Echo_member()
  assert(CORBA::is_nil(e_mem1));

  cerr << "### ctor Echo_member(Echo_ptr)" << endl;
  Echo_member e_mem2(e);	// ctor Echo_member(Echo_ptr)
  assert(!CORBA::is_nil(e_mem2));

  cerr << "### ctor Echo_member(const Echo_member &)" << endl;
  Echo_member e_mem3(e_mem2); // ctor Echo_member(const Echo_member &)
  assert(e_mem2._ptr->_is_equivalent((Echo_ptr)e_mem3));

  obj = orb->string_to_object(test_ior2);
  e = Echo::_narrow(obj);
  CORBA::release(obj);

  cerr << "### Echo_member& operator= (Echo_ptr)" << endl;
  Echo_member e_mem4;
  e_mem4 = e;                      // Echo_member& operator= (Echo_ptr)
  assert(!CORBA::is_nil(e_mem4));
  assert(!e_mem4._ptr->_is_equivalent((Echo_ptr)e_mem3));
  
  cerr << "### Echo_member& operator= (const Echo_member&)" << endl;
  Echo_member e_mem5 = e_mem4;	// Echo_member& operator= (Echo_member&)
  assert(!CORBA::is_nil(e_mem5));
  assert(e_mem5._ptr->_is_equivalent((Echo_ptr)e_mem4));
  
  e_mem5 = e_mem3;
  assert(!e_mem5._ptr->_is_equivalent((Echo_ptr)e_mem4));
  assert(e_mem5._ptr->_is_equivalent((Echo_ptr)e_mem3));

  cerr << "### Echo_member& Echo_member::operator= (Echo_var &)" << endl;
  Echo_var e_var(Echo::_duplicate(e));
  assert(e_var->_is_equivalent(e));
  e_var = e_mem2;
  assert(e_var->_is_equivalent((Echo_ptr)e_mem2));

  cerr << "### Echo_var& Echo_var::operator= (Echo_member &)" << endl;
  e_mem4 = e_var;
  assert(e_mem4._ptr->_is_equivalent((Echo_ptr)e_var));

  cerr << "###" << endl;

}

static
void
test_objref_3()
{
  // object widening, sec. 16.3.2
  // XXX Not tested yet
}

int
main(int argc, char **argv)
{
  int loopcount = 1;

  orb = CORBA::ORB_init(argc,argv,"omniORB2");
  
  while (loopcount--) {
    cerr << "Testing objref...";
    test_objref_1();
    test_objref_2();
    test_objref_3();
    cerr << "PASSED." << endl;
  }

  return 0;
}

