#!/bin/sh
#
# Try to choose automatically the good ${SmallEiffel}/sys/gc_lib/*.c
# file for the Garbage Collector on a Unix system.
#
sed=${SmallEiffel:=1}
if [ ${sed} = 1 ];  then 
	echo "Environment Variable 'SmallEiffel' not set."
	exit 1
fi
SE=${SmallEiffel}
if [ -f ${SE} ]; then
	echo ${SE} "not found."
	exit 1
fi
cd ${SE}/sys
if [ `uname` = Linux ]
 then
  gc=linux.c
elif [ `uname` = SunOS ]
 then
  gc=sparc.c
elif [ `uname` = OSF1 ]
 then
  gc=alpha.c
elif [ `uname` = HP-UX ]
 then
  gc=hp-pa.c
else
  echo GC is not supported for this architecture.
  echo Read file ${SmallEiffel}/sys/gc to try to fix this.
  gc="NONE"
fi
echo GC for ${gc} selected \(See ${SmallEiffel}/sys/gc\).
/bin/rm -rf gc_tmp
echo ${gc} > gc_tmp
cat gc >> gc_tmp
mv -f gc_tmp gc
