#---------------------------------------------------------------
# The filter utilities
#---------------------------------------------------------------

#---------------------------------------------------------------
# Procedure: filterpopup
#  Pops up the "filter" window
#---------------------------------------------------------------
proc filterpopup {} {
    toplevel .filter
    relative . .filter 100 20
    frame .filter.top -relief groove -bd 3
    label .filter.top.label -text "Enter characters to practice:"
    entry .filter.top.entry -width 54 -relief sunken -bd 2 \
	    -textvariable filterletters
    pack .filter.top.label .filter.top.entry -side top -anchor w \
	    -pady 4 -padx 15
    pack .filter.top

    frame .filter.middle
    foreach i {1 2 3 4} {
	frame .filter.row$i -relief flat -bd 1
	button .filter.row$i.row$i -text "Row $i" -width 6 \
		-command "set filterletters \"\${filterletters}[getrow $i]\""
	pack .filter.row$i.row$i -ipady 2 -pady 3 -padx 3
	pack .filter.row$i -in .filter.middle -side left -padx 6 -pady 5
    }
    pack .filter.middle

    frame .filter.bottom
    frame .filter.ok -relief sunken -bd 1
    button .filter.ok.ok -text "OK" -width 6 \
	    -command {destroy .filter; filter; focus .entry}
    pack .filter.ok.ok -ipady 2 -pady 3 -padx 3
    frame .filter.cancel -relief flat -bd 1
    button .filter.cancel.cancel -text "Cancel" -width 6 \
	    -command {destroy .filter; focus .entry}
    pack .filter.cancel.cancel -ipady 2 -pady 3 -padx 3
    frame .filter.clear -relief flat -bd 1
    button .filter.clear.clear -text "Clear" -width 6 \
	    -command {set filterletters ""}
    pack .filter.clear.clear -ipady 2 -pady 3 -padx 3
    frame .filter.help -relief flat -bd 1
    button .filter.help.help -text "Help" -width 6 \
	    -command {filterhelp}
    pack .filter.help.help -ipady 2 -pady 3 -padx 3
    pack .filter.ok .filter.cancel .filter.clear \
	    .filter.help -in .filter.bottom -side left -padx 6 -pady 5
    pack .filter.bottom
    
    focus .filter.top.entry
    bind .filter.top.entry <Return> {
	press .filter.ok.ok "filter; destroy .filter; focus .entry"
    }
}
set filterletters ""

#---------------------------------------------------------------
# Procedure: filter {}
#  Filters text and displays only words consisting entirely of
#   letters specified in $filterletters
#---------------------------------------------------------------
proc filter {} {
    global origtext filterletters filtertext
    set textlist {}

    if {"$filterletters" == ""} {
	errordialog .filter 30 1 {"Error: filter string is empty."}
	return
    }

    set pattern [format {^[%s]+} $filterletters]
    set filtered 0
    set total 0
    set splitchars " \t"
    regsub -all "\n" $origtext " \n " tmptext
    foreach word [split $tmptext $splitchars] {
	if {"$word" == ""} continue
	if {"$word" == "\n"} {
	    lappend textlist "\n"
	    continue
	}
	incr total
	set match ""
	if [ignorecasesp] {
	    regexp -nocase "$pattern" "$word" match
	} else {
	    regexp "$pattern" "$word" match
	}
	if {[string length "$match"] == [string length "$word"]} {
	    lappend textlist "$word"
	    incr filtered
	}
	lappend textlist " "
    }
    set text [join $textlist]
    set filtertext [format "%d/%d words" $filtered $total]
    # change multiple spaces into one---we don't care about formatting
    regsub -all "( |\t)+" $text " " text
    # the space at the beginning of line too
    regsub -all "\n " $text "\n" text
    regsub -all "^ " $text "" text
    display $text
}

#---------------------------------------------------------------
# Procedure: unfilter
#  Undos filter effect
#---------------------------------------------------------------
proc unfilter {} {
    global origtext filtertext
    set filtertext "off"
    display $origtext
}
