/*    clip_pm.cpp
 *
 *    Copyright (c) 1994-1998, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#include "fte.h"
#include "clip.h"

#define INCL_WIN
#define INCL_DOS
#include <os2.h>
#include <string.h>
#include <stdlib.h>

#if 0
static int loaded = 0;
static int loaded_ok = 0;
static char pmwin_name = "PMWIN.DLL";
static HMODULE pmwin;

static void loadDLL() {
    PPIB ppib;
    PTIB ptib;
    char error[200];

    loaded = 1;

    if (DosGetInfoBlocks(&ptib, &ppib) == 0)
        ppib->pib_ultype = PROG_PM;
    else
        return ;

    if (DosLoadModule(error, sizeof(error), pmwin_name, &pmwin) != 0) {
        putchar('\n');
        puts(error);
        putchar('\n');
        puts(error);;
        return ;
    }

    loaded_ok = 1;
}
#endif

int GetClipText(ClipData *cd) {
    HAB hab;
    HMQ hmq;
    int rc = -1;
    char *text;

    cd->fLen = 0;
    cd->fChar = 0;

#if 0
    if (!loaded)
        loadDLL();
    if (!loaded_ok)
        return rc;
#endif

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    if ((WinOpenClipbrd(hab) == TRUE) &&
        ((text = (char *) WinQueryClipbrdData(hab, CF_TEXT)) != 0))
    {
        cd->fLen = strlen(text);
        cd->fChar = strdup(text);
        rc = 0;
    }
    WinCloseClipbrd(hab);

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return rc;
}

int PutClipText(ClipData *cd) {
    HAB hab;
    HMQ hmq;
    ULONG len;
    void *text;
    int rc = -1;

#if 0
    if (!loaded)
        loadDLL();
    if (!loaded_ok)
        return rc;
#endif

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);
    if (WinOpenClipbrd(hab) == TRUE) {
        WinEmptyClipbrd(hab);
        len = cd->fLen;
        
        if (len) {
            DosAllocSharedMem((void **)&text,
                              0,
                              len + 1,
                              PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE);
            strncpy((char *)text, cd->fChar, len + 1);
            if (!WinSetClipbrdData(hab, (ULONG) text, CF_TEXT, CFI_POINTER))
                DosBeep(100, 1500);
            else
                rc = 0;
        }
        WinCloseClipbrd(hab);
    }
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return rc;
}
