% tcl mode 0.1 (derived from shmode.sl, cmode.sl and latex.sl)
% by David Schweikert (dwschwei@stud.ee.ethz.ch)

% This mode only does DFA syntax-highlighting and a very
% rough automatic indentation (assumes that the previous line
% is correctly indented)

% Keybindings
% ----------------------------------------------
% ^C^Q     tcl_indent_region   
% }        tcl_insert_ket

% The syntax-coloring-types of jed aren't very adequate for tcl,
% so, I used them as follows:
%
% -     normal: as expected
% -    comment: as expected
% -     string: as expected
% -     number: $variable
% - preprocess: proc definition (first line)
% -    keyword: all commands (at beg. of line) - There are no keywords in tcl!
% -   operator: not used

autoload("tcl_mode", "~/devel/jed/tclmode");
autoload("tcl_indent_line", "~/devel/jed/tclmode");
autoload("tcl_newline_and_indent", "~/devel/jed/tclmode");
Mode_List_Exts = strcat (Mode_List_Exts, ",tcl");
Mode_List_Modes = strcat (Mode_List_Modes, ",tcl");

$1 = "TCL";

create_syntax_table ($1);

#ifdef HAS_DFA_SYNTAX
enable_highlight_cache ("tclmode.dfa", $1);
define_highlight_rule ("^[ \\t]*#.*$", "comment", $1);
define_highlight_rule (";[ \\t]*#.*$", "comment", $1);
% If you don't like the string highlighting, comment the following line:
define_highlight_rule ("\"([^\\\\\"]|\\\\.)*\"", "string", $1);
define_highlight_rule ("[{}\\[\\]]", "delimiter", $1); % "Qdelimiter"?
define_highlight_rule (".", "normal", $1);
define_highlight_rule ("\\$[a-zA-Z0-9_]+", "number", $1);
define_highlight_rule ("\\${.*}", "Qnumber", $1);
define_highlight_rule ("^[ \\t]*[a-zA-Z0-9_\\.]+", "keyword", $1);
define_highlight_rule ("^[ \\t]*proc[ \\t]+[a-zA-Z0-9_\\.]+[ \\t].*[ \\t]{[ \\t]*$", "preprocess", $1);
% Until jed doesn't has support for context-sensitive highlighting
% (with subpatterns to specify what to highlight in a regexp), the following
% produces rather ugly highlighting: The ';' or '[' before a command
% is also highlighted. If you don't like it, comment it...
define_highlight_rule ("[;\\[][ \\t]*[a-zA-Z0-9_\\.]+", "keyword", $1);

build_highlight_table ($1);
#endif

define tcl_newline_and_indent ()
{
	newline ();
	tcl_indent_line ();
}

define tcl_indent_to (n)
{
	bol_skip_white ();
	if (what_column != n)
	{
		bol_trim ();
		n--;
		whitespace (n);
	}
}

% Doesn't handle escaped or in string braces
define tcl_count_braces ()
{
	variable c, count = 0;
    
	push_spot();
	bol;
    
	for(bol; not(eolp()); go_right_1()) {
		c = what_char ();
		if ((c == '{') or (c == '[')) count++;
		else if ((c == '}') or (c == ']')) count--;
	}
    
	count;
	pop_spot();
}

define tcl_go_up ()
{
        % Search for a valid previous line.
        forever {
                if (up_1 ()) {
                        bol_skip_white ();
                        if (eolp ()) continue;
                        if (what_char () != '#') return(1);
                }
                else return(0);
        }
}

define tcl_is_continued_line ()
{
	eol();
	bskip_white ();
	if (blooking_at ("\\")) 1;
	else 0;
	return;
}

% "} else {" looks ugly!
define tcl_indent_line ()
{
	variable upcount = 0;
	variable count = 0;
	variable contline = 0;
	variable col = 0;
	variable cursor, oldindent, newindent;
    
	push_spot ();
	cursor = what_column ();
  	bol_skip_white ();
	oldindent = what_column ();
	% is it a comment? => Leave it	
	if (what_char () == '#') { pop_spot(); return; }
	
	% Count on the previous line
	if(tcl_go_up ()) {
		col = what_column ();
		upcount += tcl_count_braces ();
		% Is the current line a continued line?
		if (tcl_is_continued_line ()) contline++;
		if (tcl_go_up() and tcl_is_continued_line()) contline--;
	}
	pop_spot ();
    
	% Count on the current line
	count += tcl_count_braces ();
	
	%DEBUG message(strcat(string(upcount), strcat(" : ", string(count))));

	if (upcount > 0) col += upcount * C_INDENT;
	if (count < 0) col += count * C_INDENT;
	col += contline * C_CONTINUED_OFFSET;

	tcl_indent_to (col);
	newindent = what_column();
	goto_column(cursor + newindent - oldindent);
}

define tcl_indent_region ()
{
	check_region(1);
	pop_mark_1 (); 
	push_mark();
	tcl_indent_line(); % set initial line indentation before narrowing
	pop_spot();
	
	push_spot();
	go_up_1 ();
	narrow();
	bob();
	while (down_1 ())   % indent line by line (ie slowly)
	  tcl_indent_line(); % a good latex_format_paragraph would be nice...
	widen();
	pop_spot();
	
}

% Could make a tcl_insert_bra which warns about incorrect syntax (brace
% on a new line). This is probably a common syntax error...

define tcl_insert_ket ()
{
	insert("}");
	if(eolp()) {
		tcl_indent_line();
		eol();
		blink_match ();
	}	
}

$1 = "TCL";
!if (keymap_p ($1)) make_keymap ($1);
definekey("tcl_insert_ket", "}", $1);
definekey("tcl_indent_region", "^C^Q", $1);

define tcl_mode ()
{
	variable mode = "TCL";
	set_mode(mode, 4);
	use_keymap(mode);
	use_syntax_table (mode);
	set_buffer_hook ("indent_hook", "tcl_indent_line");
	set_buffer_hook ("newline_indent_hook", "tcl_newline_and_indent");
	runhooks("tcl_mode_hook");
}
