//  x11.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// Simple demo to convert
//

#include <stdlib.h>
#include <iostream.h>
#include <UWidget.h>
#include <UFontMap.h>
#include <UFont.h>
#include <UString.h>
#include <X11/Xlib.h>
#include <UCommon.h>

void 		usage();

#define LINE_LENGTH	4096

#ifndef YUDITDATA
#define YUDITDATA "."
#endif

static void processEvents ();
static Atom wm_delete_window;
XGCValues	gcv;
GC		gc;
Display		*display;
int		screen;
Window 		mainWindow;
UWidget		*uwidget;
UFontX11*	font1;
UFontMap*	fontMap;
Atom		wmProtocols;
Atom		wmDeleteWindow;

void
main (int argc, char *argv[])
{
	ifstream	*file;
	istream 	*input;
	char		*umaps;
	unsigned char	line[LINE_LENGTH+2];
	int		len;
	unsigned long 	backGround, foreGround;

	if (argc < 2)
	{
		usage();
		exit (1);
	}
	if (argc > 2)
	{
		file = new ifstream (argv[2]);
		if (!file->is_open())
		{
			cerr << "uc: can not open '" << argv[2] << "' for reading.\n";
			exit (1);
		}
		input = file;
	}
	else
	{
		input = &cin;
	}
	
	if (umaps=getenv ("YUDITDATA"))
	{
		USetMapPath (umaps);
	}
	else
	{
		USetMapPath (YUDITDATA);
	}

	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		cerr << "error: XOpenDisplay could not open.\n";
		exit (1);
	}
	screen=DefaultScreen (display);

	backGround = BlackPixel (display, screen);
	foreGround = WhitePixel (display, screen);
	mainWindow = XCreateSimpleWindow (
		display, RootWindow (display, screen),
		0, 0,
		600, 400,
		0, 
		backGround,
		foreGround);

	gcv.foreground = foreGround;
	gcv.background = backGround;
	gc = XCreateGC (display, mainWindow,  GCForeground | GCBackground, &gcv);
	wm_delete_window = XInternAtom(display,
			"WM_DELETE_WINDOW", True);
	XSetWMProtocols (display, mainWindow, 
		&wm_delete_window, 1);

	uwidget = new UWidget ("test", display, mainWindow); 
	if (uwidget->uSetConverter ((const char *) argv[1]) == UString::ERROR)
	{
		cerr << "uc: can not find converter for '" << argv[1] << "'\n";
	}

	while (input->getline (line, LINE_LENGTH))
	{
		uwidget->uAppendText ((const unsigned char*) line, 0, 1);
	}

	UAddFontMap ("TEST", "misc", "fixed", "jisx0208.1983", "0", "JIS0208");
	UAddFontMap ("TEST", "*", "fixed", "jisx0201.1976", "0", "JIS0201");
	UAddFontMap ("TEST", "*", "fixed", "iso8859", "1", "8859_1");
	UAddFontMap ("TEST", "*", "*", "iso8859", "2", "8859_2");

	fontMap=UGetFontMap ("TEST");
	font1 = new UFontX11 (fontMap, display, screen);
	font1->setPixel (14);
	font1->setSlant (UFont::ROMAN);
	font1->setWeight (UFont::ANYWEIGHT);
	uwidget->uSetFont (font1);
	uwidget->uSetConverter ((const char *) argv[1]);

	if (argc == 3)
	{
		delete (file);
	}

	wmProtocols = XInternAtom (display, "WM_PROTOCOLS", False);
	wmDeleteWindow = XInternAtom (display, "WM_DELETE_WINDOW", False);
	XMapSubwindows (display, mainWindow);
	XMapWindow (display, mainWindow);
	processEvents ();
}

static void
processEvents ()
{
	XEvent		event;
	XChar2b		character;

	XSelectInput (display, mainWindow, PropertyChangeMask |
		ExposureMask | SubstructureNotifyMask 
		| ButtonPressMask | KeyPressMask | ButtonReleaseMask 
		| Button1MotionMask);

	while (1)
	{
		XNextEvent (display, &event);
		switch (event.type)
		{
		case ConfigureNotify:
			// resize
			break;
		case ClientMessage:
			if (event.xclient.message_type == wmProtocols
				&& event.xclient.data.l[0] == wmDeleteWindow
				&& event.xclient.format == 32)
			{
				cerr << "good bye\n";
				exit (0);
			}
			break;
		case Expose:
		case KeyPress:
		case ButtonPress:
		case ButtonRelease:
		case MotionNotify:
		case SelectionRequest:
		case SelectionClear:
		case SelectionNotify:
			// expose event to window
			uwidget->uHandleEvent (&event);
			break;
		}
	}
}

void
usage ()
{
	cerr << "usage: wtest ENCODING [inputfile]\n";
	cerr << "       Currently known encodings:\n";
	cerr << "       EUC_JP JIS KOI8_R 8859_1 8859_2 8859_5 UTF8 UTF7\n";
	cerr << "       The umap files should be located on your YUDITDATA.\n";
}
