//  FileConfig.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "FileConfig.h"
#include <iostream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <UCommon.h>
#include <ctype.h>

#define LINE_LENGTH 	1024

char*		FileConfig::pathName=0;
char*		FileConfig::path=0;
ifstream*	FileConfig::file=0;
streampos	FileConfig::fileBegin;

#ifdef FILESEPARATOR
#undef FILESEPARATOR
#endif

#define FILESEPARATOR "/"

FileConfig::FileConfig (const char* nameIn)
{
	char*		home;
	char*		other;
	int		len;
	int		from=0;
	int		to=0;
	int		length;
	struct stat 	buf;

	file = 0;
	pathName = 0;
	if (path == 0)
	{
		home = getenv ("HOME");
		if (home==0) home = "";
		other = CONFIG_PATH;
		if (other==0) other = "";
		path = new char [strlen (home) + 2 + 1 + strlen (home) +
			strlen ("/.kde/config") + 2 + strlen (other) + 2];
		CHECKNULL (path);
		strcpy (path, home);
		strcat (path, "/.");
		strcat (path, ":");
		//strcat (path, home);
		//strcat (path, "/.kde/config" );
		//strcat (path, ":");
		strcat (path, other);
	}

	// Try to find a file to open
	length = strlen (path);
	while (to<length)
	{
		while (path[to] != ':' && path[to] != 0) to++;
		if (to==from) { to++; from=to; continue; }
		pathName = new char[to-from +strlen (FILESEPARATOR) 
			+ strlen (nameIn) +1];
		CHECKNULL (pathName);
		memcpy (pathName, &path[from], to-from);
		pathName[to-from] = 0;
		if (pathName[to-from-1] != '.')
		{
			strcat (pathName, FILESEPARATOR); 
		}
		strcat (pathName, nameIn);
		to++; from = to;
		if (stat (pathName, &buf) != 0)
		{
			delete pathName;
			pathName=0;
			continue;
		}
		file = new ifstream (pathName);
		CHECKNULL (file);
		if (file->rdbuf() == 0 || !file->rdbuf()->is_open())
		{
			delete pathName;
			pathName=0;
			delete file;
			file = 0;
			continue;
		}
		// file, pathName, is set
		fileBegin = file->tellg();
		break;
	}
}

FileConfig::~FileConfig()
{
	if (file) delete file;
}

void
FileConfig::setGroup (const AString& pos)
{
	group = "[";
	group += (const char*) pos;
	group += "]";
	return;
}

char*
FileConfig::seekEntry (const char* entry)
{
	int		len;
	int		found;
	char		line[LINE_LENGTH];
	char*		pos;
	char*		retVle;

	if (file==0  || file->rdbuf() == 0 || !file->rdbuf()->is_open())
	{
		return 0;
	}
	file->seekg (fileBegin);
	file->clear();
	found = 0;
	while (file->getline (line, LINE_LENGTH))
	{
		if (strcmp (line, (const char*) group) ==0)
		{
			found = 1;
			break;
		}
	}
	if (found ==0) return 0;
	found = 0;
	len = strlen ((const char*) entry);
	while (file->getline (line, LINE_LENGTH))
	{
		if (line[0] == '[') break;
		if (strncmp (line, (const char*) entry, len)==0
			&& line[len]=='=')
		{
			found = 1;
			break;
		}
	}
	if (found == 0) return 0;

	pos = &line[len+1];
	if (pos[0] ==0) return 0;
	retVle = new char[strlen (pos) +1];
	CHECKNULL (retVle);
	strcpy (retVle, pos);
	return retVle;
}

int
FileConfig::readEntries (const char* key, AStringList &list,
	const char sep)
{
	char 	*line;
	char 	*word;
	int	i, j;

	line = seekEntry (key);
	if (line == 0) return 0;
	i=0; j=0;
	list.clear ();
	while (line[j]!=0)
	{
		if (line[j]==sep)
		{
			word = expandEnv (&line[i], j-i);
			list.add (word);
			delete word;
			j++;
			i=j;
			continue;
		}
		j++;
	}
	if (j>i)
	{
		word = expandEnv (&line[i], j-i);
		list.add (word);
		delete word;
	}
	return list.getSize();
}

int
FileConfig::readEntry (const char* entry, AString &result)
{
	char	*value;
	char	*retValue;

	value = seekEntry (entry);
	if (value == 0) return 0;
	retValue = expandEnv (value, strlen (value));
	delete value;
	result = retValue;
	delete retValue;
	return (result.isNull() ? 0 : 1);
}

char*
FileConfig::expandEnv (const char* entry, int size)
{
	char	line[LINE_LENGTH];
	char	var[LINE_LENGTH];
	char*	retVle;
	int	i;
	int	j;
	int	v;
	int	len;
	char*	expn;

	for (j=0, i=0; i<size; i++)
	{
		if (entry[i] != '$')
		{
			line[j++] = entry[i];
			continue;
		}
		v=0;
		if (entry[i+1] == '{') i++;
		while (isalnum (entry[++i]))
		{
			var[v++] = entry[i];
		}
		var[v]=0;
		expn = getenv (var);
		if (expn ==0) continue;
		len = strlen (expn);
		memcpy (&line[j], expn, len);
		j+=len;
		if (entry[i]!='}') line[j++]=entry[i];
	}
	line[j]=0;
	retVle = new char[j+1];
	CHECKNULL (retVle);
	memcpy (retVle, line, j+1);
	return retVle;
}
