//  UButton.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UButton.h"
#include "UTextFrame.h"
#include <iostream.h>

#define REPEAT_TIME   70
#define REPEAT_START_TIME   700

UButton::UButton  (UFrame* parent_, UButtonStyle style, 
	int motion_, int offset_, int size_) 
	: UFrame(parent_, (style==HIGHLIGHT) ? 0 : 2) 
{
	defaultMotion = motion_;
	defaultOffset = offset_;
	setFrameStyle (OUT);
	buttonStyle = style;
	buttonMotion = 0;

	select (ButtonPressMask |ButtonReleaseMask | Button1MotionMask
		| ExposureMask | SubstructureNotifyMask);
	buttonState = RELEASED;
	repeat = NOREPEAT;
	timerId=0;
}

void
UButton::addChild (UComponent* child)
{
	UFrame::addChild (child);

	buttonMotion = (buttonState == PRESSED) ?  defaultMotion : 0;

	if (buttonStyle == NO_ACTION) buttonMotion=0;
	frameStyle = (buttonState == PRESSED) ? IN : OUT;

	child->place (frameSize+buttonMotion+defaultOffset, 
		frameSize+buttonMotion+defaultOffset,
		(frameSize-buttonMotion+defaultOffset>frameSize)? 
		   (frameSize-buttonMotion+defaultOffset):frameSize, 
		(frameSize-buttonMotion+defaultOffset>frameSize)? 
		   (frameSize-buttonMotion+defaultOffset):frameSize);
}

const UBestSize&
UButton::getBestSize ()
{
	UComponent*	comp;
	UBestSize	pl;

	comp = (UComponent*) children.at(0);
	if (comp==0)
	{
		cerr << "No child for button.\n";
		return UFrame::getBestSize();
	}
	pl = comp->getBestSize();
	bestSize.width = pl.width + 2*frameSize + 2*defaultOffset + 2* placement.margin;
	bestSize.height = pl.height + 2*frameSize + 2*defaultOffset + 2* placement.margin;
	return bestSize;
}

UButton::~UButton()
{
	//content is autodeleted 
	if (timerId != 0) top->deleteTimer ((unsigned long) window, timerId);
}

void
UButton::eventDown (UEvent* event)
{
	XRectangle 	rect;
	UComponent*	child;

	child = (UComponent*) children.at(0);
	switch (event->type)
	{
		case UEvent::TIMER:
			timerId = 0;
			event->type = UEvent::PRESSED;
			event->client = this;
			parent->eventUp (event);
			if (buttonState == PRESSED) repeater (REPEAT, 1);
			break;
		case UEvent::X:
		switch (event->xevent.type)
		{
		case ButtonPress:
			if (event->xevent.xbutton.button != Button1) return;
			setHighlight(1);
			if (buttonState == PRESSED) return;
			if (buttonState != LEFT_PARENT)
			{
				event->type = UEvent::PRESSED;
				event->client = this;
				parent->eventUp (event);
				repeater (REPEAT);
			}
			setState (PRESSED);
			return;

		case ButtonRelease:
			if (event->xevent.xbutton.button != Button1) return;
			if (buttonState==RELEASED) return;
			setHighlight(0);
			parent->eventUp (event);
			if (buttonState==LEFT_PARENT)
			{
				setState (RELEASED);
				event->type = UEvent::RELEASED;
				event->client = this;
				parent->eventUp (event);
				return;
			}
			setState (RELEASED);
			event->type = UEvent::ACTIVATED;
			event->client = this;
			parent->eventUp (event);
			repeater (NOREPEAT);
			return;
		case MotionNotify:
			compressEvent (event);
			if (event->xevent.xmotion.state & Button1MotionMask==0)
				 return;
			if (event->xevent.xmotion.x < 0 
				|| event->xevent.xmotion.x > rectangle.width ||
				event->xevent.xmotion.y < 0
				|| event->xevent.xmotion.y > rectangle.height)
			{
				if (buttonState==PRESSED)
				{
					setState (LEFT_PARENT);
					repeater (NOREPEAT);
				}
			}
			else
			{
				if (buttonState == LEFT_PARENT)
				{
					setState (PRESSED);
					repeater (REPEAT, 1);
				}
			}
			event->client = this;
			parent->eventUp (event);
			break;

		case Expose:
			rect.x = event->xevent.xexpose.x;
			rect.y = event->xevent.xexpose.y;
			rect.width = event->xevent.xexpose.width;
			rect.height = event->xevent.xexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;

		case GraphicsExpose:
			rect.x = event->xevent.xgraphicsexpose.x;
			rect.y = event->xevent.xgraphicsexpose.y;
			rect.width = event->xevent.xgraphicsexpose.width;
			rect.height = event->xevent.xgraphicsexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;
		default:
			parent->eventUp (event);
		}
	default:
		break;
	}
}

int
UButton::isA (UComponent::UType type_)
{
	if (type_ == UComponent::BUTTON) return 1;
	return UFrame::isA (type_);
}

void
UButton::eventUp (UEvent* event)
{
	switch (event->type)
	{
		case UEvent::TIMER:
			timerId = 0;
			event->type = UEvent::PRESSED;
			event->client = this;
			parent->eventUp (event);
			if (buttonState == PRESSED) repeater (REPEAT, 1);
			break;
		case UEvent::X:
		switch (event->xevent.type)
		{
		case ButtonPress:
			if (event->xevent.xbutton.button != Button1) return;
			setHighlight(1);
			if (buttonState == PRESSED) return;
			if (buttonState != LEFT_PARENT)
			{
				event->type = UEvent::PRESSED;
				event->client = this;
				parent->eventUp (event);
				repeater (REPEAT);
			}
			setState (PRESSED);
			return;

		case ButtonRelease:
			if (event->xevent.xbutton.button != Button1) return;
			if (buttonState==RELEASED) return;
			setHighlight(0);
			parent->eventUp (event);
			if (buttonState==LEFT_PARENT)
			{
				buttonState = RELEASED;
				event->type = UEvent::RELEASED;
				event->client = this;
				parent->eventUp (event);
				return;
			}
			setState (RELEASED);
			event->type = UEvent::ACTIVATED;
			event->client = this;
			parent->eventUp (event);
			repeater (NOREPEAT);
			return;
		case MotionNotify:
			compressEvent (event);
			if (event->xevent.xmotion.state & Button1MotionMask==0)
				 return;
			if (event->xevent.xmotion.x + buttonMotion + frameSize < 0
				|| event->xevent.xmotion.x + buttonMotion + frameSize > rectangle.width ||
				event->xevent.xmotion.y + buttonMotion + frameSize < 0
				|| event->xevent.xmotion.y + buttonMotion + frameSize > rectangle.height)
			{
				if (buttonState==PRESSED)
				{
					setState (LEFT_PARENT);
					repeater (NOREPEAT);
				}
			}
			else
			{
				if (buttonState == LEFT_PARENT)
				{
					setState (PRESSED);
					repeater (REPEAT, 1);
				}
			}
			event->client = this;
			parent->eventUp (event);
			break;
		}
	default: break;
	}
}

void
UButton::setState(UButtonState state)
{
	UComponent*	child;
	buttonState = state;

	child = (UComponent*) children.at(0);
	if (child==0) return;

	buttonMotion = (buttonState == PRESSED) ?  defaultMotion : 0;
	frameStyle = (buttonState == PRESSED) ? IN : OUT;

	if (buttonStyle == NO_ACTION) return;
#if ILIKEIT
	if (buttonStyle == HIGHLIGHT) return;
#endif

	child->place (frameSize+buttonMotion+defaultOffset, 
		frameSize+buttonMotion+defaultOffset,
		(frameSize-buttonMotion+defaultOffset>frameSize)? 
		   (frameSize-buttonMotion+defaultOffset):frameSize, 
		(frameSize-buttonMotion+defaultOffset>frameSize)? 
		   (frameSize-buttonMotion+defaultOffset):frameSize);
	pack ();
	//child->move (frameSize+buttonMotion, frameSize+buttonMotion);
	//redraw (0,0,rectangle.width, rectangle.height);
#if 0
cerr << "place "
<< frameSize+buttonMotion+defaultOffset << ","  
<< frameSize+buttonMotion+defaultOffset << ","
<< ((frameSize-buttonMotion+defaultOffset>frameSize)?
	(frameSize-buttonMotion+defaultOffset):frameSize) << ","
<< ((frameSize-buttonMotion+defaultOffset>frameSize)?
	(frameSize-buttonMotion+defaultOffset):frameSize) << "\n";
#endif
}


void
UButton::setRepeat (URepeat repeat_)
{
	repeat = repeat_;
	if (repeat == NOREPEAT && timerId !=0)
	{
		top->deleteTimer ((unsigned long) window, timerId);
		timerId = 0;
	}
}
void
UButton::repeater (URepeat on, int cont)
{
	if (repeat == NOREPEAT) return;
	if (timerId!=0 && on == REPEAT) return;
	if (on == NOREPEAT)
	{
		if (timerId !=0)
		{
			top->deleteTimer ((unsigned long) window, timerId);
			timerId = 0;
		}
		return;
	}
	if (cont==0)
	{
		timerId=top->addTimer ((unsigned long) window, REPEAT_START_TIME);
	}
	else
	{
		timerId=top->addTimer ((unsigned long) window, REPEAT_TIME);
	}
	return;
}

void
UButton::compressEvent (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::X:
		XCheckTypedWindowEvent (top->display,
			event->xevent.xany.window,
			event->xevent.type,
			&event->xevent);
		break;
	default:
		break;
	}
}

void
UButton::setHighlight (int reverse)
{
	UComponent* child;
	UColor rback (top->display);
	UColor rfore (top->display);

	child = (UComponent*) children.at(0);
	if (child==0 || buttonStyle != HIGHLIGHT) return;

	if (reverse)
	{
		rback.assign (0, 0, 0x8b8b);
		rfore.assign (0xffff, 0xffff, 0xffff);

		XSetForeground (UTOP->display, darkGC, dark.getPixel());
		XSetWindowBackground (background.getDisplay(), window,
			rback.getPixel());
		XClearArea (UTOP->display, window, 0, 0, rectangle.width,
			rectangle.height, True);
		child->setBackground (rback);
		child->setForeground (rfore);
	}
	else
	{
		rback = background;
		rfore = foreground;
		XSetForeground (UTOP->display, darkGC, dark.getPixel());
		XSetWindowBackground (background.getDisplay(), window,
			rback.getPixel());
		XClearArea (UTOP->display, window, 0, 0, rectangle.width,
			rectangle.height, True);
		child->setBackground (rback);
		child->setForeground (rfore);
	}
}
