//  UFindDialog.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#define CMARGIN 4
#define MARGIN 10
#define BUTTON_MARGIN 20

#include "UFindDialog.h"
#include "UTextButton.h"
#include "UTextLabel.h"
#include "UTextMenu.h"
#include "UTextFrame.h"
#include "UButton.h"
#include "UChoice.h"
#include "UScrolledList.h"
#include "strings.h"

#define DEBUG

UFindDialog::UFindDialog (UShell* transient_, int frameSize_) :
	UDialog (transient_, frameSize_)
{
	setUp();
}

UFindDialog::UFindDialog (UTop* top_, int frameSize_) :
	UDialog (top_, frameSize_)
{
	setUp ();
}

void 
UFindDialog::setUp()
{
	UColor	white (top->display);

	white = "#FFFFFF";

	component[FIND] = new UTextButton (this, "FIND");
	component[FIND]->setMargin (CMARGIN);
	component[REPLACE] = new UTextButton (this, "REPLACE");
	component[REPLACE]->setMargin (CMARGIN);
	component[CANCEL] = new UTextButton (this, "CANCEL");
	component[CANCEL]->setMargin (CMARGIN);
	lastButton = CANCEL;
	findArea = 0;

	component[FIND_LABEL] = new UTextLabel (this, "Input", UTextLine::RIGHT);
	component[FIND_LABEL]->setMargin (CMARGIN);

	component[FIND_TEXT] = new UTextFrame (this);
	component[FIND_TEXT]->setMargin (CMARGIN);
	((UTextFrame*)component[FIND_TEXT])->uSetBackground (white.getPixel());
	((UTextFrame*)component[FIND_TEXT])->uSetMultiLine (UWidget::SINGLE);

	component[REPLACE_LABEL] = new UTextLabel (this, "Input", UTextLine::RIGHT);
	component[REPLACE_LABEL]->setMargin (CMARGIN);

	component[REPLACE_TEXT] = new UTextFrame (this);
	component[REPLACE_TEXT]->setMargin (CMARGIN);
	((UTextFrame*)component[REPLACE_TEXT])->uSetBackground (white.getPixel());
	((UTextFrame*)component[REPLACE_TEXT])->uSetMultiLine (UWidget::SINGLE);

	rectangle.width = 20;
	rectangle.height = 20;
//	move (XDisplayWidth (top->display, top->screen)/2,
//		XDisplayHeight (top->display, top->screen)/2);
	findResult = 2;
}

UFindDialog::~UFindDialog ()
{
	// autodelete
}

void
UFindDialog::resize (int w, int h)
{
	UShell::resize (w, h);
}

void
UFindDialog::setFindArea (UTextFrame* findArea_)
{
	UColor	bg (top->display);
	
	findArea = findArea_;
	if (!findArea)
	{
		bg = background;
		((UTextFrame*)component[FIND_TEXT])->uSetBackground (bg.getPixel());
		((UTextFrame*)component[FIND_TEXT])->uSetEditable (UWidget::VIEW);
		((UTextFrame*)component[REPLACE_TEXT])->uSetBackground (bg.getPixel());
		((UTextFrame*)component[REPLACE_TEXT])->uSetEditable (UWidget::VIEW);
	}
	else if (findArea->uIsEditable())
	{
		bg = "#FFFFFF";
		((UTextFrame*)component[REPLACE_TEXT])->uSetBackground (bg.getPixel());
		((UTextFrame*)component[REPLACE_TEXT])->uSetEditable (UWidget::EDITABLE);
	}
	else
	{
		bg = background;
		((UTextFrame*)component[REPLACE_TEXT])->uSetBackground (bg.getPixel());
		((UTextFrame*)component[REPLACE_TEXT])->uSetEditable (UWidget::VIEW);
	}
}

#define MAXVLE(_a, _b) ((_a>_b)?_a:_b)

const UBestSize&
UFindDialog::getBestSize ()
{
	UBestSize	bsComp[COMP_MAX];
	int		tHeight;
	int		accY;
	int 		i;

#ifdef DEBUG
	UEvent		event;

	XFlush (top->display);
	while (XPending (top->display) !=0)
	{
		UNextEvent (top, &event);
		UDispatchEvent (top, &event);
	}
#endif
	for (i=0; i<(int)COMP_MAX; i++)
	{
		bsComp[i] = component[i]->getBestSize ();
	}

	bsComp[FIND].width = MAXVLE (bsComp[FIND].width, bsComp[CANCEL].width);
	bsComp[FIND].width = MAXVLE (bsComp[FIND].width, bsComp[REPLACE].width);
	bsComp[CANCEL].width = bsComp[FIND].width;
	bsComp[REPLACE].width = bsComp[FIND].width;
	bsComp[FIND_LABEL].width = MAXVLE  (bsComp[REPLACE_LABEL].width,
		bsComp[FIND_LABEL].width);
	bsComp[REPLACE_LABEL].width = bsComp[FIND_LABEL].width;

	bsComp[FIND_TEXT].width = MAXVLE (bsComp[FIND_TEXT].width, bsComp[FIND_LABEL].width);
	bsComp[REPLACE_TEXT].width = MAXVLE (bsComp[REPLACE_TEXT].width, bsComp[REPLACE_LABEL].width);

	bestSize.width = MAXVLE (bsComp[FIND].width 
		+ bsComp[REPLACE].width + bsComp[CANCEL].width,
		bsComp[FIND_LABEL].width + bsComp[FIND_TEXT].width);
	bestSize.width = MAXVLE (bestSize.width,
		bsComp[REPLACE_LABEL].width + bsComp[REPLACE_TEXT].width);


	tHeight = MAXVLE (bsComp[FIND_LABEL].height, bsComp[FIND_TEXT].height);

	accY =  MARGIN;
	component[FIND_LABEL]->place (MARGIN, 
		(tHeight-bsComp[FIND_LABEL].height)/2+accY, 
		-bsComp[FIND_LABEL].width - MARGIN,
		-((tHeight+bsComp[FIND_LABEL].height)/2+accY)); 

	component[FIND_TEXT]->place (bsComp[FIND_LABEL].width + MARGIN, 
		(tHeight-bsComp[FIND_TEXT].height)/2+accY, MARGIN,
		-((tHeight+bsComp[FIND_TEXT].height)/2+accY)); 

	accY = tHeight + MARGIN;

	component[REPLACE_LABEL]->place (MARGIN, 
		(tHeight-bsComp[REPLACE_LABEL].height)/2+accY, 
		-bsComp[REPLACE_LABEL].width - MARGIN,
		-((tHeight+bsComp[REPLACE_LABEL].height)/2+accY)); 

	component[REPLACE_TEXT]->place (bsComp[REPLACE_LABEL].width + MARGIN, 
		(tHeight-bsComp[REPLACE_TEXT].height)/2+accY, MARGIN,
		-((tHeight+bsComp[REPLACE_TEXT].height)/2+accY)); 

	bestSize.height = bsComp[FIND].height + 2 * tHeight;

	component[CANCEL]->place (-bsComp[CANCEL].width-MARGIN, 
			-bsComp[CANCEL].height-MARGIN, 
			MARGIN, MARGIN);
	component[FIND]->place (MARGIN, -bsComp[FIND].height-MARGIN, 
			-bsComp[FIND].width-MARGIN, MARGIN);

	bestSize.width += 2*MARGIN;

	component[REPLACE]->place ((bestSize.width-bsComp[REPLACE].width)/2, 
			-bsComp[REPLACE].height-MARGIN, 
			-(bestSize.width+bsComp[REPLACE].width)/2, MARGIN);

	bestSize.height += 3*MARGIN;

	minimumWidth = bestSize.width;
	minimumHeight = bestSize.height;
	if (rectangle.width > bestSize.width) bestSize.width = rectangle.width;
	if (rectangle.height > bestSize.height) bestSize.height = rectangle.height;
	findResult = 2;
	return bestSize;
}

//
// This dialog is designed not to be modal. There is a modal interface
// anyway..
//
UDialog::UValue
UFindDialog::getValue()
{
	lastButton = CANCEL;
	((UTextFrame*)component[FIND_TEXT])->setFocus();
	UDialog::getValue();
	return  (UDialog::CANCEL);
}

void
UFindDialog::setButtonFont (UFont* font_)
{
	component[FIND]->setFont (font_);
	component[CANCEL]->setFont (font_);
	component[REPLACE]->setFont (font_);
}

void
UFindDialog::setTextFont (UFont* font_)
{
	component[FIND_LABEL]->setFont (font_);
	component[REPLACE_LABEL]->setFont (font_);
}

void
UFindDialog::setEntryFont (UFont* font_)
{
	((UTextFrame*)component[FIND_TEXT])->uSetFont (font_);
	((UTextFrame*)component[FIND_TEXT])->uRefresh();
	((UTextFrame*)component[REPLACE_TEXT])->uSetFont (font_);
	((UTextFrame*)component[REPLACE_TEXT])->uRefresh();
}

int
UFindDialog::setEncoding (const char* enco_)
{
	if (((UTextFrame*)component[FIND_TEXT])->uSetConverter (enco_)
		== UString::ERROR)
	{
		return 0;
	}
	((UTextFrame*)component[REPLACE_TEXT])->uSetConverter (enco_);
	return 1;
}

int
UFindDialog::setInput (const char* input_)
{
	if (strcasecmp (input_, "Straight") ==0
		|| strcasecmp (input_, "None")==0)
	{
		((UTextFrame*)component[FIND_TEXT])->uSetInput (0);
		((UTextFrame*)component[REPLACE_TEXT])->uSetInput (0);
		return 1;
	}
	if (((UTextFrame*)component[FIND_TEXT])->uSetInput (input_)
		== UWidget::ERROR)
	{
		return 0;
	}
	((UTextFrame*)component[REPLACE_TEXT])->uSetInput (input_);
	return 1;
}

void
UFindDialog::setText (USubComponent comp_, const char* utf8_)
{
	switch (comp_)
	{
	case CANCEL:
	case FIND:
	case REPLACE:
		((UTextButton*) component[comp_])->setText (utf8_);
		break;
	case FIND_LABEL:
	case REPLACE_LABEL:
		((UTextLabel*) component[comp_])->setText (utf8_);
		break;
	default:
		break;
	}
}

void	
UFindDialog::eventUp (UEvent* event)
{
	AString			newDir;
	UBestSize		bs;
	const UCS2* const* 	ucs2;
	const UCS2* const* 	ucs2R;

	switch (event->type)
	{
	case UEvent::ACTIVATED:
		if (event->client !=0 && event->client==component[CANCEL])
		{
			lastButton = CANCEL;
			hide ();
			return;
		}
		if (event->client !=0 && event->client==component[REPLACE])
		{
			if (findArea==0 || !findArea->uIsEditable()) return;
			if (findResult<0)
			{
				ucs2 = ((UTextFrame*)component[FIND_TEXT])->uGetTextBuffer ();
				if (ucs2 != 0)
				{
					findResult=findArea->uFindUCS2 (ucs2[0],
						(findResult==-1) ? 1 : 0);
				}
				else
				{
					findResult=-1;
				}
			}
			if (findResult<0) return;
			ucs2R = ((UTextFrame*)component[REPLACE_TEXT])->uGetTextBuffer ();
			if (ucs2R != 0)
			{
				findArea->uReplaceUCS2 (ucs2R[0]);
			}
			else
			{
				findArea->uReplaceUCS2 ((UCS2*) 0);
			}
			findResult = -2;
			return;
		}
		if (event->client !=0 && event->client==component[FIND])
		{
			if (findArea==0) return;
			ucs2 = ((UTextFrame*)component[FIND_TEXT])->uGetTextBuffer ();
			if (ucs2 != 0)
			{
				findResult = findResult=findArea->uFindUCS2 (ucs2[0],
					(findResult==-1) ? 1 : 0);
			}
			else
			{
				findResult=-1;
			}
			return;
		}
		break;
	case UEvent::SCROLL_RANGE_HORIZONTAL:
		if (event->client !=0 && event->client==component[FIND_TEXT])
		{
			((UTextFrame*)component[FIND_TEXT])->uHScroll (event->value);
		}
		if (event->client !=0 && event->client==component[REPLACE_TEXT])
		{
			((UTextFrame*)component[REPLACE_TEXT])->uHScroll (event->value);
		}
		break;
	default:
		UShell::eventUp (event);
		break;
	}
}

int
UFindDialog::setXInput (const char* name_, const char* imIn,
	const char* inputStyleIn, const char* textType,
	const char* uStringIn, const char* fontMap, double versionIn)
{
	((UTextFrame*)component[REPLACE_TEXT])->setXInput (name_, imIn,
		inputStyleIn, textType, uStringIn, fontMap, versionIn);
	((UTextFrame*)component[FIND_TEXT])->setXInput (name_, imIn,
		inputStyleIn, textType, uStringIn, fontMap, versionIn);
	return 0;
}
