//  UTextDialog.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __utext_dialog_h__
#define __utext_dialog_h__

#include "UFont.h"
#include "UDialog.h"
#include "UTextButton.h"
#include "UTextLabel.h"

class UTextDialog : public UDialog
{
public:
	// cancel, ok-and-cancel
	enum UStyle 	{BCANCEL=0, BOK=1};
			// This creates a modal dialog. 
			// It centers in the middle of
			// transient. Transient should be a shell for widgets
			// with frame
			UTextDialog (UShell* transient, 
				UStyle style=BCANCEL, 
				int frameSize=2);
			UTextDialog (UTop* top_, 
				UStyle style=BCANCEL, 
				int frameSize=2);
	virtual		~UTextDialog ();
			// pop up, get value after popped down.
	virtual UValue	getValue();
	void		setButtonFont (UFont* font_);
	void		setButtonText (UStyle button_, const char* utf8_);
	void		setTextFont (UFont* font_);
	void		setText (const char* utf8_);
	void		eventUp (UEvent* event);
	const UBestSize&	getBestSize ();
private:
	void		setUp();
	UStyle		lastButton;
	UStyle		dialogStyle;
	UTextButton*	button[2];
	UTextLabel*	label;
};

#endif /* __utext_dialog_h_ */
