//  UTextFrame.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UShell.h"
#include "UTextFrame.h"
#include "UEvent.h"
#include <strings.h>
#define XK_MISCELLANY
#define XK_LATIN1
#include <X11/keysymdef.h>

#define BLINK_TIME 500

#define EVENT_MASK ( ButtonPressMask | ButtonReleaseMask | \
	ButtonMotionMask | \
	EnterWindowMask | LeaveWindowMask | \
	ExposureMask | \
	StructureNotifyMask | SubstructureRedirectMask | \
	NoEventMask | PropertyChangeMask)

UTextFrame::UTextFrame (UFrame* parent_, int frsize) :
	UFrame (parent_, frsize),
	UWidget ("Yudit", MULTILINE_SCROLL, EDITABLE)
{
	uSetWidget (top->display, window);
	select (EVENT_MASK);

	uSetBackground (background.getPixel());
	uSetForeground (foreground.getPixel());
	blinkTimer = 0;
	xInput = 0;
	xInputFont = 0;
	xInputFontMap = 0;
}

UTextFrame::~UTextFrame ()
{
	if (blinkTimer) top->deleteTimer ((unsigned long) window, blinkTimer);
	if (xInputFont!=0)
	{
		delete xInputFont;
	}
	if (xInputFontMap!=0)
	{
		// no unuse for now.
		xInputFontMap = 0;
	}
	if (xInput!=0)
	{
		xInput->uEnd();
		uSetXInput (0);
		delete xInput;
	}
}

const UBestSize&
UTextFrame::getBestSize ()
{
	bestSize.height = uMinimumWidth()+2*placement.margin+2*frameSize;
	bestSize.width =  uMinimumHeight()+2*placement.margin+2*frameSize;
	return bestSize;
}

void
UTextFrame::setFont (UFont* font_)
{
	UFrame::setFont (font_);
	uSetFont (font_);
}

void 
UTextFrame::setBackground (const UColor& color)
{
	UFrame::setBackground(color);
	uSetBackground (background.getPixel());
} 

void 
UTextFrame::setBackground (const char* color)
{
	background = color;
	setBackground (background);
}

void 
UTextFrame::setForeground (const UColor& color)
{
	UFrame::setForeground(color);
	uSetForeground (foreground.getPixel());
} 

void 
UTextFrame::setForeground (const char* color)
{
	foreground = color;
	setForeground (foreground);
}

void
UTextFrame::resize (int width, int height)
{
	if (frameSize>0)
	{
		XClearArea (UTOP->display, window, 
			rectangle.width-frameSize, 
			0, frameSize, frameSize, False);
		XClearArea (UTOP->display, window, 
			0, rectangle.height-frameSize, 
			frameSize, frameSize, False);
	}
	rectangle.width = width;
	rectangle.height = height;
	XResizeWindow (top->display, window, width, height);
	uResize (width-2*frameSize, height-2*frameSize, frameSize, frameSize);
	UFrame::redraw (0, 0, width, height);
}

void 
UTextFrame::redraw (int x, int y, int width, int height)
{
	if (!isShown(this)) return;
	UFrame::redraw (x, y, width, height);
	uRedraw (x, y, width, height);
}

void
UTextFrame::uSetVScroll (int value, int step, int page, int max)
{
	UEvent	event;

	event.type = UEvent::SCROLL_RANGE_VERTICAL;
	event.value = value; event.step = step;
	event.page = page; event.max = max;
	event.client = this;
	parent->eventUp (&event);
}

void
UTextFrame::uSetHScroll (int value, int step, int page, int max)
{
	UEvent	event;

	event.type = UEvent::SCROLL_RANGE_HORIZONTAL;
	event.value = value; event.step = step;
	event.page = page; event.max = max;
	event.client = this;
	parent->eventUp (&event);
}

void
UTextFrame::eventDown (UEvent* event)
{
	UFrame::eventDown (event);
	KeySym		key;
	int		count;
	char		asci[16];
	UFrame*		topFrame;

	switch (event->type)
	{
		case UEvent::TIMER:
			if (event->client==blinkTimer)
			{
				uBlinkCursor (0);
				blinkTimer= top->addTimer (
					(unsigned long) window, BLINK_TIME);
			}
			break;
		case UEvent::X:
		switch (event->xevent.type)
		{
		case ConfigureNotify:
			break;
		case LeaveNotify:
			break;
		case EnterNotify:
			break;
		case ButtonPress:
			if (blinkTimer==0 && uIsEditable())
			{
				setFocus ();
			}
			uHandleEvent (&event->xevent);

			break;
		case FocusIn:
			// focus should be handled by the shell.
			if (event->xevent.xany.window == window)
			{
				setFocus();
				return;
			}
			if (blinkTimer==0)
			{
				uBlinkCursor (0);
				blinkTimer= top->addTimer ((unsigned long) window, BLINK_TIME);
			}
			break;
		case FocusOut:
			if (blinkTimer!=0)
			{
				top->deleteTimer ((unsigned long) window, 
					blinkTimer);
				blinkTimer=0;
			}
			uBlinkCursor (1);
			break;
		case KeyPress:
			topFrame = this;
			while (topFrame->getParent ()!=0)
			{
				topFrame = (UFrame*) (topFrame->getParent());
			}
			if (((UShell*)topFrame)->filterKeyEvent (&event->xevent))
			{
				break;
			}
			if (event->xevent.xany.send_event && uXInputActive)
			{
				count = XLookupString( &event->xevent.xkey, 
					asci, 16, &key, 0 );
				if (event->xevent.xkey.state & ControlMask) switch(key)
				{
				case XK_x:
				case XK_X:
					uXInput->uEnd ();
					uXInputActive = 0;
					return;
				default:
					break;
				}
				if (key==XK_Escape)
				{
					uXInput->uEnd ();
					uXInputActive = 0;
					return;
				}
			}
		default:
			uHandleEvent (&event->xevent);
		}
	default:
		break;
	}
}

void
UTextFrame::setFocus()
{
	UEvent	event;

	event.client = this;
	event.window = window;
	event.type = UEvent::KEY_FOCUS;
	parent->eventUp (&event);
}

int
UTextFrame::isA (UComponent::UType type_)
{
	if (type_ == UComponent::TEXT_FRAME) return 1;
	return UFrame::isA (type_);
}

int
UTextFrame::setXInput (const char* name_, const char* imIn,
	const char* inputStyleIn, const char* textType,
	const char* uStringIn, const char* fontMap, double versionIn)
{
	UXInput::UInputStyle    inputStyle;

	if (xInputFont!=0)
	{
		delete xInputFont;
		xInputFont = 0;
	}
	if (xInputFontMap!=0)
	{
		xInputFontMap = 0;
	}
	if (xInput!=0)
	{
		xInput->uEnd();
		uSetXInput (0);
		delete xInput;
		xInput =0;
	}
	if (name_==0 || strcasecmp (name_, "None") ==0)
	{
		return 0;
	}

	// Get the fonts
	xInputFontMap = UGetFontMap (fontMap);
	if (xInputFontMap==0)
	{
		cerr << "error: can not get fontmap '" << fontMap << "'.\n";
		return -1;
	}
	uSetCursor (UCursor::WAIT, 1);
	xInputFont = new UFontX11 (xInputFontMap, top->display, top->screen);

	inputStyle = UXInput::UOFF;
	if (strcasecmp (inputStyleIn, "Root")==0)
	{
		inputStyle = UXInput::UROOT;
	}
	if (strcasecmp (name_, "Kinput2")==0)
	{
		xInput = new UUXKinput ((UTop*)top, this);
		if (xInput->uSetup (imIn, inputStyle,
			textType, uStringIn, xInputFont,
			(float) versionIn) != UXInput::OK)
		{
			delete xInput;
			xInput = 0;
			cerr << "error: can not set up xInput..";
			uSetCursor (UCursor::INSERT, 1);
			return -1;
		}
		uSetXInput (xInput);
		uSetCursor (UCursor::INSERT, 1);
		return 0;
	}
	uSetCursor (UCursor::INSERT, 1);
	return -1;
}

void
UTextFrame::clearSelection ()
{
	uClipboardClear ();
}

void
UTextFrame::uClipboardPut (const unsigned char * text)
{
	((UTop*)top)->putClipboard (window, text, UStrLen (text));
}

unsigned char*
UTextFrame::uClipboardGet ()
{
        char*   		chr;
	const unsigned char*	got;
	int			len;

	got = ((UTop*)top)->getClipboard (window, &len);
	if (got==0) return 0;
        chr = new char [len+4];
        CHECKNULL (chr);
        memcpy (chr, (const char*) got, len);
        // our string is double null terminated
	chr[len] = 0;
        chr[len+1] = 0;
        chr[len+2] = 0;
        chr[len+3] = 0xff;
        return (unsigned char*) chr;
}

