//  UTextLabel.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __utextlabel_h__
#define __utextlabel_h__
#include "UComponent.h"
#include <UFont.h>
#include "UFrame.h"
#include <UCommon.h>

//
// This is a very light version of yudit edit area.
//
class UTextLine
{
public:
	enum UDrawType { MEASURE, NORMAL, NORMAL_FILL, REVERSE };
	enum UAlign { LEFT, RIGHT, CENTER };
			UTextLine (const UCS2* in, int from, int to);
			~UTextLine ();
	UCS2*		text;
	short		textSize;
	short		length; // length with a font
	short		coordx;
	UDrawType	drawType;
};

class UTextLabel : public UComponent
{
public:
				UTextLabel (UFrame* parent, 
					const char* text_=0,
					UTextLine::UAlign align_=UTextLine::LEFT);
	virtual			~UTextLabel();
	const UCS2*		getText (int line_);
	void			setText (const UCS2* text);
	void			setText (const unsigned char* text);
	void			setText (const char* text);
	void			setAlignment (UTextLine::UAlign align);
	// Using the same window...
	void			setInsets (int west, int east);
	virtual void 		redraw (int x, int y, int width, int height);
	virtual void 		move (int x, int y);
	virtual void 		resize (int width, int height);
	virtual int		isA (UComponent::UType type);

	// return the length
	int			drawLine (int lineNo, UTextLine::UDrawType dt);

	virtual void 		setBackground (const UColor& color);
	virtual void 		setBackground (const char* color);
	virtual void 		setForeground (const UColor& color);
	virtual void 		setForeground (const char* color);
	// including insets
	virtual void 		setFont (UFont* font);
	virtual void		eventDown (UEvent* event);
	void 			selectLine (int line_);
	void 			unselectLine (int line_);
	virtual void		setMargin (int m);
protected:
	void			calculateBestSize ();
	int 			drawSegment (UFontCache* fnt, 
					UTextLine::UDrawType dt, int coordx,
					int lineNo, int from, int to);
	GC			fgGC;
	GC			rvGC;
	GC			rvfGC;
	UFrame*			parent;
	UFont*			font;
	UTextLine**		line;
	UTextLine::UAlign	alignment;
	short			lineCount;
	short			alignWest;
	short			alignEast;
	short			baseCoord;
	int			vertOffset;
};
#endif /* __utextlabel_h__ */
