//  UTopContext.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UTopContext.h"
#include "UComponent.h"
#include <X11/Xatom.h>

#include <strings.h>
#include <sys/types.h>
#include <iostream.h>

#ifdef __sun__
#ifndef __svr4__
extern "C" 
{
void bzero(void *s, size_t n);
int gettimeofday(struct timeval *, void *);
int select (int width, fd_set* readfds, fd_set* writefds, 
  			fd_set* exceptfds, struct timeval* timeout);
}
#endif
#endif


UTopContext::UTopContext (void)
{
	connectionId=-1;
	FD_ZERO (&fdRead);
	FD_ZERO (&fdExcept);
	focusWindow = None;

	clipBuffer = 0;
	clipLength = 0;
	clipOwner = None;
}

UTopContext::~UTopContext ()
{
}

void
UTopContext::eventLoop ()
{
	UEvent	event;
	do
	{
		event.client = 0;
		UNextEvent (this, &event);
		UDispatchEvent (this, &event);
	} while (shell.getSize() > 0);
	XFlush (display);
}


void
UNextEvent (UTopContext* top, UEvent *event)
{
	unsigned long	nextTime;
	struct timeval	now;
	struct timeval	next;
	struct timeval	timeDiff;
	XEvent		xevent;
	UEvent*		client;
	fd_set		fdReadOut;
	fd_set		fdExceptOut;
	int		selected;
	
	if (top->connectionId==-1)
	{
		top->connectionId = XConnectionNumber (top->display);
		FD_SET (top->connectionId, &top->fdRead);
		FD_SET ( top->connectionId, &top->fdExcept);
		top->maxFD = top->connectionId;
		gettimeofday (&top->timerBase, 0);
	}
	if (top->timer.getSize() != 0 && XPending (top->display) == 0)
	{
		nextTime = top->timer.keyAt(0);
		client = (UEvent*) top->timer.at (0);

		next.tv_usec = top->timerBase.tv_usec + (nextTime%1000)*1000;
		next.tv_sec = top->timerBase.tv_sec + (nextTime/1000);
		next.tv_sec += next.tv_usec / 1000000;
		next.tv_usec = next.tv_usec % 1000000;

		gettimeofday (&now, 0);
		timeDiff.tv_sec=0;
		timeDiff.tv_usec=0;

		if (next.tv_sec < now.tv_sec ||
	  	  (next.tv_sec ==now.tv_sec && next.tv_usec < now.tv_usec))
		{
			timeDiff.tv_sec = 0;
			timeDiff.tv_usec = 0;
		}
		else if (now.tv_sec <  next.tv_sec)
		{
			timeDiff.tv_sec = next.tv_sec - now.tv_sec-1;
			timeDiff.tv_usec = next.tv_usec + 1000000 -  now.tv_usec;
			timeDiff.tv_sec += timeDiff.tv_usec / 1000000;
			timeDiff.tv_usec = timeDiff.tv_usec % 1000000;
		} 
		else if (now.tv_sec == next.tv_sec)
		{
			timeDiff.tv_usec =  (next.tv_usec > now.tv_usec) ?
				next.tv_usec - 	now.tv_usec : 0;
		}
		fdReadOut = top->fdRead;
		fdExceptOut = top->fdExcept;
		do {
			selected = select (top->maxFD+1, &fdReadOut, 0,
				&fdExceptOut, &timeDiff);
		} while (selected == -1);

		
		if (selected == 0)
		{
			// dispatch the timer event
			top->timer.deleteItem (nextTime, client);
			*event = *client;
			event->client = client;
			event->type = UEvent::TIMER;
			// this timer event has been deleted 
			if (top->timerId.deleteItem (client->window, client) != UBinArray::OK)
			{
				// dispatch deleted timer event
				event->type = UEvent::NONE;
			}
			// once the event got deleivered we can use the same id
			delete client;
			return;
		}
		// not it can be only connectionId...
	}
	
	XNextEvent (top->display, &xevent);
	top->clipEvent (&xevent);
	event->xevent = xevent;
	event->type = UEvent::X;
	return;
}

void*
UTopContext::addTimer (Window w, unsigned long timeout)
{
	UEvent* 	event;
	unsigned long	nextTime;
	long		diff;
	struct timeval	now;
	struct timeval	timeDiff;

	event = new UEvent();
	event->type = UEvent::TIMER;
	event->window = w;

	// renumber the current que
	nextTime = timer.keyAt(0);
	gettimeofday (&now, 0);

	// get difference between now and timerBase
	timeDiff.tv_sec=0;
	timeDiff.tv_usec=0;

	// see if time goes backwards on this machine :)
	if (now.tv_sec < timerBase.tv_sec||
	  (now.tv_sec ==timerBase.tv_sec && now.tv_usec < timerBase.tv_usec))
	{
		timeDiff.tv_sec = 0;
		timeDiff.tv_usec = 0;
	}
	else if (now.tv_sec > timerBase.tv_sec)
	{
		timeDiff.tv_sec = now.tv_sec - timerBase.tv_sec-1;
		timeDiff.tv_usec = now.tv_usec + 1000000 -  timerBase.tv_usec;
		timeDiff.tv_sec += timeDiff.tv_usec / 1000000;
		timeDiff.tv_usec = timeDiff.tv_usec % 1000000;
	}
	else if (now.tv_sec == timerBase.tv_sec)
	{
		timeDiff.tv_usec =  (now.tv_usec > timerBase.tv_usec) ?
			(now.tv_usec - 	timerBase.tv_usec) : 0;
	}
	diff = timeDiff.tv_usec/1000 + timeDiff.tv_sec*1000;
	if (diff > (long) nextTime) diff = nextTime;
	if (diff > 0) timer.reIndex (-diff);
	timerBase = now;
	
	timerId.addItem (w, event);
	timer.addItem (timeout, event);
	return event;
}

void*
UTopContext::deleteTimer (Window w,  void* id)
{
	if (timerId.deleteItem (w, id) != UBinArray::OK) return 0;
	return id;
}

void
UDispatchEvent (UTopContext* top, UEvent *event)
{
	UComponent*	comp;
	Window		w;
	UEventHandler*	handler;
	int		i;

	switch (event->type)
	{
	case UEvent::NONE:
		break;
	case UEvent::TIMER:
		w = event->window;
		comp = (UComponent*) (top->component.findItem ((unsigned long) w));;
		if (comp!=0)
		{
			comp->eventDown (event);
		}
		break;
	case UEvent::X:
		w = event->xevent.xany.window;
		comp = (UComponent*) (top->component.findItem ((unsigned long) w));;
		if (comp!=0) comp->eventDown (event);
		// go through list and dispatch events 
	
		for (i=0; (handler=(UEventHandler*) top->eventHandler.findItem (
			NoEventMask, i))!=0; i++)
		{
			handler->getEvent (event);
		}
		for (i=0; (handler=(UEventHandler*) top->eventHandler.findItem (
			event->xevent.xany.type, i))!=0; i++)
		{
			handler->getEvent (event);
		}
		break;
	default:
		break;
	}
}

void
UTopContext::clipEvent (XEvent* event)
{
}
