//  UString.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// Gaspar Sinai 3 September 1997
//

#ifndef __ustring_h__
#define __ustring_h__

#include <UMap.h>
#include <UCS2Conv.h>


//
//
//
class UString
{
public:
	enum UStatus		{OK, ERROR};

				~UString ();
				UString ();
				UString (const unsigned char* string);
				UString (const unsigned char* string, 
					const char* converter);
				UString (const UCS2* string);

				UString (UCS2Converter* converterIn,
					const char* converterName);

	unsigned char*		getString ();
	UCS2*			getUString ();
	void			putString (const unsigned char* str);
	void			putUString (const UCS2* str);
	UStatus			setConverter (const char* nameConverter);

	inline const char*	getConverter () const { return converterName; }

	operator 		const UCS2* () const;
protected:
	UCS2			*string;

	UCS2*			decode (const unsigned char* string);
	unsigned char*		encode (const UCS2* string);
	UStatus			addConverter (UCS2Converter* converterIn, 
					const char* nameConverter);
	int			size (const UCS2* string) const;

private:
	UCS2Converter* 		converter;
	char*			converterName;
};

#endif /* __ustring_h__ */
