//  UWidgetX.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//

#ifndef __uwidgetb_x__
#define __uwidgetb_x__

#include "UFont.h"
#include "UCursor.h"
#include "UXInput.h"

class UPoint
{
public:
	int		posX;
	int		posY;
	int		coordX;
	int		coordY;
	int friend operator< (const UPoint& p0, const UPoint& p1);
	int friend operator<= (const UPoint& p0, const UPoint& p1);
	int friend operator> (const UPoint& p0, const UPoint& p1);
	int friend operator>= (const UPoint& p0, const UPoint& p1);
	int friend operator== (const UPoint& p0, const UPoint& p1);
	int friend operator!= (const UPoint& p0, const UPoint& p1);
};

//             width
//             <-+->
// coordXPrev  coordX 
// |             |
// <---fontSize-->
//
typedef struct _UCursorBox
{
	UPoint	before;
	UPoint	at;
	int	posNeedX;
	int	width;
	int	height;
} UCursorBox;


class UWidgetX
{
public:
				UWidgetX ();
	virtual			~UWidgetX ();

	inline const Window	uGetWindow () {return uWindow;}
	inline Display*		uGetDisplay () {return uDisplay;}
	inline const int	uGetScreen () {return uScreen;}
	inline const UCursorBox&	uGetCursorBox () {return uCursorBox;}
	inline const unsigned long	uGetBackground () {return uBackground;}
	inline const unsigned long	uGetForeground () {return uForeground;}
	inline const unsigned long	uGetCursorColor () {return uCursorColor;}
	inline	int			uGetRealCoordX (int virtualX)
					{
						return virtualX + uCornerX + 
							uBorderSize - uX;
					}
	inline	int			uGetRealCoordY (int virtualY)
					{
						return virtualY + uCornerY + 
							uBorderSize - uY;
					}
	virtual void 			uInsertUCS2 (const UCS2 *ucs2, 
					const int moveCursor=1, 
					const int newLineIn=0);
	virtual void 			uSetCursorViewable () {};

	inline int 			uGetWidth () 
					{ return uWidth; };
	inline int 			uGetCornerX () 
					{ return uCornerX; };
	inline int 			uGetHeight () 
					{ return uHeight; };
	inline int 			uGetCornerY () 
					{ return uCornerY; };
	// these are called by xinput
	virtual void		uXIMStart ();
	virtual void		uXIMEnd ();
	virtual void		uXIMFail ();
	virtual void		uSetCursor (const UCursor::UType type, 
					const int all=0) {};
	int			uXInputActive;
	int			uXInputHeight;
	UFont*			uGetFont () 
				{ return uFont; }
	virtual void		uResize (const int widthIn, const int heightIn,
					const int cornerX=0, 
					const int cornerY=0) {};
	virtual int		uDeleteSelection ();

protected:
	UFont* 			uFont;
	Window			uWindow;
	Display*		uDisplay;
	int			uScreen;
	UCursorBox		uCursorBox;
	unsigned long 		uCursorColor;
	unsigned long 		uBackground;
	unsigned long 		uForeground;

	UCursor*		uCursor;

	GC			ugc;
	GC			ucgc;
	GC			urgc;

	int			uWidth;
	int			uHeight;

	// Virtual things. x and y shows scroll amount
	int			uX;
	int			uY;
	int			uCornerX;
	int			uCornerY;
	int			uFullWidth;
	int			uFullHeight;

	enum UBorderSize {uBorderSize=3 };

};

#endif /* __uwidgetx_h__ */
